/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.endertrigon.common.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraftforge.common.ForgeConfigSpec;
import nonamecrackers2.crackerslib.common.config.ConfigHelper;
import nonamecrackers2.endertrigon.common.init.EnderTrigonDragonPhases;
import org.apache.commons.lang3.tuple.Pair;

public class EnderTrigonConfig {
    public static final List<String> CANNOT_BE_TOGGLED = ImmutableList.of((Object)"CarryPlayer", (Object)"ChargeUp");
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair commonPar = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)((Object)commonPar.getLeft());
        COMMON_SPEC = (ForgeConfigSpec)commonPar.getRight();
    }

    public static class CommonConfig
    extends ConfigHelper {
        public final Map<String, BooleanSupplier> enabledCustomDragonPhases;
        public final ForgeConfigSpec.ConfigValue<Boolean> skipLandingPhase;
        public final ForgeConfigSpec.ConfigValue<Boolean> crashPhaseDestroysBlocks;
        public final ForgeConfigSpec.ConfigValue<Integer> maxBabyEnderDragons;
        public final ForgeConfigSpec.ConfigValue<Integer> attacksUntilPerch;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            super(builder, "endertrigon");
            builder.comment("Enaled Custom Phases").push("enabled_custom_phases");
            this.enabledCustomDragonPhases = (Map)EnderTrigonDragonPhases.CUSTOM_DRAGON_PHASES.entrySet().stream().map(e -> {
                BooleanSupplier supplier;
                if (CANNOT_BE_TOGGLED.contains(e.getKey())) {
                    supplier = () -> true;
                } else {
                    ForgeConfigSpec.ConfigValue config = this.createValue(true, "enable" + (String)e.getKey(), true, "Specifies if this custom dragon phase should be enabled or not");
                    supplier = () -> ((ForgeConfigSpec.ConfigValue)config).get();
                }
                return Map.entry((String)e.getKey(), supplier);
            }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            builder.pop();
            this.skipLandingPhase = this.createValue(true, "skipLandingPhase", false, "Specifies if the landing phase should have a much higher chance to be skipped. Makes the fight quicker by avoiding long dull periods where the Ender Dragon is flying for a long time, before it perches");
            this.crashPhaseDestroysBlocks = this.createValue(true, "crashPhaseDestroysBlocks", false, "Specifies if the crash phase should cause blocks to be flung");
            this.maxBabyEnderDragons = this.createRangedIntValue(4, 1, 16, "maxBabyEnderDragons", false, "Specifies the max amount of baby ender dragons the Ender Dragon can spawn during its hatching (dive bomb) phase");
            this.attacksUntilPerch = this.createRangedIntValue(4, 1, 16, "attacksUntilPerch", false, "Specifies the amount of special attacks, plus the amount of remaining end crystals, the dragon must do until it can potentially perch");
        }
    }
}

