/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.endertrigon.client.renderer.entity.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import nonamecrackers2.endertrigon.EnderTrigonMod;
import nonamecrackers2.endertrigon.common.entity.BabyEnderDragon;

public class BabyEnderDragonModel
extends EntityModel<BabyEnderDragon> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EnderTrigonMod.id("baby_ender_dragon"), "main");
    private final ModelPart head;
    private final ModelPart neck;
    private final ModelPart[] neckPieces;
    private final ModelPart jaw;
    private final ModelPart body;
    private final ModelPart leftWing;
    private final ModelPart leftWingEnd;
    private final ModelPart rightWing;
    private final ModelPart rightWingEnd;
    private final ModelPart tail;
    private final ModelPart[] tailPieces;
    private final ModelPart frontRightArm;
    private final ModelPart frontLeftArm;
    private final ModelPart backRightLeg;
    private final ModelPart rightLegAppendage;
    private final ModelPart rightLegAppendage2;
    private final ModelPart backLeftLeg;
    private final ModelPart leftLegAppendage;
    private final ModelPart leftLegAppendage2;
    private float partialTicks;
    @Nullable
    private BabyEnderDragon dragon;

    public BabyEnderDragonModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
        this.neckPieces = BabyEnderDragonModel.getPieces(this.neck, "neckPiece", 1);
        this.head = this.neckPieces[this.neckPieces.length - 1].m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.leftWing = this.body.m_171324_("leftWing");
        this.leftWingEnd = this.leftWing.m_171324_("leftEnd");
        this.rightWing = this.body.m_171324_("rightWing");
        this.rightWingEnd = this.rightWing.m_171324_("rightEnd");
        this.tail = this.body.m_171324_("tail");
        this.tailPieces = BabyEnderDragonModel.getPieces(this.tail, "tailPiece", 1);
        this.frontRightArm = this.body.m_171324_("frontRightArm");
        this.frontLeftArm = this.body.m_171324_("frontLeftArm");
        this.backRightLeg = this.body.m_171324_("backRightLeg");
        this.rightLegAppendage = this.backRightLeg.m_171324_("rightLegAppendage");
        this.rightLegAppendage2 = this.rightLegAppendage.m_171324_("rightLegAppendage2");
        this.backLeftLeg = this.body.m_171324_("backLeftLeg");
        this.leftLegAppendage = this.backLeftLeg.m_171324_("leftLegAppendage");
        this.leftLegAppendage2 = this.leftLegAppendage.m_171324_("leftLegAppendage2");
    }

    private static ModelPart[] getPieces(ModelPart root, String child, int start) {
        int i = start;
        ArrayList pieces = Lists.newArrayList();
        ModelPart previous = root;
        while (previous.m_233562_(child + i)) {
            ModelPart part = previous.m_171324_(child + i);
            pieces.add(part);
            previous = part;
            ++i;
        }
        return (ModelPart[])pieces.toArray(ModelPart[]::new);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-3.0f, -2.0f, -5.0f, 6.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(48, 3).m_171488_(-0.5f, -3.0f, -4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(47, 33).m_171488_(-0.5f, -3.0f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(48, 0).m_171488_(-0.5f, -3.0f, 2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)3.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-5.0f));
        PartDefinition neckPiece1 = neck.m_171599_("neckPiece1", CubeListBuilder.m_171558_().m_171514_(44, 36).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(12, 20).m_171488_(-0.5f, -2.0f, -1.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neckPiece2 = neckPiece1.m_171599_("neckPiece2", CubeListBuilder.m_171558_().m_171514_(30, 45).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 22).m_171488_(-0.5f, -2.0f, -1.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition neckPiece3 = neckPiece2.m_171599_("neckPiece3", CubeListBuilder.m_171558_().m_171514_(38, 45).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(6, 20).m_171488_(-0.5f, -2.0f, -1.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition neckPiece4 = neckPiece3.m_171599_("neckPiece4", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(-0.5f, -2.0f, -1.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition head = neckPiece4.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-2.0f, 0.0f, -8.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(22, 32).m_171488_(-3.0f, -2.0f, -5.0f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(45, 42).m_171488_(-2.0f, -3.0f, -4.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(45, 29).m_171488_(1.0f, -3.0f, -4.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, -0.5f, -3.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)-5.0f));
        PartDefinition frontRightArm = body.m_171599_("frontRightArm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.5f, (float)0.5f, (float)-3.5f));
        frontRightArm.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(6, 26).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        frontRightArm.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(46, 46).m_171488_(-0.5f, -0.4793f, 0.1359f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.1311f, (float)3.1683f, (float)-1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition backRightLeg = body.m_171599_("backRightLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)0.5f, (float)3.5f));
        backRightLeg.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-1.5f, -1.5f, -0.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightLegAppendage = backRightLeg.m_171599_("rightLegAppendage", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.1311f, (float)3.1683f));
        rightLegAppendage.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(6, 21).m_171488_(-1.0f, -0.9793f, -0.3641f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition rightLegAppendage2 = rightLegAppendage.m_171599_("rightLegAppendage2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)1.9419f, (float)3.2197f));
        rightLegAppendage2.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(16, 46).m_171488_(-1.0f, -0.5599f, -0.1006f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition backLeftLeg = body.m_171599_("backLeftLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)0.5f, (float)3.5f));
        backLeftLeg.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -1.5f, -0.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegAppendage = backLeftLeg.m_171599_("leftLegAppendage", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.1311f, (float)3.1683f));
        leftLegAppendage.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(0.0f, -0.9793f, -0.3641f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegAppendage2 = leftLegAppendage.m_171599_("leftLegAppendage2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)1.9419f, (float)3.2197f));
        leftLegAppendage2.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(8, 46).m_171488_(-1.0f, -0.5599f, -0.1006f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition frontLeftArm = body.m_171599_("frontLeftArm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.5f, (float)0.6311f, (float)-3.3317f));
        frontLeftArm.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(24, 46).m_171488_(-0.5f, -0.4793f, 0.1359f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)3.0f, (float)-1.0036f, (float)0.0f, (float)0.0f));
        frontLeftArm.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.1311f, (float)-0.1683f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)-2.0f, (float)-4.0f));
        leftWing.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)8.0f, (float)0.0f, (float)8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        leftWing.m_171599_("leftEnd", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(0.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)16.0f, (float)0.0f, (float)8.0f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)-2.0f, (float)-4.0f));
        rightWing.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)0.0f, (float)8.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        rightWing.m_171599_("rightEnd", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-16.0f, 0.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-16.0f, (float)0.0f, (float)8.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition tailPiece1 = tail.m_171599_("tailPiece1", CubeListBuilder.m_171558_().m_171514_(11, 16).m_171488_(-0.5f, -2.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 41).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tailPiece2 = tailPiece1.m_171599_("tailPiece2", CubeListBuilder.m_171558_().m_171514_(11, 16).m_171488_(-0.5f, -2.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 41).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition tailPiece3 = tailPiece2.m_171599_("tailPiece3", CubeListBuilder.m_171558_().m_171514_(11, 16).m_171488_(-0.5f, -2.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 41).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition tailPiece4 = tailPiece3.m_171599_("tailPiece4", CubeListBuilder.m_171558_().m_171514_(11, 16).m_171488_(-0.5f, -2.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 41).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition tailPiece5 = tailPiece4.m_171599_("tailPiece5", CubeListBuilder.m_171558_().m_171514_(11, 16).m_171488_(-0.5f, -2.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 41).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition tailPiece6 = tailPiece5.m_171599_("tailPiece6", CubeListBuilder.m_171558_().m_171514_(11, 16).m_171488_(-0.5f, -2.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 41).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition tailPiece7 = tailPiece6.m_171599_("tailPiece7", CubeListBuilder.m_171558_().m_171514_(11, 16).m_171488_(-0.5f, -2.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 41).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition tailPiece8 = tailPiece7.m_171599_("tailPiece8", CubeListBuilder.m_171558_().m_171514_(11, 16).m_171488_(-0.5f, -2.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 41).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition tailPiece9 = tailPiece8.m_171599_("tailPiece9", CubeListBuilder.m_171558_().m_171514_(11, 16).m_171488_(-0.5f, -2.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 41).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        tailPiece9.m_171599_("tailPiece10", CubeListBuilder.m_171558_().m_171514_(11, 16).m_171488_(-0.5f, -2.0f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 41).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(BabyEnderDragon entity, float p_102615_, float p_102616_, float partialTicks) {
        this.partialTicks = partialTicks;
        this.dragon = entity;
    }

    public void setupAnim(BabyEnderDragon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_20096_()) {
            this.body.f_104203_ = -0.43633232f;
            this.backRightLeg.f_104203_ = -2.443461f;
            this.rightLegAppendage.f_104203_ = 2.5307274f;
            this.rightLegAppendage2.f_104203_ = -2.5307274f;
            this.backLeftLeg.f_104203_ = -2.443461f;
            this.leftLegAppendage.f_104203_ = 2.5307274f;
            this.leftLegAppendage2.f_104203_ = -2.5307274f;
            this.frontRightArm.f_104203_ = -0.7417649f;
            this.frontLeftArm.f_104203_ = -0.7417649f;
        } else {
            this.body.f_104203_ = 0.0f;
            this.backRightLeg.f_104203_ = 0.0f;
            this.rightLegAppendage.f_104203_ = 0.0f;
            this.rightLegAppendage2.f_104203_ = 0.0f;
            this.backLeftLeg.f_104203_ = 0.0f;
            this.leftLegAppendage.f_104203_ = 0.0f;
            this.leftLegAppendage2.f_104203_ = 0.0f;
            this.frontRightArm.f_104203_ = 0.0f;
            this.frontLeftArm.f_104203_ = 0.0f;
        }
        float ticks = (float)entity.f_19797_ + this.partialTicks;
        float flap = Mth.m_14179_((float)this.partialTicks, (float)this.dragon.oFlapTime, (float)this.dragon.flapTime);
        this.jaw.f_104203_ = (float)(Math.sin(flap * ((float)Math.PI * 2) + ticks * 0.1f) + 1.0) * 0.2f;
        double[] baseLatency = entity.getLatency(6, this.partialTicks);
        float flapPi = flap * ((float)Math.PI * 2);
        float roll = (float)Mth.m_14175_((double)(entity.getLatency(5, this.partialTicks)[0] + Mth.m_14175_((double)(entity.getLatency(5, this.partialTicks)[0] - entity.getLatency(10, this.partialTicks)[0])) / 2.0));
        for (int i = 0; i < this.neckPieces.length; ++i) {
            float prevY = 0.0f;
            float prevX = 0.0f;
            float prevZ = 0.0f;
            if (i > 0) {
                ModelPart prev = this.neckPieces[i - 1];
                prevY = prev.f_104204_;
                prevX = prev.f_104203_;
                prevZ = prev.f_104205_;
            }
            ModelPart piece = this.neckPieces[i];
            double[] latency = entity.getLatency(this.neckPieces.length - i, this.partialTicks);
            float xOffset = Mth.m_14089_((float)((float)i * 0.45f + flapPi)) * 0.15f;
            if (entity.m_20096_()) {
                xOffset = (float)((double)xOffset + ((814.0 / (1984.0 + Math.pow(0.006f, -i)) - (double)0.2f) * -20.0 + (double)(-Mth.m_14031_((float)(ticks * 0.15f)) * 0.1f)));
            }
            piece.f_104204_ = (float)Mth.m_14175_((double)(latency[0] - baseLatency[0])) * ((float)Math.PI / 180);
            piece.f_104203_ = (xOffset + (float)baseLatency[1] - (float)latency[1]) * 0.25f;
            piece.f_104205_ = (float)(-Mth.m_14175_((double)(latency[0] - (double)roll))) * ((float)Math.PI / 180);
            piece.f_104204_ -= prevY;
            piece.f_104203_ -= prevX;
            piece.f_104205_ -= prevZ;
        }
        double[] headLatency = entity.getLatency(0, this.partialTicks);
        this.head.f_104204_ = (float)Mth.m_14175_((double)(headLatency[0] - baseLatency[0])) * ((float)Math.PI / 180);
        this.head.f_104203_ = entity.m_20096_() ? 0.34906584f : 0.0f;
        this.head.f_104205_ = (float)(-Mth.m_14175_((double)(headLatency[0] - (double)roll))) * ((float)Math.PI / 180);
        if (!entity.m_20096_()) {
            this.leftWing.f_104203_ = 0.125f - Mth.m_14089_((float)flapPi) * 0.2f;
            this.leftWing.f_104204_ = -0.25f;
            this.leftWing.f_104205_ = -(Mth.m_14031_((float)flapPi) + 0.125f) * 0.8f;
            this.leftWingEnd.f_104205_ = (Mth.m_14031_((float)(flapPi + 2.0f)) + 0.5f) * 0.75f;
        } else {
            this.leftWing.f_104203_ = 0.17453292f;
            this.leftWing.f_104204_ = Mth.m_14031_((float)(ticks * 0.12f)) * 0.05f;
            this.leftWing.f_104205_ = -1.2217305f;
            this.leftWingEnd.f_104205_ = -Mth.m_14031_((float)(ticks * 0.09f)) * 0.1f + 2.7925267f;
        }
        this.rightWing.f_104203_ = this.leftWing.f_104203_;
        this.rightWing.f_104204_ = -this.leftWing.f_104204_;
        this.rightWing.f_104205_ = -this.leftWing.f_104205_;
        this.rightWingEnd.f_104205_ = -this.leftWingEnd.f_104205_;
        for (int i = 0; i < this.tailPieces.length; ++i) {
            float prevY = 0.0f;
            float prevX = 0.0f;
            float prevZ = 0.0f;
            if (i > 0) {
                ModelPart prev = this.tailPieces[i - 1];
                prevY = prev.f_104204_;
                prevX = prev.f_104203_;
                prevZ = prev.f_104205_;
            }
            ModelPart piece = this.tailPieces[i];
            double[] latency = entity.getLatency(12 + i, this.partialTicks);
            float xOffset = Mth.m_14089_((float)((float)i * 0.45f + flapPi)) * 0.05f + (entity.m_20096_() ? -0.2f : 0.0f);
            piece.f_104204_ = (float)(Mth.m_14175_((double)(latency[0] - baseLatency[0])) * 0.25) * ((float)Math.PI / 180);
            piece.f_104203_ = -(xOffset + (float)(baseLatency[1] - (double)((float)latency[1])) * ((float)Math.PI / 180) * 2.5f);
            piece.f_104205_ = (float)Mth.m_14175_((double)(latency[0] - (double)roll)) * ((float)Math.PI / 180) * 0.2f;
            piece.f_104204_ -= prevY;
            piece.f_104203_ -= prevX;
            piece.f_104205_ -= prevZ;
        }
    }

    public void m_7695_(PoseStack stack, VertexConsumer consumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(stack, consumer, packedLight, packedOverlay);
    }
}

