/*
 * Decompiled with CFR 0.152.
 */
package com.github.raverbury.aggroindicator.event;

import com.github.raverbury.aggroindicator.AlertRenderer;
import com.github.raverbury.aggroindicator.config.ClientConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientEventHandler {
    private static final HashMap<String, Boolean> regexListCache = new HashMap();

    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::handleWorldUnloadEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::handleRenderLevelStageEvent);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ClientEventHandler::handleConfigEvent);
    }

    public static void handleConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getSpec() == ClientConfig.INSTANCE) {
            ClientConfig.Cached.reload();
            AlertRenderer.reloadAggroIcon();
            regexListCache.clear();
        }
    }

    public static void handleWorldUnloadEvent(LevelEvent.Unload event) {
        if (!event.getLevel().m_5776_()) {
            return;
        }
        AlertRenderer.clearAggroingMobs();
    }

    public static void handleRenderLevelStageEvent(RenderLevelStageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (!ClientConfig.Cached.RENDER_ALERT_ICON) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player == null || level == null) {
            return;
        }
        List nearbyMobs = level.m_45971_(Mob.class, TargetingConditions.m_148352_().m_26883_((double)ClientConfig.Cached.RENDER_RANGE).m_26893_().m_148355_(), (LivingEntity)player, player.m_20191_().m_82400_((double)ClientConfig.Cached.RENDER_RANGE));
        if (nearbyMobs.isEmpty()) {
            return;
        }
        for (Mob mob : nearbyMobs) {
            if (!ClientEventHandler.shouldDrawAlert((LivingEntity)mob)) continue;
            AlertRenderer.addEntity((LivingEntity)mob);
        }
        AlertRenderer.renderAlertIcon(event.getPartialTick(), event.getPoseStack(), Minecraft.m_91087_().f_91063_.m_109153_());
    }

    public static boolean shouldDrawAlert(LivingEntity clientEntity) {
        boolean PLAYER_HAS_STATUS_BLINDNESS_OR_DARKNESS;
        boolean bl;
        boolean NOT_A_MOB;
        boolean TOO_FAR_AWAY;
        Minecraft minecraftClient = Minecraft.m_91087_();
        Entity cameraEntity = minecraftClient.m_91288_();
        boolean bl2 = TOO_FAR_AWAY = cameraEntity == null || clientEntity.m_20270_(cameraEntity) > (float)ClientConfig.Cached.RENDER_RANGE;
        if (TOO_FAR_AWAY) {
            return false;
        }
        boolean bl3 = NOT_A_MOB = !(clientEntity instanceof Mob);
        if (NOT_A_MOB) {
            return false;
        }
        String entityRegistryName = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)clientEntity.m_6095_())).toString();
        boolean isWhitelist = ClientConfig.Cached.TREAT_BLACKLIST_AS_WHITELIST;
        boolean inList = false;
        if (regexListCache.containsKey(entityRegistryName)) {
            inList = regexListCache.get(entityRegistryName);
        } else {
            for (String string : ClientConfig.Cached.CLIENT_MOB_BLACKLIST) {
                String string2 = string.replace("*", ".*");
                Pattern pattern = Pattern.compile(string2, 2);
                if (!pattern.matcher(entityRegistryName).matches()) continue;
                inList = true;
                break;
            }
            regexListCache.put(entityRegistryName, inList);
        }
        if (isWhitelist && !inList || !isWhitelist && inList) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean bl4 = bl = player == null || clientEntity.m_20177_((Player)player);
        if (bl) {
            return false;
        }
        boolean IS_TARGETING_CLIENT_PLAYER = AlertRenderer.shouldDrawThisUuid(clientEntity.m_20148_());
        if (!IS_TARGETING_CLIENT_PLAYER) {
            return false;
        }
        boolean bl5 = PLAYER_HAS_STATUS_BLINDNESS_OR_DARKNESS = player.m_21023_(MobEffects.f_19610_) || player.m_21023_(MobEffects.f_216964_);
        return !PLAYER_HAS_STATUS_BLINDNESS_OR_DARKNESS;
    }
}

