/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopeslab;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.client.model.slopeslab.FramedSlopeSlabModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedFlatSlopeSlabCornerModel
extends FramedBlockModel {
    private final Direction facing;
    private final boolean top;
    private final boolean topHalf;
    private final boolean ySlope;

    public FramedFlatSlopeSlabCornerModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        this.topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF);
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        boolean offset;
        Direction face = quad.m_111306_();
        boolean bl = offset = this.top != this.topHalf;
        if (!(this.ySlope || face != this.facing.m_122424_() && face != this.facing.m_122427_())) {
            boolean right = face == this.facing.m_122427_();
            float lenTop = this.top ? 1.0f : 0.0f;
            float lenBot = this.top ? 0.0f : 1.0f;
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(right, lenTop, lenBot)).apply(Modifiers.makeVerticalSlope(!this.top, FramedSlopeSlabModel.SLOPE_ANGLE)).applyIf(Modifiers.offset(this.top ? Direction.DOWN : Direction.UP, 0.5f), offset).export(quadMap.get(null));
        } else if (this.ySlope && (!this.top && face == Direction.UP || this.top && face == Direction.DOWN)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122427_(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(this.facing.m_122424_(), FramedSlopeSlabModel.SLOPE_ANGLE_VERT)).applyIf(Modifiers.offset(this.top ? Direction.UP : Direction.DOWN, 0.5f), !offset).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(this.facing.m_122427_(), FramedSlopeSlabModel.SLOPE_ANGLE_VERT)).applyIf(Modifiers.offset(this.top ? Direction.UP : Direction.DOWN, 0.5f), !offset).export(quadMap.get(null));
        } else if (face == this.facing || face == this.facing.m_122428_()) {
            float right;
            boolean rightFace;
            boolean bl2 = rightFace = face == this.facing;
            float f = rightFace ? (offset ? 0.5f : 0.0f) : (right = offset ? 1.0f : 0.5f);
            float left = rightFace ? (offset ? 1.0f : 0.5f) : (offset ? 0.5f : 0.0f);
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(this.top, right, left)).applyIf(Modifiers.cutSideUpDown(!this.top, 0.5f), offset).export(quadMap.get(face));
        } else if (this.top && !this.topHalf && face == Direction.UP || !this.top && this.topHalf && face == Direction.DOWN) {
            QuadModifier.geometry(quad).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemDisplayContext ctx) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_FLAT_SLOPE_SLAB_CORNER.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

