/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanel;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelModel;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedCompoundSlopePanelModel
extends FramedBlockModel {
    private final Direction dir;
    private final HorizontalRotation rot;
    private final Direction orientation;
    private final Direction.Axis triangleAxis;
    private final boolean ySlope;

    public FramedCompoundSlopePanelModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        this.orientation = this.rot.withFacing(this.dir);
        this.triangleAxis = this.rot.rotate(Rotation.CLOCKWISE_90).withFacing(this.dir).m_122434_();
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (quadDir == this.orientation) {
            if (Utils.isY(quadDir)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), 0.5f)).export(quadMap.get(quadDir));
            }
        } else if (quadDir == this.orientation.m_122424_()) {
            if (Utils.isY(quadDir)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).export(quadMap.get(quadDir));
            }
        } else if (quadDir == this.dir) {
            if (!Utils.isY(this.orientation)) {
                QuadModifier.geometry(quad).apply(Modifiers.makeHorizontalSlope(this.rot == HorizontalRotation.LEFT, FramedSlopePanelModel.SLOPE_ANGLE)).export(quadMap.get(null));
            } else if (!this.ySlope) {
                QuadModifier.geometry(quad).apply(Modifiers.makeVerticalSlope(this.rot == HorizontalRotation.DOWN, FramedSlopePanelModel.SLOPE_ANGLE)).export(quadMap.get(null));
            }
        } else if (quadDir == this.dir.m_122424_()) {
            if (!Utils.isY(this.orientation)) {
                QuadModifier.geometry(quad).apply(Modifiers.makeHorizontalSlope(this.rot == HorizontalRotation.LEFT, FramedSlopePanelModel.SLOPE_ANGLE)).export(quadMap.get(null));
            } else if (!this.ySlope) {
                QuadModifier.geometry(quad).apply(Modifiers.makeVerticalSlope(this.rot == HorizontalRotation.UP, FramedSlopePanelModel.SLOPE_ANGLE)).export(quadMap.get(null));
            }
        } else if (this.triangleAxis == Direction.Axis.Y && Utils.isY(quadDir)) {
            boolean right = this.rot == HorizontalRotation.RIGHT;
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, right ? 1.0f : 0.5f, right ? 0.5f : 1.0f)).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), right ? 1.0f : 0.5f, right ? 0.5f : 1.0f)).export(quadMap.get(quadDir));
        } else if (this.triangleAxis != Direction.Axis.Y && quadDir.m_122434_() == this.triangleAxis) {
            boolean up = this.rot == HorizontalRotation.UP;
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir, up ? 1.0f : 0.5f, up ? 0.5f : 1.0f)).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).export(quadMap.get(quadDir));
        }
    }
}

