/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.data.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;

public final class PyramidOutlineRenderer
implements OutlineRenderer {
    private static final Quaternionf[] XN_DIR = PyramidOutlineRenderer.makeQuaternionArray();
    private final float height;

    public PyramidOutlineRenderer(boolean slab) {
        this.height = slab ? 0.5f : 1.0f;
    }

    @Override
    public void draw(BlockState state, PoseStack pstack, VertexConsumer builder) {
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRenderer.drawLine(builder, pstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 0.0, 0.5, this.height, 0.5);
        OutlineRenderer.drawLine(builder, pstack, 1.0, 0.0, 0.0, 0.5, this.height, 0.5);
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 1.0, 0.5, this.height, 0.5);
        OutlineRenderer.drawLine(builder, pstack, 1.0, 0.0, 1.0, 0.5, this.height, 0.5);
    }

    @Override
    public void rotateMatrix(PoseStack poseStack, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        if (dir == Direction.DOWN) {
            poseStack.m_252781_(Quaternions.ZP_180);
        } else if (dir != Direction.UP) {
            poseStack.m_252781_(Quaternions.ZP_90);
            poseStack.m_252781_(XN_DIR[dir.m_122416_()]);
        }
    }

    private static Quaternionf[] makeQuaternionArray() {
        Quaternionf[] array = new Quaternionf[4];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.m_122416_()] = Axis.f_252495_.m_252977_(dir.m_122435_() - 90.0f);
        }
        return array;
    }
}

