/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity.ai.goal;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FirePanicGoal
extends Goal {
    private static final int HORIZONTAL_SEARCH_RANGE = 5;
    private static final int VERTICAL_SEARCH_RANGE = 2;
    private final AbstractGoblinEntity goblin;
    private final double speedModifier;
    private double randPosX;
    private double randPosY;
    private double randPosZ;

    public FirePanicGoal(AbstractGoblinEntity goblin, double speedModifier) {
        this.goblin = goblin;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.goblin.m_6060_() || this.goblin.isStunned()) {
            return false;
        }
        BlockPos blockpos = this.findClosestWaterPos();
        if (blockpos == null) {
            return this.findRandomPosition();
        }
        this.randPosX = blockpos.m_123341_();
        this.randPosY = blockpos.m_123342_();
        this.randPosZ = blockpos.m_123343_();
        return true;
    }

    public void m_8056_() {
        this.goblin.m_21573_().m_26519_(this.randPosX, this.randPosY, this.randPosZ, this.speedModifier);
    }

    public boolean m_8045_() {
        return !this.goblin.m_21573_().m_26571_();
    }

    private boolean findRandomPosition() {
        Vec3 randomPos = DefaultRandomPos.m_148403_((PathfinderMob)this.goblin, (int)5, (int)4);
        if (randomPos == null) {
            return false;
        }
        this.randPosX = randomPos.f_82479_;
        this.randPosY = randomPos.f_82480_;
        this.randPosZ = randomPos.f_82481_;
        return true;
    }

    @Nullable
    private BlockPos findClosestWaterPos() {
        Level level = this.goblin.m_9236_();
        BlockPos entityPos = this.goblin.m_20183_();
        return BlockPos.m_121930_((BlockPos)entityPos, (int)5, (int)2, pos -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_)).orElse(null);
    }
}

