/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.common;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.init.SFSoundEvents;
import com.bonker.stardewfishing.common.networking.S2CStartMinigamePacket;
import com.bonker.stardewfishing.common.networking.SFNetworking;
import com.bonker.stardewfishing.proxy.ItemUtils;
import com.bonker.stardewfishing.proxy.QualityFoodProxy;
import com.bonker.stardewfishing.server.AttributeCache;
import com.bonker.stardewfishing.server.LockableList;
import com.bonker.stardewfishing.server.data.FishBehaviorReloadListener;
import com.bonker.stardewfishing.server.data.MinigameModifiersReloadListener;
import com.bonker.stardewfishing.server.event.StardewMinigameEndedEvent;
import com.bonker.stardewfishing.server.event.StardewMinigameModifyRewardsEvent;
import com.bonker.stardewfishing.server.event.StardewMinigameStartedEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishingHookLogic {
    public final LockableList<ItemStack> rewards = new LockableList();
    private boolean treasureChest = false;
    private boolean goldenChest = false;
    public StardewMinigameStartedEvent event = null;

    public static void attachCap(AttachCapabilitiesEvent<Entity> event) {
        if (!((Entity)event.getObject()).getCapability(CapProvider.CAP).isPresent()) {
            event.addCapability(CapProvider.NAME, (ICapabilityProvider)new CapProvider());
        }
    }

    public static Optional<ArrayList<ItemStack>> getStoredRewards(FishingHook entity) {
        return entity.getCapability(CapProvider.CAP).map(cap -> cap.rewards);
    }

    public static boolean startStardewMinigame(ServerPlayer player) {
        if (player.f_36083_ == null || player instanceof FakePlayer) {
            return false;
        }
        return player.f_36083_.getCapability(CapProvider.CAP).resolve().map(cap -> {
            if (cap.event != null) {
                StardewFishing.LOGGER.warn("{} tried to start a minigame while playing one", (Object)player.m_6302_());
                return true;
            }
            cap.rewards.lock();
            ItemStack fish = cap.rewards.stream().filter(stack -> stack.m_204117_(StardewFishing.STARTS_MINIGAME)).findFirst().orElseThrow();
            InteractionHand rodHand = FishingHookLogic.getRodHand((Player)player);
            if (rodHand == null) {
                StardewFishing.LOGGER.warn("{} tried to start a minigame without a fishing rod", (Object)player.m_6302_());
                return false;
            }
            BlockPos pos = BlockPos.m_274446_((Position)player.f_36083_.m_20182_());
            FluidState fluid = player.m_9236_().m_8055_(pos).m_60819_();
            if (fluid.m_76178_()) {
                fluid = player.m_9236_().m_8055_(pos.m_7495_()).m_60819_();
            }
            AttributeCache.add((Player)player);
            ItemStack fishingRod = player.m_21120_(rodHand);
            StardewMinigameStartedEvent startEvent = new StardewMinigameStartedEvent(player, player.f_36083_, fishingRod, fish, FishBehaviorReloadListener.getBehavior(fish), fluid.m_205070_(FluidTags.f_13132_));
            ItemUtils.getAllModifierItems(fishingRod).forEach(stack -> MinigameModifiersReloadListener.getModifiers(stack).ifPresent(modifiers -> modifiers.apply(startEvent)));
            MinecraftForge.EVENT_BUS.post((Event)startEvent);
            cap.event = startEvent;
            double chestChance = SFConfig.getTreasureChestChance() + startEvent.getTreasureChanceBonus();
            if (startEvent.isForcedTreasureChest() || (double)player.m_217043_().m_188501_() < chestChance) {
                cap.treasureChest = true;
                if (startEvent.isForcedGoldenChest() || (double)player.m_217043_().m_188501_() < SFConfig.getGoldenChestChance()) {
                    cap.goldenChest = true;
                }
            }
            SFNetworking.sendToPlayer(player, new S2CStartMinigamePacket(startEvent, cap.treasureChest, cap.goldenChest));
            return true;
        }).orElse(false);
    }

    public static void endMinigame(ServerPlayer player, boolean success, double accuracy, boolean gotChest, int qualityBoost, @Nullable ItemStack fishingRod) {
        if (player.f_36083_ == null) {
            return;
        }
        StardewMinigameEndedEvent endEvent = new StardewMinigameEndedEvent(player, player.f_36083_, fishingRod, success, accuracy, gotChest);
        if (fishingRod != null) {
            MinecraftForge.EVENT_BUS.post((Event)endEvent);
        }
        if (endEvent.wasSuccessful() && !player.m_9236_().f_46443_) {
            FishingHookLogic.modifyRewards(player, endEvent.getAccuracy(), qualityBoost);
            FishingHookLogic.giveRewards(player, endEvent.getAccuracy(), endEvent.gotChest(), fishingRod);
        }
        if (player.f_36083_ != null) {
            player.f_36083_.m_146870_();
        }
        AttributeCache.remove((Player)player);
    }

    @Deprecated(forRemoval=true, since="3.0")
    public static void modifyRewards(ServerPlayer player, double accuracy, @Nullable ItemStack fishingRod) {
        FishingHookLogic.modifyRewards(player, accuracy, 0);
    }

    @Deprecated(forRemoval=true, since="3.0")
    public static void modifyRewards(List<ItemStack> rewards, double accuracy, @Nullable ItemStack fishingRod) {
        FishingHookLogic.modifyRewards(rewards, accuracy, 0);
    }

    public static void modifyRewards(ServerPlayer player, double accuracy, int qualityBoost) {
        if (player.f_36083_ == null) {
            return;
        }
        FishingHookLogic.getStoredRewards(player.f_36083_).ifPresent(rewards -> FishingHookLogic.modifyRewards((List<ItemStack>)rewards, accuracy, qualityBoost));
    }

    public static void modifyRewards(List<ItemStack> rewards, double accuracy, int qualityBoost) {
        if (StardewFishing.QUALITY_FOOD_INSTALLED) {
            int quality = Mth.m_14045_((int)(SFConfig.getQuality(accuracy) + qualityBoost), (int)0, (int)3);
            for (ItemStack reward : rewards) {
                if (!reward.m_204117_(StardewFishing.STARTS_MINIGAME)) continue;
                if (quality == 0 && reward.m_41782_() && reward.m_41784_().m_128441_("quality_food")) {
                    if (reward.m_41784_().m_128440_() > 1) {
                        reward.m_41784_().m_128473_("quality_food");
                        continue;
                    }
                    reward.m_41751_(null);
                    continue;
                }
                if (quality <= 0) continue;
                QualityFoodProxy.applyQuality(reward, quality);
            }
        }
    }

    public static void giveRewards(ServerPlayer player, double accuracy, boolean gotChest, ItemStack fishingRod) {
        if (player.f_36083_ == null) {
            return;
        }
        FishingHook hook = player.f_36083_;
        hook.getCapability(CapProvider.CAP).ifPresent(cap -> {
            cap.rewards.unlock();
            if (cap.treasureChest && gotChest) {
                cap.rewards.addAll((Collection<ItemStack>)FishingHookLogic.getTreasureChestLoot(player.m_284548_(), cap.goldenChest));
            }
            StardewMinigameModifyRewardsEvent modifyRewardsEvent = new StardewMinigameModifyRewardsEvent(player, hook, fishingRod, cap.rewards);
            MinecraftForge.EVENT_BUS.post((Event)modifyRewardsEvent);
            if (cap.rewards.isEmpty()) {
                hook.m_146870_();
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new ItemFishedEvent(cap.rewards, 1, hook))) {
                player.m_9236_().m_6269_(null, (Entity)player, (SoundEvent)SFSoundEvents.PULL_ITEM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                hook.m_146870_();
                return;
            }
            ServerLevel level = player.m_284548_();
            for (ItemStack reward : cap.rewards) {
                if (reward.m_204117_(ItemTags.f_13156_)) {
                    player.m_36220_(Stats.f_12939_);
                }
                ItemEntity itementity = cap.event.isLavaFishing() ? new ItemEntity((Level)level, hook.m_20185_(), hook.m_20186_(), hook.m_20189_(), reward){

                    public boolean m_6051_() {
                        return false;
                    }

                    public void m_20093_() {
                    }
                } : new ItemEntity((Level)level, hook.m_20185_(), hook.m_20186_(), hook.m_20189_(), reward);
                double scale = 0.1;
                double dx = player.m_20185_() - hook.m_20185_();
                double dy = player.m_20186_() - hook.m_20186_();
                double dz = player.m_20189_() - hook.m_20189_();
                itementity.m_20334_(dx * scale, dy * scale + Math.sqrt(Math.sqrt(dx * dx + dy * dy + dz * dz)) * 0.08, dz * scale);
                level.m_7967_((Entity)itementity);
                int exp = (int)((double)(player.m_217043_().m_188503_(6) + 1) * SFConfig.getMultiplier(accuracy, (Player)player, cap.event.getExpMultiplier()));
                level.m_7967_((Entity)new ExperienceOrb((Level)level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, exp));
                InteractionHand hand = FishingHookLogic.getRodHand((Player)player);
                ItemStack handItem = hand != null ? player.m_21120_(hand) : ItemStack.f_41583_;
                CriteriaTriggers.f_10553_.m_40416_(player, handItem, hook, cap.rewards);
            }
            player.m_9236_().m_6269_(null, (Entity)player, (SoundEvent)SFSoundEvents.PULL_ITEM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        });
    }

    private static List<ItemStack> getTreasureChestLoot(ServerLevel level, boolean isGolden) {
        int rolls;
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(level.m_46472_() == Level.f_46429_ ? StardewFishing.TREASURE_CHEST_NETHER_LOOT : StardewFishing.TREASURE_CHEST_LOOT);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (isGolden) {
            rolls = 2;
            if (level.f_46441_.m_188501_() < 0.25f) {
                ++rolls;
                if (level.f_46441_.m_188501_() < 0.5f) {
                    ++rolls;
                }
            }
        } else {
            rolls = 1;
        }
        for (int i = 0; i < rolls; ++i) {
            items.addAll((Collection<ItemStack>)lootTable.m_287195_(new LootParams.Builder(level).m_287235_(LootContextParamSets.f_81410_)));
        }
        return items;
    }

    public static InteractionHand getRodHand(Player player) {
        boolean mainHand = player.m_21120_(InteractionHand.MAIN_HAND).canPerformAction(ToolActions.FISHING_ROD_CAST);
        if (mainHand) {
            return InteractionHand.MAIN_HAND;
        }
        boolean offHand = player.m_21120_(InteractionHand.OFF_HAND).canPerformAction(ToolActions.FISHING_ROD_CAST);
        if (offHand) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    public static Optional<ItemStack> damageBobber(ItemStack bobber, ServerPlayer player) {
        if (!bobber.m_41763_()) {
            return Optional.empty();
        }
        bobber.m_41622_(1, (LivingEntity)player, p -> {
            player.m_284548_().m_247517_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS);
            Vec3 particlePos = player.m_146892_().m_82549_(player.m_20154_());
            player.m_284548_().m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, bobber), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 15, 0.1, 0.1, 0.1, 0.1);
            player.m_5661_((Component)Component.m_237110_((String)"stardew_fishing.bobber_broke", (Object[])new Object[]{bobber.m_41611_()}), true);
        });
        return Optional.of(bobber);
    }

    public static class CapProvider
    implements ICapabilityProvider {
        public static final Capability<FishingHookLogic> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<FishingHookLogic>(){});
        private static final ResourceLocation NAME = StardewFishing.resource("hook");
        private final LazyOptional<FishingHookLogic> optional = LazyOptional.of(FishingHookLogic::new);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return this.getCapability(cap);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
            return cap == CAP ? this.optional.cast() : LazyOptional.empty();
        }
    }
}

