/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.UnmodifiableIterator;
import cpw.mods.inventorysorter.Config;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.ItemStackHolder;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.Supplier;

public enum SortingHandler implements Consumer<ContainerContext>
{
    INSTANCE;

    private static final ResourceLocation DUMMY_PLAYER_CONTAINER;

    @Override
    public void accept(ContainerContext context) {
        if (context == null) {
            throw new NullPointerException("WHUT");
        }
        if (context.slotMapping == null) {
            return;
        }
        if (((Boolean)Config.ClientConfig.CONFIG.excludeHotbar.get()).booleanValue() && context.slotMapping.inv == ContainerContext.PLAYER_HOTBAR) {
            InventorySorter.INSTANCE.debugLog("Hotbar sorting skipped due to excludeHotbar config", () -> new String[0]);
            return;
        }
        if (Config.ClientConfig.CONFIG.sortOrder.get() == Config.ClientConfig.SortOrder.CREATIVE && !((CreativeModeTab)CreativeModeTabs.m_257388_().get(0)).m_257905_()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            CreativeModeTabs.m_269226_((FeatureFlagSet)player.f_108617_.m_247016_(), (boolean)true, (HolderLookup.Provider)player.f_108545_.m_9598_());
        }
        Multiset<ItemStackHolder> itemcounts = InventoryHandler.INSTANCE.getInventoryContent(context);
        if (!(context.slot.f_40218_ instanceof CraftingContainer) && !context.slotMapping.markAsHeterogeneous) {
            this.compactInventory(context, itemcounts);
        }
    }

    private void compactInventory(ContainerContext context, Multiset<ItemStackHolder> itemcounts) {
        Slot slot;
        int i;
        UnmodifiableIterator itemsIterator;
        ResourceLocation containerTypeName;
        InventorySorter.INSTANCE.lastContainerType = containerTypeName = this.lookupContainerTypeName(context.slotMapping.container);
        if (InventorySorter.INSTANCE.isContainerBlacklisted(containerTypeName)) {
            InventorySorter.INSTANCE.debugLog("Container {} blacklisted", () -> new String[]{containerTypeName.toString()});
            return;
        }
        InventorySorter.INSTANCE.debugLog("Container \"{}\" being sorted", () -> new String[]{containerTypeName.toString()});
        try {
            itemsIterator = ((Boolean)Config.ClientConfig.CONFIG.sortByCountFirst.get()).booleanValue() ? Multisets.copyHighestCountFirst(itemcounts).entrySet().iterator() : itemcounts.entrySet().iterator();
        }
        catch (Exception e) {
            InventorySorter.LOGGER.warn("Weird, the sorting didn't quite work!", (Throwable)e);
            return;
        }
        int slotLow = context.slotMapping.begin;
        int slotHigh = context.slotMapping.end + 1;
        Multiset.Entry stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
        int itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        ItemStack[] slotBuffer = new ItemStack[slotHigh];
        for (i = slotLow; i < slotHigh; ++i) {
            slotBuffer[i] = ItemStack.f_41583_;
            slot = context.player.f_36096_.m_38853_(i);
            if (!slot.m_8010_((Player)context.player) && slot.m_6657_()) {
                InventorySorter.LOGGER.log(Level.DEBUG, "Slot {} of container {} disallows canTakeStack", new Supplier[]{() -> slot.f_40219_, () -> containerTypeName});
                slotBuffer[i] = slot.m_7993_();
                continue;
            }
            ItemStack target = ItemStack.f_41583_;
            if (itemCount > 0 && stackHolder != null) {
                target = ((ItemStackHolder)stackHolder.getElement()).itemStack.m_41777_();
                target.m_41764_(Math.min(itemCount, slot.m_5866_(target)));
            }
            if (target.m_41619_()) continue;
            if (!slot.m_5857_(target)) {
                ItemStack trg = target;
                InventorySorter.LOGGER.log(Level.DEBUG, "Item {} is not valid in slot {} of container {}", new Supplier[]{() -> trg, () -> slot.f_40219_, () -> containerTypeName});
                continue;
            }
            slotBuffer[i] = target;
            if ((itemCount -= target.m_41613_()) != 0) continue;
            stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
            itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        }
        if (stackHolder != null) {
            InventorySorter.LOGGER.log(Level.INFO, "Some items were about to be deleted, sorting canceled");
            return;
        }
        for (i = slotLow; i < slotHigh; ++i) {
            slot = context.player.f_36096_.m_38853_(i);
            slot.m_5852_(slotBuffer[i]);
        }
    }

    private ResourceLocation lookupContainerTypeName(AbstractContainerMenu container) {
        return container instanceof InventoryMenu ? DUMMY_PLAYER_CONTAINER : ForgeRegistries.MENU_TYPES.getKey((Object)container.m_6772_());
    }

    static {
        DUMMY_PLAYER_CONTAINER = new ResourceLocation("inventorysorter:dummyplayercontainer");
    }
}

