/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class QuarkSortingHandler {
    public static final Comparator<ItemStack> FALLBACK_COMPARATOR = QuarkSortingHandler.jointComparator(Arrays.asList(Comparator.comparingInt(s -> Item.m_41393_((Item)s.m_41720_())), QuarkSortingHandler::damageCompare, (s1, s2) -> s2.m_41613_() - s1.m_41613_(), QuarkSortingHandler::nameCompare, QuarkSortingHandler::fallbackNBTCompare, (s1, s2) -> s2.hashCode() - s1.hashCode()));
    private static final Comparator<ItemStack> FOOD_COMPARATOR = QuarkSortingHandler.jointComparator(Arrays.asList(QuarkSortingHandler::foodHealCompare, QuarkSortingHandler::foodSaturationCompare));
    private static final Comparator<ItemStack> TOOL_COMPARATOR = QuarkSortingHandler.jointComparator(Arrays.asList(QuarkSortingHandler::toolPowerCompare, QuarkSortingHandler::enchantmentCompare, QuarkSortingHandler::damageCompare));
    private static final Comparator<ItemStack> SWORD_COMPARATOR = QuarkSortingHandler.jointComparator(Arrays.asList(QuarkSortingHandler::swordPowerCompare, QuarkSortingHandler::enchantmentCompare, QuarkSortingHandler::damageCompare));
    private static final Comparator<ItemStack> ARMOR_COMPARATOR = QuarkSortingHandler.jointComparator(Arrays.asList(QuarkSortingHandler::armorSlotAndToughnessCompare, QuarkSortingHandler::enchantmentCompare, QuarkSortingHandler::damageCompare));
    private static final Comparator<ItemStack> BOW_COMPARATOR = QuarkSortingHandler.jointComparator(Arrays.asList(QuarkSortingHandler::enchantmentCompare, QuarkSortingHandler::damageCompare));
    private static final Comparator<ItemStack> POTION_COMPARATOR = QuarkSortingHandler.jointComparator(Arrays.asList(QuarkSortingHandler::potionComplexityCompare, QuarkSortingHandler::potionTypeCompare));
    private static final Comparator<ItemStack> ENCHANTED_BOOK_COMPARATOR = QuarkSortingHandler::enchantmentCompare;

    public static int stackCompare(ItemStack stack1, ItemStack stack2) {
        ItemType type2;
        ItemType type1 = QuarkSortingHandler.getType(stack1);
        if (type1 == (type2 = QuarkSortingHandler.getType(stack2))) {
            return type1.comparator.compare(stack1, stack2);
        }
        return type1.ordinal() - type2.ordinal();
    }

    private static ItemType getType(ItemStack stack) {
        for (ItemType type : ItemType.values()) {
            if (!type.fitsInType(stack)) continue;
            return type;
        }
        throw new RuntimeException("Having an ItemStack that doesn't fit in any type is impossible.");
    }

    private static Predicate<ItemStack> classPredicate(Class<? extends Item> clazz) {
        return s -> !s.m_41619_() && clazz.isInstance(s.m_41720_());
    }

    private static Predicate<ItemStack> inverseClassPredicate(Class<? extends Item> clazz) {
        return QuarkSortingHandler.classPredicate(clazz).negate();
    }

    private static Predicate<ItemStack> itemPredicate(List<Item> list) {
        return s -> !s.m_41619_() && list.contains(s.m_41720_());
    }

    public static Comparator<ItemStack> jointComparator(Comparator<ItemStack> finalComparator, List<Comparator<ItemStack>> otherComparators) {
        if (otherComparators == null) {
            return QuarkSortingHandler.jointComparator(List.of(finalComparator));
        }
        ArrayList<Comparator<ItemStack>> newList = new ArrayList<Comparator<ItemStack>>(otherComparators);
        newList.add(finalComparator);
        return QuarkSortingHandler.jointComparator(newList);
    }

    public static Comparator<ItemStack> jointComparator(List<Comparator<ItemStack>> comparators) {
        return QuarkSortingHandler.jointComparatorFallback((s1, s2) -> {
            for (Comparator comparator : comparators) {
                int compare;
                if (comparator == null || (compare = comparator.compare(s1, s2)) == 0) continue;
                return compare;
            }
            return 0;
        }, FALLBACK_COMPARATOR);
    }

    private static Comparator<ItemStack> jointComparatorFallback(Comparator<ItemStack> comparator, Comparator<ItemStack> fallback) {
        return (s1, s2) -> {
            int compare = comparator.compare((ItemStack)s1, (ItemStack)s2);
            if (compare == 0) {
                return fallback == null ? 0 : fallback.compare((ItemStack)s1, (ItemStack)s2);
            }
            return compare;
        };
    }

    private static Comparator<ItemStack> listOrderComparator(List<Item> list) {
        return (stack1, stack2) -> {
            Item i1 = stack1.m_41720_();
            Item i2 = stack2.m_41720_();
            if (list.contains(i1)) {
                if (list.contains(i2)) {
                    return list.indexOf(i1) - list.indexOf(i2);
                }
                return 1;
            }
            if (list.contains(i2)) {
                return -1;
            }
            return 0;
        };
    }

    private static List<Item> list(Object ... items) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (Object o : items) {
            String s;
            Item item;
            if (o == null) continue;
            if (o instanceof Item) {
                Item item2 = (Item)o;
                itemList.add(item2);
                continue;
            }
            if (o instanceof Block) {
                Block block = (Block)o;
                itemList.add(block.m_5456_());
                continue;
            }
            if (o instanceof ItemStack) {
                ItemStack stack = (ItemStack)o;
                itemList.add(stack.m_41720_());
                continue;
            }
            if (!(o instanceof String) || (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s = (String)o))) == null) continue;
            itemList.add(item);
        }
        return itemList;
    }

    private static int nutrition(FoodProperties properties) {
        if (properties == null) {
            return 0;
        }
        return properties.m_38744_();
    }

    private static int foodHealCompare(ItemStack stack1, ItemStack stack2) {
        return QuarkSortingHandler.nutrition(stack2.m_41720_().m_41473_()) - QuarkSortingHandler.nutrition(stack1.m_41720_().m_41473_());
    }

    private static float saturation(FoodProperties properties) {
        if (properties == null) {
            return 0.0f;
        }
        return Math.min(20.0f, (float)properties.m_38744_() * properties.m_38745_() * 2.0f);
    }

    private static int foodSaturationCompare(ItemStack stack1, ItemStack stack2) {
        return (int)(QuarkSortingHandler.saturation(stack2.m_41720_().m_41473_()) - QuarkSortingHandler.saturation(stack1.m_41720_().m_41473_()));
    }

    private static int enchantmentCompare(ItemStack stack1, ItemStack stack2) {
        return QuarkSortingHandler.enchantmentPower(stack2) - QuarkSortingHandler.enchantmentPower(stack1);
    }

    private static int enchantmentPower(ItemStack stack) {
        if (!stack.m_41793_()) {
            return 0;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        int total = 0;
        for (Integer i : enchantments.values()) {
            total += i.intValue();
        }
        return total;
    }

    private static int toolPowerCompare(ItemStack stack1, ItemStack stack2) {
        Tier mat1 = ((DiggerItem)stack1.m_41720_()).m_43314_();
        Tier mat2 = ((DiggerItem)stack2.m_41720_()).m_43314_();
        return (int)(mat2.m_6624_() * 100.0f - mat1.m_6624_() * 100.0f);
    }

    private static int swordPowerCompare(ItemStack stack1, ItemStack stack2) {
        Tier mat1 = ((SwordItem)stack1.m_41720_()).m_43314_();
        Tier mat2 = ((SwordItem)stack2.m_41720_()).m_43314_();
        return (int)(mat2.m_6631_() * 100.0f - mat1.m_6631_() * 100.0f);
    }

    private static int armorSlotAndToughnessCompare(ItemStack stack1, ItemStack stack2) {
        EquipmentSlot slot2;
        ArmorItem armor1 = (ArmorItem)stack1.m_41720_();
        ArmorItem armor2 = (ArmorItem)stack2.m_41720_();
        EquipmentSlot slot1 = armor1.m_40402_();
        if (slot1 == (slot2 = armor2.m_40402_())) {
            return armor2.m_40401_().m_7366_(armor2.m_266204_()) - armor2.m_40401_().m_7366_(armor1.m_266204_());
        }
        return slot2.m_20749_() - slot1.m_20749_();
    }

    public static int damageCompare(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41773_() - stack2.m_41773_();
    }

    public static int fallbackNBTCompare(ItemStack stack1, ItemStack stack2) {
        boolean hasTag1 = stack1.m_41782_();
        boolean hasTag2 = stack2.m_41782_();
        if (hasTag2 && !hasTag1) {
            return -1;
        }
        if (hasTag1 && !hasTag2) {
            return 1;
        }
        if (!hasTag1) {
            return 0;
        }
        return stack2.m_41783_().toString().hashCode() - stack1.m_41783_().toString().hashCode();
    }

    public static int potionComplexityCompare(ItemStack stack1, ItemStack stack2) {
        List effects1 = PotionUtils.m_43571_((ItemStack)stack1);
        List effects2 = PotionUtils.m_43571_((ItemStack)stack2);
        int totalPower1 = 0;
        int totalPower2 = 0;
        for (MobEffectInstance inst : effects1) {
            totalPower1 += inst.m_19564_() * inst.m_19557_();
        }
        for (MobEffectInstance inst : effects2) {
            totalPower2 += inst.m_19564_() * inst.m_19557_();
        }
        return totalPower2 - totalPower1;
    }

    public static int potionTypeCompare(ItemStack stack1, ItemStack stack2) {
        Potion potion1 = PotionUtils.m_43579_((ItemStack)stack1);
        Potion potion2 = PotionUtils.m_43579_((ItemStack)stack2);
        return BuiltInRegistries.f_256980_.m_7447_((Object)potion2) - BuiltInRegistries.f_256980_.m_7447_((Object)potion1);
    }

    public static int nameCompare(ItemStack stack1, ItemStack stack2) {
        boolean hasCustomHoverName1 = stack1.m_41788_();
        boolean hasCustomHoverName2 = stack2.m_41788_();
        if (hasCustomHoverName2 && !hasCustomHoverName1) {
            return 1;
        }
        if (hasCustomHoverName1 && !hasCustomHoverName2) {
            return -1;
        }
        String name1 = stack1.m_41786_().getString();
        String name2 = stack1.m_41786_().getString();
        return name1.compareTo(name2);
    }

    private static enum ItemType {
        TORCH(QuarkSortingHandler.list(Blocks.f_50081_)),
        FOOD(ItemStack::m_41614_, FOOD_COMPARATOR),
        TOOL_PICKAXE(QuarkSortingHandler.classPredicate(PickaxeItem.class), TOOL_COMPARATOR),
        TOOL_SHOVEL(QuarkSortingHandler.classPredicate(ShovelItem.class), TOOL_COMPARATOR),
        TOOL_AXE(QuarkSortingHandler.classPredicate(AxeItem.class), TOOL_COMPARATOR),
        TOOL_SWORD(QuarkSortingHandler.classPredicate(SwordItem.class), SWORD_COMPARATOR),
        TOOL_GENERIC(QuarkSortingHandler.classPredicate(DiggerItem.class), TOOL_COMPARATOR),
        ARMOR(QuarkSortingHandler.classPredicate(ArmorItem.class), ARMOR_COMPARATOR),
        BOW(QuarkSortingHandler.classPredicate(BowItem.class), BOW_COMPARATOR),
        CROSSBOW(QuarkSortingHandler.classPredicate(CrossbowItem.class), BOW_COMPARATOR),
        TRIDENT(QuarkSortingHandler.classPredicate(TridentItem.class), BOW_COMPARATOR),
        ARROWS(QuarkSortingHandler.classPredicate(ArrowItem.class)),
        TIPPED_ARROW(QuarkSortingHandler.classPredicate(TippedArrowItem.class), POTION_COMPARATOR),
        POTION(QuarkSortingHandler.classPredicate(PotionItem.class), POTION_COMPARATOR),
        ENCHANTED_BOOK(QuarkSortingHandler.classPredicate(EnchantedBookItem.class), ENCHANTED_BOOK_COMPARATOR),
        MINECART(QuarkSortingHandler.classPredicate(MinecartItem.class)),
        RAIL(QuarkSortingHandler.list(Blocks.f_50156_, Blocks.f_50030_, Blocks.f_50031_, Blocks.f_50285_)),
        DYE(QuarkSortingHandler.classPredicate(DyeItem.class)),
        ANY(QuarkSortingHandler.inverseClassPredicate(BlockItem.class)),
        BLOCK(QuarkSortingHandler.classPredicate(BlockItem.class));

        private final Predicate<ItemStack> predicate;
        private final Comparator<ItemStack> comparator;

        private ItemType(List<Item> list) {
            this(QuarkSortingHandler.itemPredicate(list), QuarkSortingHandler.jointComparator(QuarkSortingHandler.listOrderComparator(list), new ArrayList<Comparator<ItemStack>>()));
        }

        private ItemType(Predicate<ItemStack> predicate) {
            this(predicate, FALLBACK_COMPARATOR);
        }

        private ItemType(Predicate<ItemStack> predicate, Comparator<ItemStack> comparator) {
            this.predicate = predicate;
            this.comparator = comparator;
        }

        public boolean fitsInType(ItemStack stack) {
            return this.predicate.test(stack);
        }
    }
}

