/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {

    public static class ClientConfig {
        static final ClientConfig CONFIG;
        static final ForgeConfigSpec SPEC;
        final ForgeConfigSpec.EnumValue<SortOrder> sortOrder;
        final ForgeConfigSpec.BooleanValue sortByCountFirst;
        final ForgeConfigSpec.BooleanValue excludeHotbar;

        private ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Inventory sorter");
            builder.push("sortingRules");
            this.sortOrder = builder.comment("Sort order").translation("inventorysorter.config.sortorder").defineEnum("sortOrder", (Enum)SortOrder.QUARK);
            this.sortByCountFirst = builder.comment("Sort by count first").translation("inventorysorter.config.sortbycountfirst").define("sortByCountFirst", false);
            this.excludeHotbar = builder.comment("Exclude hotbar from sorting").translation("inventorysorter.config.excludehotbar").define("excludeHotbar", true);
            builder.pop();
        }

        static {
            Pair conf = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
            CONFIG = (ClientConfig)conf.getLeft();
            SPEC = (ForgeConfigSpec)conf.getRight();
        }

        public static enum SortOrder {
            QUARK,
            CREATIVE,
            ITEM_ID,
            ITEM_NAME,
            DISPLAY_NAME;

        }
    }

    public static class ServerConfig {
        static final ServerConfig CONFIG;
        static final ForgeConfigSpec SPEC;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> containerBlacklist;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> slotBlacklist;
        final ForgeConfigSpec.ConfigValue<List<? extends String>> abortOnFirstSlotTypes;

        private ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Inventory sorter blacklists");
            builder.push("blacklists");
            this.containerBlacklist = builder.comment("Container blacklist").translation("inventorysorter.config.containerblacklist").defineList("containerBlacklist", ArrayList::new, t -> true);
            this.slotBlacklist = builder.comment("Slot type blacklist").translation("inventorysorter.config.slotblacklist").defineList("slotBlacklist", ArrayList::new, t -> true);
            this.abortOnFirstSlotTypes = builder.comment("Abort sorting if first slot is one of these types").translation("inventorysorter.config.abortonfirstslottypes").defineList("abortOnFirstSlotTypes", () -> {
                ArrayList<String> defaults = new ArrayList<String>();
                defaults.add("SlotIronFurnaceInput");
                return defaults;
            }, t -> true);
            builder.pop();
        }

        static {
            Pair conf = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
            CONFIG = (ServerConfig)conf.getLeft();
            SPEC = (ForgeConfigSpec)conf.getRight();
        }
    }
}

