/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.util.json;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import insane96mcp.insanelib.util.json.validator.Validator;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;

public class ILGsonHelper {
    @Nullable
    public static Integer getAsNullableInt(JsonObject jObject, String memberName, @Nullable Validator<Integer> validator) {
        if (!jObject.has(memberName)) {
            return null;
        }
        int i = GsonHelper.m_13927_((JsonObject)jObject, (String)memberName);
        if (validator != null && !validator.test(i)) {
            throw new JsonParseException(validator.getErrorMessage(i));
        }
        return i;
    }

    @Nullable
    public static Double getAsNullableDouble(JsonObject jObject, String memberName, @Nullable Validator<Double> validator) {
        if (!jObject.has(memberName)) {
            return null;
        }
        double d = GsonHelper.m_144784_((JsonObject)jObject, (String)memberName);
        if (validator != null && !validator.test(d)) {
            throw new JsonParseException(validator.getErrorMessage(d));
        }
        return d;
    }

    @Nullable
    public static Float getAsNullableFloat(JsonObject jObject, String memberName, @Nullable Validator<Float> validator) {
        if (!jObject.has(memberName)) {
            return null;
        }
        float f = GsonHelper.m_13915_((JsonObject)jObject, (String)memberName);
        if (validator != null && !validator.test(Float.valueOf(f))) {
            throw new JsonParseException(validator.getErrorMessage(Float.valueOf(f)));
        }
        return Float.valueOf(f);
    }

    @Nullable
    public static Integer getAsNullableInt(JsonObject jObject, String memberName) {
        return ILGsonHelper.getAsNullableInt(jObject, memberName, null);
    }

    @Nullable
    public static Double getAsNullableDouble(JsonObject jObject, String memberName) {
        return ILGsonHelper.getAsNullableDouble(jObject, memberName, null);
    }

    @Nullable
    public static Float getAsNullableFloat(JsonObject jObject, String memberName) {
        return ILGsonHelper.getAsNullableFloat(jObject, memberName, null);
    }

    @Nullable
    public static Boolean getAsNullableBoolean(JsonObject jObject, String memberName) {
        if (!jObject.has(memberName)) {
            return null;
        }
        return GsonHelper.m_13912_((JsonObject)jObject, (String)memberName);
    }

    public static void addProperty(JsonObject jObject, String memberName, @Nullable Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            jObject.addProperty(memberName, number);
        } else if (value instanceof Character) {
            Character character = (Character)value;
            jObject.addProperty(memberName, character);
        } else if (value instanceof String) {
            String string = (String)value;
            jObject.addProperty(memberName, string);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            jObject.addProperty(memberName, bool);
        } else {
            throw new ClassCastException("Cannot add value of type %s to %s".formatted(value.getClass(), jObject));
        }
    }

    public static void add(JsonObject jObject, JsonSerializationContext context, String memberName, @Nullable Object value) {
        if (value == null) {
            return;
        }
        jObject.add(memberName, context.serialize(value));
    }

    public static void add(JsonObject jObject, JsonSerializationContext context, String memberName, @Nullable Object value, Type type) {
        if (value == null) {
            return;
        }
        jObject.add(memberName, context.serialize(value));
    }
}

