/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base.config;

import insane96mcp.insanelib.base.ConfigOption;
import insane96mcp.insanelib.util.ConfigUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;

public class Difficulty {
    public double easy;
    public double normal;
    public double hard;

    public Difficulty(double easy, double normal, double hard) {
        this.easy = easy;
        this.normal = normal;
        this.hard = hard;
    }

    public double getByDifficulty(Level level) {
        return switch (level.m_46791_()) {
            default -> throw new IncompatibleClassChangeError();
            case net.minecraft.world.Difficulty.PEACEFUL, net.minecraft.world.Difficulty.EASY -> this.easy;
            case net.minecraft.world.Difficulty.NORMAL -> this.normal;
            case net.minecraft.world.Difficulty.HARD -> this.hard;
        };
    }

    public static class Config
    extends ConfigOption<Difficulty> {
        private final ForgeConfigSpec.DoubleValue easyConfig;
        private final ForgeConfigSpec.DoubleValue normalConfig;
        private final ForgeConfigSpec.DoubleValue hardConfig;

        public Config(ForgeConfigSpec.Builder builder, String name, String description, Difficulty defaultValue, double rangeMin, double rangeMax) {
            super(builder, name, description);
            List<String> split = ConfigUtils.split(name);
            builder.push(split);
            this.easyConfig = builder.defineInRange("Easy/Peaceful", defaultValue.easy, rangeMin, rangeMax);
            this.normalConfig = builder.defineInRange("Normal", defaultValue.normal, rangeMin, rangeMax);
            this.hardConfig = builder.defineInRange("Hard", defaultValue.hard, rangeMin, rangeMax);
            builder.pop(split.size());
        }

        @Override
        public Difficulty get() {
            return new Difficulty((Double)this.easyConfig.get(), (Double)this.normalConfig.get(), (Double)this.hardConfig.get());
        }

        @Override
        public void set(Object value) {
            Difficulty difficulty = (Difficulty)value;
            this.easyConfig.set((Object)difficulty.easy);
            this.normalConfig.set((Object)difficulty.normal);
            this.hardConfig.set((Object)difficulty.hard);
        }

        @Override
        @Nullable
        public List<String> getConfigPath() {
            return null;
        }
    }
}

