/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock;

import bl4ckscor3.mod.globalxp.Configuration;
import bl4ckscor3.mod.globalxp.GlobalXP;
import bl4ckscor3.mod.globalxp.openmods.utils.EnchantmentUtils;
import bl4ckscor3.mod.globalxp.xpblock.XPBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;

public class XPBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0E-4, (double)1.0E-4, (double)1.0E-4, (double)15.999, (double)15.999, (double)15.999);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public XPBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof XPBlockEntity) {
            XPBlockEntity xpBlock = (XPBlockEntity)blockEntity;
            if (!level.f_46443_) {
                if (player.m_6144_()) {
                    int xpToStore = 0;
                    if ((Integer)Configuration.SERVER.storingAmount.get() != -1) {
                        xpToStore = Math.min((Integer)Configuration.SERVER.storingAmount.get(), EnchantmentUtils.getPlayerXP(player));
                    } else if (((Boolean)Configuration.SERVER.storeUntilPreviousLevel.get()).booleanValue()) {
                        int xpForCurrentLevel = EnchantmentUtils.getExperienceForLevel(player.f_36078_);
                        xpToStore = EnchantmentUtils.getPlayerXP(player) - xpForCurrentLevel;
                        if (xpToStore == 0 && player.f_36078_ > 0) {
                            xpToStore = xpForCurrentLevel - EnchantmentUtils.getExperienceForLevel(player.f_36078_ - 1);
                        }
                    } else {
                        xpToStore = EnchantmentUtils.getPlayerXP(player);
                    }
                    if (xpToStore == 0) {
                        return InteractionResult.PASS;
                    }
                    int unused = xpBlock.addXP(xpToStore);
                    EnchantmentUtils.addPlayerXP(player, -xpToStore + unused);
                    return InteractionResult.SUCCESS;
                }
                if (!player.m_6144_()) {
                    int xpRetrieved;
                    if ((Integer)Configuration.SERVER.retrievalAmount.get() != -1) {
                        xpRetrieved = (int)((double)xpBlock.removeXP((Integer)Configuration.SERVER.retrievalAmount.get()) * (Double)Configuration.SERVER.retrievalPercentage.get());
                    } else if (((Boolean)Configuration.SERVER.retriveUntilNextLevel.get()).booleanValue()) {
                        int xpToRetrieve = EnchantmentUtils.getExperienceForLevel(player.f_36078_ + 1) - EnchantmentUtils.getPlayerXP(player);
                        xpRetrieved = (int)((double)xpBlock.removeXP(xpToRetrieve) * (Double)Configuration.SERVER.retrievalPercentage.get());
                    } else {
                        xpRetrieved = (int)((double)xpBlock.getStoredXP() * (Double)Configuration.SERVER.retrievalPercentage.get());
                        xpBlock.setStoredXP(0);
                    }
                    if (xpRetrieved > 0) {
                        this.addOrSpawnXPForPlayer(player, xpRetrieved);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void addOrSpawnXPForPlayer(Player player, int amount) {
        if (((Boolean)Configuration.SERVER.retrieveXPOrbs.get()).booleanValue()) {
            Level level = player.m_9236_();
            if (!level.f_46443_) {
                ExperienceOrb orb = new ExperienceOrb(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), amount);
                orb.getPersistentData().m_128379_("GlobalXPMarker", true);
                level.m_7967_((Entity)orb);
            }
        } else {
            int previousLevel = player.f_36078_;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.XpChange(player, amount));
            EnchantmentUtils.addPlayerXP(player, amount);
            if (previousLevel != player.f_36078_) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.LevelChange(player, player.f_36078_));
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof XPBlockEntity) {
            XPBlockEntity xpBlock = (XPBlockEntity)blockEntity;
            return Math.min(15, Math.floorDiv(xpBlock.getStoredXP(), (int)((Integer)Configuration.SERVER.xpForComparator.get())));
        }
        return 0;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (level.f_46443_ || !stack.m_41782_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof XPBlockEntity) {
            XPBlockEntity xpBlock = (XPBlockEntity)blockEntity;
            if (stack.m_41788_()) {
                xpBlock.setCustomName(stack.m_41786_());
            }
            if (stack.m_41782_()) {
                CompoundTag stackTag = stack.m_41783_();
                if (stackTag.m_128441_("BlockEntityTag")) {
                    stackTag = stackTag.m_128469_("BlockEntityTag");
                }
                xpBlock.setStoredXP(stackTag.m_128451_("stored_xp"));
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        XPBlockEntity xpBlock;
        BlockEntity blockEntity;
        if (!level.f_46443_ && player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof XPBlockEntity && (xpBlock = (XPBlockEntity)blockEntity).getStoredXP() > 0) {
            ItemStack stack = new ItemStack((ItemLike)GlobalXP.XP_BLOCK_ITEM.get());
            if (xpBlock.m_8077_()) {
                stack.m_41714_(xpBlock.m_7770_());
            }
            if (xpBlock.getStoredXP() != 0) {
                stack.m_41784_().m_128405_("stored_xp", xpBlock.getStoredXP());
            }
            ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            entity.m_32060_();
            level.m_7967_((Entity)entity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(pos))));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new XPBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : XPBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)GlobalXP.XP_BLOCK_ENTITY_TYPE.get()), XPBlockEntity::serverTick);
    }
}

