/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.WaterControlConfig;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void handleSourcePlacement(BlockEvent.CreateFluidSourceEvent event) {
        ArrayList<BlockPos> connectedWaterBlocksList = new ArrayList<BlockPos>();
        HashSet<BlockPos> connectedWaterBlocksScanned = new HashSet<BlockPos>();
        connectedWaterBlocksScanned.add(event.getPos());
        connectedWaterBlocksList.add(event.getPos());
        int maxBlocks = 1000;
        int n = 0;
        boolean isInfinite = false;
        World world = event.getWorld();
        while (!connectedWaterBlocksList.isEmpty()) {
            BlockPos toScan = (BlockPos)connectedWaterBlocksList.remove(0);
            if (++n > maxBlocks) break;
            Biome biome = world.getBiomeForCoordsBody(toScan);
            String biomeName = biome.getRegistryName().toString();
            if (WaterControlConfig.infiniteBiomeSet.contains(biomeName)) {
                isInfinite = true;
                break;
            }
            for (EnumFacing i : EnumFacing.values()) {
                BlockPos next = toScan.func_177982_a(i.func_82601_c(), i.func_96559_d(), i.func_82599_e());
                IBlockState state = world.func_180495_p(next);
                if (state.func_177230_c() != Blocks.field_150355_j && state.func_177230_c() != Blocks.field_150358_i || connectedWaterBlocksScanned.contains(next)) continue;
                connectedWaterBlocksScanned.add(next);
                connectedWaterBlocksList.add(next);
            }
        }
        if (!isInfinite) {
            event.setResult(Event.Result.DENY);
        }
    }
}

