/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class RawResourceLocation {
    protected String resourceDomain;
    protected String resourcePath;

    protected RawResourceLocation(int unused, String ... resourceName) {
        this.resourceDomain = StringUtils.isEmpty((CharSequence)resourceName[0]) ? "minecraft" : resourceName[0];
        this.resourcePath = resourceName[1];
        Validate.notNull((Object)this.resourcePath);
    }

    public RawResourceLocation(String resourceName) {
        this(0, RawResourceLocation.splitObjectName(resourceName));
    }

    public RawResourceLocation(String resourceDomainIn, String resourcePathIn) {
        this(0, resourceDomainIn, resourcePathIn);
    }

    protected static String[] splitObjectName(String toSplit) {
        String[] astring = new String[]{"minecraft", toSplit};
        int i = toSplit.indexOf(58);
        if (i >= 0) {
            astring[1] = toSplit.substring(i + 1, toSplit.length());
            if (i > 1) {
                astring[0] = toSplit.substring(0, i);
            }
        }
        return astring;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getResourceDomain() {
        return this.resourceDomain;
    }

    public String toString() {
        return this.resourceDomain + ':' + this.resourcePath;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof RawResourceLocation)) {
            return false;
        }
        RawResourceLocation resourcelocation = (RawResourceLocation)p_equals_1_;
        return this.resourceDomain.equals(resourcelocation.resourceDomain) && this.resourcePath.equals(resourcelocation.resourcePath);
    }

    public int hashCode() {
        return 31 * this.resourceDomain.hashCode() + this.resourcePath.hashCode();
    }
}

