/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.schematic;

import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.parameters.IvP;
import ivorius.reccomplex.commands.parameters.expect.RCE;
import ivorius.reccomplex.operation.OperationGenerateSchematic;
import ivorius.reccomplex.operation.OperationRegistry;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.world.gen.feature.structure.schematics.SchematicFile;
import ivorius.reccomplex.world.gen.feature.structure.schematics.SchematicLoader;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandImportSchematic
extends CommandExpecting {
    @Nonnull
    protected static SchematicFile parseSchematic(String schematicName) throws CommandException {
        SchematicFile schematicFile;
        try {
            schematicFile = SchematicLoader.loadSchematicByName(schematicName);
        }
        catch (SchematicFile.UnsupportedSchematicFormatException e) {
            throw RecurrentComplex.translations.commandException("commands.rcimportschematic.format", schematicName, e.format);
        }
        if (schematicFile == null) {
            throw RecurrentComplex.translations.commandException("commands.rcimportschematic.missing", schematicName, SchematicLoader.getLookupFolderName());
        }
        return schematicFile;
    }

    public String func_71517_b() {
        return "import";
    }

    @Override
    public void expect(Expect expect) {
        expect.then(RCE::schematic).then(MCE.pos("x", "y", "z")).named("rotation", "r").then(MCE::rotation).flag("mirror", "m");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        Function<Parameters, Parameters> c = this.expect()::declare;
        Parameters parameters = Parameters.of(args, c);
        if (args.length < 1) {
            throw RecurrentComplex.translations.wrongUsageException("commands.rcimportschematic.usage", new Object[0]);
        }
        SchematicFile schematicFile = CommandImportSchematic.parseSchematic(parameters.get(0).require());
        BlockPos pos = (BlockPos)parameters.get(MCP.pos("x", "y", "z", commandSender.func_180425_c(), false)).require();
        AxisAlignedTransform2D transform = parameters.get(IvP.transform("rotation", "mirror")).optional().orElse(AxisAlignedTransform2D.ORIGINAL);
        OperationRegistry.queueOperation(new OperationGenerateSchematic(schematicFile, transform, pos), commandSender);
    }

    public int func_82362_a() {
        return 4;
    }
}

