/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.asm;

import bre.smoothfont.config.CommonConfig;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class AsmHelper {
    public static Logger logger = LogManager.getLogger((String)"SmoothFontCore ASM");
    private static Printer printer = new Textifier();
    private static TraceMethodVisitor mp = new TraceMethodVisitor(printer);

    public static void logInfo(String msg) {
        logger.info(msg);
    }

    public static void logDebug(String msg) {
        if (CommonConfig.globalConfig != null && CommonConfig.globalConfig.debugLog) {
            logger.info(msg);
        }
    }

    public static String unmapClassName(String name) {
        return FMLDeobfuscatingRemapper.INSTANCE.unmap(name.replace('.', '/')).replace('/', '.');
    }

    public static String mapMethodName(String owner, String methodName, String desc) {
        return FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(AsmHelper.unmapClassName(owner), methodName, desc);
    }

    public static String mapFieldName(String owner, String methodName, String desc) {
        return FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(AsmHelper.unmapClassName(owner), methodName, desc);
    }

    public static void printClassByteCode(ClassReader cr, String transformedName) {
        ClassNode cnode = new ClassNode();
        cr.accept((ClassVisitor)cnode, 0);
        for (MethodNode curMnode : cnode.methods) {
            logger.info("*** Method : " + AsmHelper.mapMethodName(transformedName, curMnode.name, curMnode.desc) + " " + curMnode.desc);
            AsmHelper.printInsnList(curMnode.instructions);
        }
    }

    private static void printInsnList(InsnList insnList) {
        for (int i = 0; i < insnList.size(); ++i) {
            logger.info(i + ": " + AsmHelper.insnToString(insnList.get(i)));
        }
    }

    private static String insnToString(AbstractInsnNode insn) {
        insn.accept((MethodVisitor)mp);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString().replaceAll("\n", "");
    }
}

