/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff.items;

import com.tmtravlr.jaff.JAFFMod;
import com.tmtravlr.jaff.entities.EntityIronFishHook;
import com.tmtravlr.jaff.network.SToCMessage;
import com.tmtravlr.jaff.utils.BaitType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemHookedFishingRod
extends ItemFishingRod {
    public String modelName = "jaff:wooden_fishing_rod";
    public int maxStrain = 300;
    public double strength = 0.1;
    public String repairOreDictName = "plankWood";
    public int enchantability = 1;
    public boolean worksInLava = false;

    public ItemHookedFishingRod() {
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null || !(entityIn instanceof EntityPlayer) || !(((EntityPlayer)entityIn).field_71104_cf instanceof EntityIronFishHook) || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemHookedFishingRod)) {
                    return 0.0f;
                }
                EntityPlayer player = (EntityPlayer)entityIn;
                int strain = ((EntityIronFishHook)player.field_71104_cf).strain;
                ItemHookedFishingRod rod = (ItemHookedFishingRod)stack.func_77973_b();
                return MathHelper.func_76131_a((float)((float)(strain <= 0 ? -1 : strain) / (float)rod.maxStrain * 5.0f + 2.0f), (float)1.0f, (float)5.0f);
            }
        });
        this.func_185043_a(new ResourceLocation("cast"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).field_71104_cf instanceof EntityIronFishHook ? 1.0f : 0.0f;
            }
        });
    }

    public void registerModel() {
        JAFFMod.proxy.registerFishingRodModels((Item)this, this.modelName);
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.field_71104_cf instanceof EntityIronFishHook) {
            int i = player.field_71104_cf.func_146034_e();
            if (player.field_71104_cf != null) {
                int strain;
                if (player.field_71104_cf.field_146043_c != null) {
                    player.func_184185_a(JAFFMod.SOUND_ITEM_ROD_REEL, 0.5f, 1.0f);
                }
                if ((strain = ((EntityIronFishHook)player.field_71104_cf).strain) > this.maxStrain && player.func_70613_aW()) {
                    player.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, 1.0f);
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                    this.givePlayerBrokenScraps(player);
                    if (player instanceof EntityPlayerMP) {
                        PacketBuffer out = new PacketBuffer(Unpooled.buffer());
                        out.writeInt(4);
                        out.writeInt(Item.func_150891_b((Item)this));
                        out.func_180714_a(hand.name());
                        SToCMessage packet = new SToCMessage((ByteBuf)out);
                        JAFFMod.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)player);
                    }
                }
            } else {
                stack.func_77972_a(i, (EntityLivingBase)player);
            }
        } else {
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                int k;
                EntityIronFishHook hook = new EntityIronFishHook(world, player);
                int j = EnchantmentHelper.func_191528_c((ItemStack)stack);
                if (j > 0) {
                    hook.func_191516_a(j);
                }
                if ((k = EnchantmentHelper.func_191529_b((ItemStack)stack)) > 0) {
                    hook.func_191517_b(k);
                }
                world.func_72838_d((Entity)hook);
                PacketBuffer out = new PacketBuffer(Unpooled.buffer());
                out.writeInt(2);
                out.writeInt(player.func_145782_y());
                out.writeInt(hook.func_145782_y());
                SToCMessage packet = new SToCMessage((ByteBuf)out);
                JAFFMod.networkWrapper.sendToDimension((IMessage)packet, player.field_71093_bK);
            }
        }
        player.func_184609_a(hand);
        player.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_82789_a(ItemStack thisStack, ItemStack repairStack) {
        return !repairStack.func_190926_b() && OreDictionary.getOres((String)this.repairOreDictName).contains((Object)repairStack);
    }

    public ItemHookedFishingRod setRepairItem(String repairOreDictName) {
        this.repairOreDictName = repairOreDictName;
        return this;
    }

    public ItemHookedFishingRod setStrength(double strength) {
        this.strength = strength;
        return this;
    }

    public ItemHookedFishingRod setMaxStrain(int strain) {
        this.maxStrain = strain;
        return this;
    }

    public ItemHookedFishingRod setEnchantability(int enchant) {
        this.enchantability = enchant;
        return this;
    }

    public ItemHookedFishingRod setWorksInLava(boolean isLavaRod) {
        this.worksInLava = isLavaRod;
        return this;
    }

    public ItemHookedFishingRod setModelName(String name) {
        this.modelName = name;
        return this;
    }

    protected ItemStack getBreakItem() {
        return (ItemStack)OreDictionary.getOres((String)this.repairOreDictName).get(0);
    }

    public void givePlayerBrokenScraps(EntityPlayer player) {
        ItemStack repairItem = this.getBreakItem().func_77946_l();
        repairItem.func_190920_e(2);
        if (repairItem.func_77952_i() == Short.MAX_VALUE) {
            repairItem.func_77964_b(0);
        }
        ItemStack hook = new ItemStack(JAFFMod.ironHook, 1);
        if (!player.field_71071_by.func_70441_a(repairItem)) {
            player.func_146097_a(repairItem, true, false);
        }
        if (!player.field_71071_by.func_70441_a(hook)) {
            player.func_146097_a(hook, true, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_190926_b() || !stack.func_77942_o()) {
            return;
        }
        NBTTagList baitList = stack.func_77978_p().func_150295_c("Bait", 10);
        for (int i = 0; i < baitList.func_74745_c(); ++i) {
            NBTTagCompound currentTag = baitList.func_150305_b(i);
            String type = currentTag.func_74779_i("Type");
            if (BaitType.baitTypes.get(type) == null) continue;
            tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"rod.info.bait", (Object[])new Object[]{currentTag.func_74762_e("Count"), BaitType.baitTypes.get(type).getDisplayName()}));
        }
    }

    public void addBaitToRod(ItemStack rodStack, String bait, int amount) {
        if (rodStack.func_190926_b()) {
            return;
        }
        if (!rodStack.func_77942_o()) {
            rodStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList baitList = rodStack.func_77978_p().func_150295_c("Bait", 10);
        boolean baitAmount = false;
        for (int i = 0; i < baitList.func_74745_c(); ++i) {
            NBTTagCompound currentTag = baitList.func_150305_b(i);
            if (!currentTag.func_74779_i("Type").equals(bait)) continue;
            currentTag.func_74768_a("Count", currentTag.func_74762_e("Count") + amount);
            return;
        }
        NBTTagCompound newBaitTag = new NBTTagCompound();
        newBaitTag.func_74778_a("Type", bait);
        newBaitTag.func_74768_a("Count", amount);
        baitList.func_74742_a((NBTBase)newBaitTag);
        rodStack.func_77978_p().func_74782_a("Bait", (NBTBase)baitList);
    }
}

