/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff.items;

import com.tmtravlr.jaff.JAFFMod;
import com.tmtravlr.jaff.entities.EntityFish;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemFishBucket
extends ItemBucket {
    private final Block containedBlock;

    public ItemFishBucket(Block containedBlock, Item containerItem) {
        super(containedBlock);
        this.containedBlock = containedBlock;
        this.func_77642_a(containerItem);
    }

    public static boolean canFishGoInBucket(EntityFish fish) {
        ResourceLocation entityName = EntityList.func_191301_a((Entity)fish);
        return JAFFMod.fishWithBuckets.containsKey(entityName);
    }

    public static ItemStack createFromFish(EntityFish fish) {
        ResourceLocation entityName = EntityList.func_191301_a((Entity)fish);
        Item fishBucket = (Item)JAFFMod.fishWithBuckets.get(entityName);
        if (fishBucket == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(fishBucket);
        NBTTagCompound fishTag = new NBTTagCompound();
        fish.func_70014_b(fishTag);
        fishTag.func_74778_a("id", entityName.toString());
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74782_a("Fish", (NBTBase)fishTag);
        if (fish.func_145818_k_()) {
            stack.func_151001_c(fish.func_95999_t());
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
        ItemStack stack = player.func_184586_b(hand);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = raytraceresult.func_178782_a();
        Material material = world.func_180495_p(pos).func_185904_a();
        int meta = world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
        if (material == this.containedBlock.func_149688_o(this.containedBlock.func_176223_P())) {
            this.tryPlaceFish(stack, world, pos);
            if (!player.field_71075_bZ.field_75098_d) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.getContainerItem(stack));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        ItemStack stackCopy = stack.func_77946_l();
        ActionResult result = super.func_77659_a(world, player, hand);
        if (result.func_188397_a() == EnumActionResult.SUCCESS) {
            this.tryPlaceFish(stackCopy, world, pos.func_177972_a(raytraceresult.field_178784_b));
        }
        return result;
    }

    private EntityFish tryPlaceFish(@Nonnull ItemStack stack, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            Entity fish = stack.func_77942_o() && stack.func_77978_p().func_150297_b("Fish", 10) ? EntityList.func_75615_a((NBTTagCompound)stack.func_77978_p().func_74775_l("Fish"), (World)world) : EntityList.func_188429_b((ResourceLocation)JAFFMod.bucketsWithFish.get((Object)this), (World)world);
            if (fish != null) {
                fish.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                fish.field_70179_y = 0.0;
                fish.field_70181_x = 0.0;
                fish.field_70159_w = 0.0;
                world.func_72838_d(fish);
            }
            if (fish instanceof EntityLivingBase && stack.func_77942_o() && stack.func_82837_s()) {
                ((EntityLiving)fish).func_96094_a(stack.func_82833_r());
                ((EntityLiving)fish).func_110163_bv();
            }
            if (fish instanceof EntityFish) {
                return (EntityFish)fish;
            }
        }
        return null;
    }
}

