/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff;

import com.tmtravlr.jaff.CommonProxy;
import com.tmtravlr.jaff.ConfigOptions;
import com.tmtravlr.jaff.EnchantmentRodFireAspect;
import com.tmtravlr.jaff.JAFFEventHandler;
import com.tmtravlr.jaff.RecipeRodBait;
import com.tmtravlr.jaff.advancements.CatchFishMobTrigger;
import com.tmtravlr.jaff.advancements.FishBucketTrigger;
import com.tmtravlr.jaff.api.JustAFewFishAPI;
import com.tmtravlr.jaff.blocks.BlockTank;
import com.tmtravlr.jaff.entities.EntityFishClownfish;
import com.tmtravlr.jaff.entities.EntityFishCod;
import com.tmtravlr.jaff.entities.EntityFishPufferfish;
import com.tmtravlr.jaff.entities.EntityFishSalmon;
import com.tmtravlr.jaff.entities.EntityIronFishHook;
import com.tmtravlr.jaff.items.ItemFishBucket;
import com.tmtravlr.jaff.items.ItemHookedFishingRod;
import com.tmtravlr.jaff.network.CToSMessage;
import com.tmtravlr.jaff.network.PacketHandlerClient;
import com.tmtravlr.jaff.network.PacketHandlerServer;
import com.tmtravlr.jaff.network.SToCMessage;
import com.tmtravlr.jaff.utils.BaitType;
import com.tmtravlr.jaff.utils.FishSpawning;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="jaff", version="1.7_for_1.12", name="Just a Few Fish", acceptedMinecraftVersions="[1.12]")
public class JAFFMod {
    public static final String MODID = "jaff";
    public static final String MOD_NAME = "Just a Few Fish";
    public static final String VERSION = "1.7_for_1.12";
    @Mod.Instance(value="jaff")
    public static JAFFMod instance;
    @SidedProxy(clientSide="com.tmtravlr.jaff.ClientProxy", serverSide="com.tmtravlr.jaff.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs jaffTab;
    public static BlockTank tank;
    public static Item itemTank;
    public static ItemFishBucket codBucket;
    public static ItemFishBucket salmonBucket;
    public static ItemFishBucket clownfishBucket;
    public static ItemFishBucket pufferfishBucket;
    public static Item ironHook;
    public static Item fishBones;
    public static ItemHookedFishingRod woodFishingRod;
    public static ItemHookedFishingRod ironFishingRod;
    public static ItemHookedFishingRod goldFishingRod;
    public static ItemHookedFishingRod diamondFishingRod;
    public static SimpleNetworkWrapper networkWrapper;
    public static final ResourceLocation LOOT_ENTITIES_COD;
    public static final ResourceLocation LOOT_ENTITIES_SALMON;
    public static final ResourceLocation LOOT_ENTITIES_CLOWNFISH;
    public static final ResourceLocation LOOT_ENTITIES_PUFFERFISH;
    public static final SoundEvent SOUND_ITEM_ROD_REEL;
    public static Enchantment rodFireAspect;
    public static int nextEntityId;
    public static HashMap<ResourceLocation, ItemFishBucket> fishWithBuckets;
    public static HashMap<ItemFishBucket, ResourceLocation> bucketsWithFish;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        ConfigOptions.config = new Configuration(event.getSuggestedConfigurationFile());
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)tank);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemTank);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)codBucket);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)salmonBucket);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)clownfishBucket);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)pufferfishBucket);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)ironHook);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)fishBones);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)woodFishingRod);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)ironFishingRod);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)goldFishingRod);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)diamondFishingRod);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)SOUND_ITEM_ROD_REEL);
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        networkWrapper.registerMessage(PacketHandlerServer.class, CToSMessage.class, 0, Side.SERVER);
        networkWrapper.registerMessage(PacketHandlerClient.class, SToCMessage.class, 1, Side.CLIENT);
        rodFireAspect = (Enchantment)new EnchantmentRodFireAspect().setRegistryName(new ResourceLocation(MODID, "roasting"));
        ForgeRegistries.ENCHANTMENTS.register((IForgeRegistryEntry)rodFireAspect);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "iron_fish_hook"), EntityIronFishHook.class, (String)"iron_fish_hook", (int)0, (Object)this, (int)64, (int)5, (boolean)true);
        JustAFewFishAPI.registerFish(EntityFishCod.class, "cod", 6599880, 32968, new ResourceLocation(MODID, "fish_bucket_cod"));
        JustAFewFishAPI.registerFish(EntityFishSalmon.class, "salmon", 10373961, 4675915, new ResourceLocation(MODID, "fish_bucket_salmon"));
        JustAFewFishAPI.registerFish(EntityFishClownfish.class, "clownfish", 0xFF8000, 0xFFFFFF, new ResourceLocation(MODID, "fish_bucket_clownfish"));
        JustAFewFishAPI.registerFish(EntityFishPufferfish.class, "pufferfish", 16773160, 4365242, new ResourceLocation(MODID, "fish_bucket_pufferfish"));
        JustAFewFishAPI.registerFishBucket(new ResourceLocation(MODID, "cod"), codBucket);
        JustAFewFishAPI.registerFishBucket(new ResourceLocation(MODID, "salmon"), salmonBucket);
        JustAFewFishAPI.registerFishBucket(new ResourceLocation(MODID, "clownfish"), clownfishBucket);
        JustAFewFishAPI.registerFishBucket(new ResourceLocation(MODID, "pufferfish"), pufferfishBucket);
        JustAFewFishAPI.addSpawningWater(new FishSpawning(){

            @Override
            public void addSpawning(World world, BlockPos pos, List<Biome.SpawnListEntry> list) {
                if (ConfigOptions.enableCod) {
                    list.add(new Biome.SpawnListEntry(EntityFishCod.class, 10, 4, 4));
                }
            }
        });
        JustAFewFishAPI.addSpawningWater(new FishSpawning(){

            @Override
            public void addSpawning(World world, BlockPos pos, List<Biome.SpawnListEntry> list) {
                if (ConfigOptions.enableSalmon) {
                    if (BiomeDictionary.hasType((Biome)world.getBiomeForCoordsBody(pos), (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || BiomeDictionary.hasType((Biome)world.getBiomeForCoordsBody(pos), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                        list.add(new Biome.SpawnListEntry(EntityFishSalmon.class, 10, 4, 4));
                    } else if (BiomeDictionary.hasType((Biome)world.getBiomeForCoordsBody(pos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                        list.add(new Biome.SpawnListEntry(EntityFishSalmon.class, 1, 4, 4));
                    }
                }
            }
        });
        JustAFewFishAPI.addSpawningWater(new FishSpawning(){

            @Override
            public void addSpawning(World world, BlockPos pos, List<Biome.SpawnListEntry> list) {
                if (ConfigOptions.enableClownfish && BiomeDictionary.hasType((Biome)world.getBiomeForCoordsBody(pos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                    list.add(new Biome.SpawnListEntry(EntityFishClownfish.class, 3, 4, 4));
                }
            }
        });
        JustAFewFishAPI.addSpawningWater(new FishSpawning(){

            @Override
            public void addSpawning(World world, BlockPos pos, List<Biome.SpawnListEntry> list) {
                if (ConfigOptions.enablePufferfish && BiomeDictionary.hasType((Biome)world.getBiomeForCoordsBody(pos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                    list.add(new Biome.SpawnListEntry(EntityFishPufferfish.class, 2, 1, 1));
                }
            }
        });
        JustAFewFishAPI.addBaitType("seeds", new BaitType(){

            @Override
            public String getDisplayName() {
                return I18n.func_74838_a((String)"bait.seeds.name");
            }

            @Override
            public boolean isBait(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemSeeds || OreDictionary.getOres((String)"listAllSeed").contains((Object)stack.func_77973_b());
            }
        });
        JustAFewFishAPI.addBaitType("worms", new BaitType(){

            @Override
            public String getDisplayName() {
                return I18n.func_74838_a((String)"bait.worms.name");
            }

            @Override
            public boolean isBait(ItemStack stack) {
                for (ItemStack wormBait : ConfigOptions.wormList) {
                    if (stack.func_77973_b() != wormBait.func_77973_b() || wormBait.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != wormBait.func_77952_i()) continue;
                    return true;
                }
                return false;
            }
        });
        proxy.setTankModel();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new JAFFEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new JAFFEventHandler());
        proxy.registerClientEventHandler();
        proxy.registerRenderers();
        JustAFewFishAPI.registerRodModel(woodFishingRod);
        JustAFewFishAPI.registerRodModel(ironFishingRod);
        JustAFewFishAPI.registerRodModel(goldFishingRod);
        JustAFewFishAPI.registerRodModel(diamondFishingRod);
        Method triggerRegister = ReflectionHelper.findMethod(CriteriaTriggers.class, (String)"register", (String)"func_192118_a", (Class[])new Class[]{ICriterionTrigger.class});
        triggerRegister.setAccessible(true);
        try {
            CatchFishMobTrigger.instance = (CatchFishMobTrigger)triggerRegister.invoke(null, new CatchFishMobTrigger());
            FishBucketTrigger.instance = (FishBucketTrigger)triggerRegister.invoke(null, new FishBucketTrigger());
        }
        catch (Exception e) {
            System.out.println("[JAFF] Encountered an error while trying to load triggers.");
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ConfigOptions.loadConfig();
        ForgeRegistries.RECIPES.register(new RecipeRodBait().setRegistryName(new ResourceLocation(MODID, "rod_bait_recipe")));
    }

    public void registerEntity(Class classToSet, String entityName, int id, int trackingRange, int updateFrequency, boolean sendVelocityUpdates, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, entityName), (Class)classToSet, (String)entityName, (int)id, (Object)this, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocityUpdates, (int)primaryColor, (int)secondaryColor);
    }

    static {
        jaffTab = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)diamondFishingRod);
            }
        };
        tank = (BlockTank)((Block)new BlockTank().func_149711_c(0.5f).func_149713_g(0).func_149663_c("tank").setRegistryName("tank")).func_149647_a(jaffTab);
        itemTank = (Item)new ItemBlock((Block)tank).func_77655_b("tank").setRegistryName("tank");
        codBucket = (ItemFishBucket)((Item)new ItemFishBucket((Block)Blocks.field_150358_i, Items.field_151131_as).func_77655_b("fish_bucket_cod").setRegistryName("fish_bucket_cod")).func_77637_a(jaffTab);
        salmonBucket = (ItemFishBucket)((Item)new ItemFishBucket((Block)Blocks.field_150358_i, Items.field_151131_as).func_77655_b("fish_bucket_salmon").setRegistryName("fish_bucket_salmon")).func_77637_a(jaffTab);
        clownfishBucket = (ItemFishBucket)((Item)new ItemFishBucket((Block)Blocks.field_150358_i, Items.field_151131_as).func_77655_b("fish_bucket_clownfish").setRegistryName("fish_bucket_clownfish")).func_77637_a(jaffTab);
        pufferfishBucket = (ItemFishBucket)((Item)new ItemFishBucket((Block)Blocks.field_150358_i, Items.field_151131_as).func_77655_b("fish_bucket_pufferfish").setRegistryName("fish_bucket_pufferfish")).func_77637_a(jaffTab);
        ironHook = ((Item)new Item().func_77655_b("iron_hook").setRegistryName("iron_hook")).func_77637_a(jaffTab);
        fishBones = ((Item)new Item().func_77655_b("fish_bones").setRegistryName("fish_bones")).func_77637_a(jaffTab);
        woodFishingRod = (ItemHookedFishingRod)((Item)new ItemHookedFishingRod().setModelName("jaff:wooden_fishing_rod").setMaxStrain(80).setStrength(0.08).setRepairItem("plankWood").setEnchantability(5).func_77656_e(100).func_77655_b("wooden_fishing_rod").setRegistryName("wooden_fishing_rod")).func_77637_a(jaffTab);
        ironFishingRod = (ItemHookedFishingRod)((Item)new ItemHookedFishingRod().setModelName("jaff:iron_fishing_rod").setMaxStrain(200).setStrength(0.09).setRepairItem("ingotIron").setEnchantability(10).func_77656_e(200).func_77655_b("iron_fishing_rod").setRegistryName("iron_fishing_rod")).func_77637_a(jaffTab);
        goldFishingRod = (ItemHookedFishingRod)((Item)new ItemHookedFishingRod().setModelName("jaff:golden_fishing_rod").setMaxStrain(120).setStrength(0.11).setRepairItem("ingotGold").setEnchantability(20).func_77656_e(70).func_77655_b("golden_fishing_rod").setRegistryName("golden_fishing_rod")).func_77637_a(jaffTab);
        diamondFishingRod = (ItemHookedFishingRod)((Item)new ItemHookedFishingRod().setModelName("jaff:diamond_fishing_rod").setMaxStrain(400).setStrength(0.1).setRepairItem("gemDiamond").setEnchantability(1).func_77656_e(1000).func_77655_b("diamond_fishing_rod").setRegistryName("diamond_fishing_rod")).func_77637_a(jaffTab);
        LOOT_ENTITIES_COD = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "entities/cod"));
        LOOT_ENTITIES_SALMON = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "entities/salmon"));
        LOOT_ENTITIES_CLOWNFISH = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "entities/clownfish"));
        LOOT_ENTITIES_PUFFERFISH = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "entities/pufferfish"));
        SOUND_ITEM_ROD_REEL = (SoundEvent)new SoundEvent(new ResourceLocation(MODID, "item.rod.reel")).setRegistryName(MODID, "item.rod.reel");
        nextEntityId = 1;
        fishWithBuckets = new HashMap();
        bucketsWithFish = new HashMap();
    }
}

