/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesquark;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import maxhyper.dynamictreesquark.trees.TreeBlossoming;
import maxhyper.dynamictreesquark.trees.TreeSwampOak;
import maxhyper.dynamictreesquark.worldgen.BiomeDataBasePopulator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.quark.world.block.BlockVariantLeaves;
import vazkii.quark.world.feature.TreeVariants;

@Mod.EventBusSubscriber(modid="dynamictreesquark")
@GameRegistry.ObjectHolder(value="dynamictreesquark")
public class ModContent {
    public static ILeavesProperties blossomingLeavesProperties;
    public static ILeavesProperties swampOakLeavesProperties;
    public static ArrayList<TreeFamily> trees;
    static boolean messageSent;
    static boolean failedToLoad;

    @SubscribeEvent
    public static void onEvent(EntityJoinWorldEvent event) {
        if (!messageSent && event.getEntity() instanceof EntityPlayer) {
            if (failedToLoad) {
                event.getEntity().func_145747_a((ITextComponent)new TextComponentString("Dynamic Trees for Quark: Failed to load. Maybe Tree Variants are disabled in Quark config?"));
                messageSent = true;
            } else if (TreeVariants.enableSakura || TreeVariants.enableSwamp) {
                event.getEntity().func_145747_a((ITextComponent)new TextComponentString("Dynamic Trees for Quark: To prevent non-dynamic trees from spawning please disable Quark's Blossoming and Swamp trees (INDIVIDUALLY) in Quark world settings."));
                event.getEntity().func_145747_a((ITextComponent)new TextComponentString("Disabling Tree Variants as a whole will disable the Dynamic Trees for Quark Addon as well."));
                messageSent = true;
            }
        }
    }

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        try {
            swampOakLeavesProperties = ModContent.setUpLeaves(TreeSwampOak.leavesBlock, TreeSwampOak.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockVariantLeaves.VARIANT, (Comparable)BlockVariantLeaves.Variant.SWAMP_LEAVES), 0, "deciduous", 3, 13);
            blossomingLeavesProperties = ModContent.setUpLeaves(TreeBlossoming.leavesBlock, TreeSwampOak.leavesBlock.func_176223_P().func_177226_a((IProperty)BlockVariantLeaves.VARIANT, (Comparable)BlockVariantLeaves.Variant.SAKURA_LEAVES), 1, "deciduous", 4, 13);
            LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesquark", (int)0, (ILeavesProperties)blossomingLeavesProperties);
            LeavesPaging.getLeavesBlockForSequence((String)"dynamictreesquark", (int)1, (ILeavesProperties)swampOakLeavesProperties);
            TreeBlossoming blossomingTree = new TreeBlossoming();
            TreeSwampOak swampOakTree = new TreeSwampOak();
            Collections.addAll(trees, new TreeFamily[]{blossomingTree, swampOakTree});
            trees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
            ArrayList treeBlocks = new ArrayList();
            trees.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
            treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dynamictreesquark").values());
            registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[treeBlocks.size()]));
        }
        catch (Exception e) {
            failedToLoad = true;
        }
        Block glowcelium = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "glowcelium"));
        if (glowcelium != Blocks.field_150350_a) {
            DirtHelper.registerSoil((Block)glowcelium, (String)"funguslike");
        }
    }

    public static ILeavesProperties setUpLeaves(final Block leavesBlock, IBlockState leavesState, final int leavesMeta, String cellKit, final int smother, final int light) {
        LeavesProperties leavesProperties = new LeavesProperties(leavesState, new ItemStack(leavesBlock, 1, leavesMeta), TreeRegistry.findCellKit((String)cellKit)){

            public int getSmotherLeavesMax() {
                return smother;
            }

            public int getLightRequirement() {
                return light;
            }

            public ItemStack getPrimitiveLeavesItemStack() {
                return new ItemStack(leavesBlock, 1, leavesMeta);
            }
        };
        return leavesProperties;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ArrayList treeItems = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        registry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[treeItems.size()]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (!failedToLoad) {
            ModContent.setUpSeedRecipes("blossoming", new ItemStack(TreeBlossoming.saplingBlock, 1, 1));
            ModContent.setUpSeedRecipes("swampOak", new ItemStack(TreeSwampOak.saplingBlock, 1, 0));
        }
    }

    public static void setUpSeedRecipes(String name, ItemStack treeSapling) {
        Species treeSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesquark", name));
        ItemStack treeSeed = treeSpecies.getSeedStack(1);
        ItemStack treeTransformationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), treeSpecies.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)treeSeed, (ItemStack)treeTransformationPotion);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)treeSapling, (ItemStack)treeSeed, (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (TreeFamily tree : trees) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        LeavesPaging.getLeavesMapForModId((String)"dynamictreesquark").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
    }

    static {
        trees = new ArrayList();
        messageSent = false;
        failedToLoad = false;
    }
}

