/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.entity.item;

import java.util.ArrayList;
import java.util.List;
import logictechcorp.netherex.init.NetherExItems;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CPacketSteerBoat;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityObsidianBoat
extends EntityBoat {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityObsidianBoat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(EntityObsidianBoat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityObsidianBoat.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean>[] DATA_ID_PADDLE = new DataParameter[]{EntityDataManager.func_187226_a(EntityObsidianBoat.class, (DataSerializer)DataSerializers.field_187198_h), EntityDataManager.func_187226_a(EntityObsidianBoat.class, (DataSerializer)DataSerializers.field_187198_h)};
    private final float[] paddlePositions;
    private float outOfControlCounter;
    private float deltaRotation;
    private int lerpSteps;
    private double boatPitch;
    private double lerpY;
    private double lerpZ;
    private double boatYaw;
    private double lerpXRot;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean forwardInputDown;
    private boolean backInputDown;
    private double lavaLevel;
    private float boatGlide;
    private Status status;
    private Status previousStatus;
    private double lastYd;

    public EntityObsidianBoat(World world) {
        super(world);
        this.field_70178_ae = true;
        this.paddlePositions = new float[2];
        this.field_70156_m = true;
        this.func_70105_a(1.375f, 0.5625f);
    }

    public EntityObsidianBoat(World world, double x, double y, double z) {
        this(world);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.func_70107_b(x, y, z);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(FORWARD_DIRECTION, (Object)1);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        for (DataParameter<Boolean> parameter : DATA_ID_PADDLE) {
            this.field_70180_af.func_187214_a(parameter, (Object)false);
        }
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_70104_M() ? entity.func_174813_aQ() : null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return -0.1;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean takeDamage;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = takeDamage = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (takeDamage || this.func_70271_g() > 40.0f) {
                if (!takeDamage && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.func_145778_a((Item)NetherExItems.OBSIDIAN_BOAT, 1, 0.0f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof EntityObsidianBoat) {
            if (entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entity);
            }
        } else if (entity.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.func_70269_c(-this.func_70267_i());
        this.func_70265_b(10);
        this.func_70266_a(this.func_70271_g() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.boatPitch = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.boatYaw = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    public EnumFacing func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public void func_70071_h_() {
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        this.outOfControlCounter = this.status != Status.UNDER_LAVA && this.status != Status.UNDER_FLOWING_LAVA ? 0.0f : (this.outOfControlCounter += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.outOfControlCounter >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.func_70268_h() > 0) {
            this.func_70265_b(this.func_70268_h() - 1);
        }
        if (this.func_70271_g() > 0.0f) {
            this.func_70266_a(this.func_70271_g() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        this.tickLerp();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().size() == 0 || !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
                this.func_184445_a(false, false);
            }
            this.updateMotion();
            if (this.field_70170_p.field_72995_K) {
                this.controlBoat();
                this.field_70170_p.func_184135_a((Packet)new CPacketSteerBoat(this.func_184457_a(0), this.func_184457_a(1)));
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        for (int i = 0; i <= 1; ++i) {
            if (this.func_184457_a(i)) {
                SoundEvent event;
                if (!this.func_174814_R() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981633974483 && ((double)this.paddlePositions[i] + (double)0.3926991f) % (Math.PI * 2) >= 0.7853981633974483 && (event = this.func_193047_k()) != null) {
                    Vec3d look = this.func_70676_i(1.0f);
                    double lookX = i == 1 ? -look.field_72449_c : look.field_72449_c;
                    double lookZ = i == 1 ? look.field_72450_a : -look.field_72450_a;
                    this.field_70170_p.func_184148_a(null, this.field_70165_t + lookX, this.field_70163_u, this.field_70161_v + lookZ, event, this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        this.func_145775_I();
        List entities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelectors.func_188442_a((Entity)this));
        if (!entities.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof EntityPlayer);
            for (Entity entity : entities) {
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.field_70130_N < this.field_70130_N && entity instanceof EntityLivingBase && !(entity instanceof EntityWaterMob) && !(entity instanceof EntityPlayer)) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((Item)NetherExItems.OBSIDIAN_BOAT, 1, 0);
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double posX = this.field_70165_t + (this.boatPitch - this.field_70165_t) / (double)this.lerpSteps;
            double posY = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double posZ = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double yaw = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + yaw / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpXRot - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(posX, posY, posZ);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_184445_a(boolean leftPaddle, boolean rightPaddle) {
        this.field_70180_af.func_187227_b(DATA_ID_PADDLE[0], (Object)leftPaddle);
        this.field_70180_af.func_187227_b(DATA_ID_PADDLE[1], (Object)rightPaddle);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_184448_a(int side, float limbSwing) {
        return this.func_184457_a(side) ? (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[side] - (double)0.3926991f), (double)this.paddlePositions[side], (double)limbSwing) : 0.0f;
    }

    private Status getBoatStatus() {
        Status status = this.getUnderLavaStatus();
        if (status != null) {
            this.lavaLevel = this.func_174813_aQ().field_72337_e;
            return status;
        }
        if (this.checkInLava()) {
            return Status.IN_LAVA;
        }
        float f = this.func_184441_l();
        if (f > 0.0f) {
            this.boatGlide = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getLavaLevelAbove() {
        AxisAlignedBB boundingBox = this.func_174813_aQ();
        int minX = MathHelper.func_76128_c((double)boundingBox.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)boundingBox.field_72336_d);
        int minY = MathHelper.func_76128_c((double)boundingBox.field_72337_e);
        int maxY = MathHelper.func_76143_f((double)(boundingBox.field_72337_e - this.lastYd));
        int minZ = MathHelper.func_76128_c((double)boundingBox.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)boundingBox.field_72334_f);
        BlockPos.PooledMutableBlockPos mutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            block4: for (int y = minY; y < maxY; ++y) {
                float liquidHeight = 0.0f;
                int x = minX;
                while (true) {
                    if (x >= maxX) {
                        if (!(liquidHeight < 1.0f)) continue block4;
                        float f = (float)mutableBlockPos.func_177956_o() + liquidHeight;
                        return f;
                    }
                    for (int z = minZ; z < maxZ; ++z) {
                        mutableBlockPos.func_181079_c(x, y, z);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)mutableBlockPos);
                        if (state.func_185904_a() == Material.field_151587_i) {
                            liquidHeight = Math.max(liquidHeight, BlockLiquid.func_190973_f((IBlockState)state, (IBlockAccess)this.field_70170_p, (BlockPos)mutableBlockPos));
                        }
                        if (liquidHeight >= 1.0f) continue block4;
                    }
                    ++x;
                }
            }
            float f = maxY + 1;
            return f;
        }
        finally {
            mutableBlockPos.func_185344_t();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float func_184441_l() {
        AxisAlignedBB entityBoundingBox = this.func_174813_aQ();
        AxisAlignedBB boundingBox = new AxisAlignedBB(entityBoundingBox.field_72340_a, entityBoundingBox.field_72338_b - 0.001, entityBoundingBox.field_72339_c, entityBoundingBox.field_72336_d, entityBoundingBox.field_72338_b, entityBoundingBox.field_72334_f);
        int minX = MathHelper.func_76128_c((double)boundingBox.field_72340_a) - 1;
        int maxX = MathHelper.func_76143_f((double)boundingBox.field_72336_d) + 1;
        int minY = MathHelper.func_76128_c((double)boundingBox.field_72338_b) - 1;
        int maxY = MathHelper.func_76143_f((double)boundingBox.field_72337_e) + 1;
        int minZ = MathHelper.func_76128_c((double)boundingBox.field_72339_c) - 1;
        int maxZ = MathHelper.func_76143_f((double)boundingBox.field_72334_f) + 1;
        ArrayList list = new ArrayList();
        float slipperiness = 0.0f;
        int friction = 0;
        BlockPos.PooledMutableBlockPos mutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    int offset = (x != minX && x != maxX - 1 ? 0 : 1) + (z != minZ && z != maxZ - 1 ? 0 : 1);
                    if (offset == 2) continue;
                    for (int y = minY; y < maxY; ++y) {
                        if (offset > 0 && (y == minY || y == maxY - 1)) continue;
                        mutableBlockPos.func_181079_c(x, y, z);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)mutableBlockPos);
                        state.func_185908_a(this.field_70170_p, (BlockPos)mutableBlockPos, boundingBox, list, (Entity)this, false);
                        if (!list.isEmpty()) {
                            slipperiness += state.func_177230_c().getSlipperiness(state, (IBlockAccess)this.field_70170_p, (BlockPos)mutableBlockPos, (Entity)this);
                            ++friction;
                        }
                        list.clear();
                    }
                }
            }
        }
        finally {
            mutableBlockPos.func_185344_t();
        }
        return slipperiness / (float)friction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInLava() {
        AxisAlignedBB entityBoundingBox = this.func_174813_aQ();
        int minX = MathHelper.func_76128_c((double)entityBoundingBox.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)entityBoundingBox.field_72336_d);
        int minY = MathHelper.func_76128_c((double)entityBoundingBox.field_72338_b);
        int maxY = MathHelper.func_76143_f((double)(entityBoundingBox.field_72338_b + 0.001));
        int minZ = MathHelper.func_76128_c((double)entityBoundingBox.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)entityBoundingBox.field_72334_f);
        boolean flag = false;
        this.lavaLevel = Double.MIN_VALUE;
        BlockPos.PooledMutableBlockPos mutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        mutableBlockPos.func_181079_c(x, y, z);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)mutableBlockPos);
                        if (state.func_185904_a() != Material.field_151587_i) continue;
                        float liquidHeight = BlockLiquid.func_190972_g((IBlockState)state, (IBlockAccess)this.field_70170_p, (BlockPos)mutableBlockPos);
                        this.lavaLevel = Math.max((double)liquidHeight, this.lavaLevel);
                        flag |= entityBoundingBox.field_72338_b < (double)liquidHeight;
                    }
                }
            }
        }
        finally {
            mutableBlockPos.func_185344_t();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status getUnderLavaStatus() {
        AxisAlignedBB entityBoundingBox = this.func_174813_aQ();
        double entityHeight = entityBoundingBox.field_72337_e + 0.001;
        int minX = MathHelper.func_76128_c((double)entityBoundingBox.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)entityBoundingBox.field_72336_d);
        int minY = MathHelper.func_76128_c((double)entityBoundingBox.field_72337_e);
        int maxY = MathHelper.func_76143_f((double)entityHeight);
        int minZ = MathHelper.func_76128_c((double)entityBoundingBox.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)entityBoundingBox.field_72334_f);
        boolean flag = false;
        BlockPos.PooledMutableBlockPos mutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        mutableBlockPos.func_181079_c(x, y, z);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)mutableBlockPos);
                        if (state.func_185904_a() != Material.field_151587_i || !(entityHeight < (double)BlockLiquid.func_190972_g((IBlockState)state, (IBlockAccess)this.field_70170_p, (BlockPos)mutableBlockPos))) continue;
                        if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                            Status status = Status.UNDER_FLOWING_LAVA;
                            return status;
                        }
                        flag = true;
                    }
                }
            }
        }
        finally {
            mutableBlockPos.func_185344_t();
        }
        return flag ? Status.UNDER_LAVA : null;
    }

    private void updateMotion() {
        double gravity = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double position = 0.0;
        float momentum = 0.05f;
        if (this.previousStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.lavaLevel = this.func_174813_aQ().field_72338_b + (double)this.field_70131_O;
            this.func_70107_b(this.field_70165_t, (double)(this.getLavaLevelAbove() - this.field_70131_O) + 0.101, this.field_70161_v);
            this.field_70181_x = 0.0;
            this.lastYd = 0.0;
            this.status = Status.IN_LAVA;
        } else {
            if (this.status == Status.IN_LAVA) {
                position = (this.lavaLevel - this.func_174813_aQ().field_72338_b) / (double)this.field_70131_O;
                momentum = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_LAVA) {
                gravity = -7.0E-4;
                momentum = 0.9f;
            } else if (this.status == Status.UNDER_LAVA) {
                position = 0.01f;
                momentum = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                momentum = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                momentum = this.boatGlide;
                if (this.func_184179_bs() instanceof EntityPlayer) {
                    this.boatGlide /= 2.0f;
                }
            }
            this.field_70159_w *= (double)momentum;
            this.field_70179_y *= (double)momentum;
            this.deltaRotation *= momentum;
            this.field_70181_x += gravity;
            if (position > 0.0) {
                this.field_70181_x += position * 0.06153846016296973;
                this.field_70181_x *= 0.75;
            }
        }
    }

    private void controlBoat() {
        if (this.func_184207_aI()) {
            float speed = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation += -1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                speed += 0.005f;
            }
            this.field_70177_z += this.deltaRotation;
            if (this.forwardInputDown) {
                speed += 0.04f;
            }
            if (this.backInputDown) {
                speed -= 0.005f;
            }
            this.field_70159_w += (double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * speed);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * speed);
            this.func_184445_a(this.rightInputDown && !this.leftInputDown || this.forwardInputDown, this.leftInputDown && !this.rightInputDown || this.forwardInputDown);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float x = 0.0f;
            float height = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int index = this.func_184188_bt().indexOf(passenger);
                x = index == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    x = (float)((double)x + 0.2);
                }
            }
            Vec3d pos = new Vec3d((double)x, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + pos.field_72450_a, this.field_70163_u + (double)height, this.field_70161_v + pos.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.func_184454_a(passenger);
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int rotation = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)rotation);
                passenger.func_70034_d(passenger.func_70079_am() + (float)rotation);
            }
            if (this.func_70055_a(Material.field_151586_h)) {
                passenger.func_184210_p();
            }
        }
    }

    protected void func_184454_a(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float yaw = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float clampedYaw = MathHelper.func_76131_a((float)yaw, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += clampedYaw - yaw;
        entityToUpdate.field_70177_z += clampedYaw - yaw;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.func_184454_a(entityToUpdate);
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.outOfControlCounter < 60.0f && !this.func_70055_a(Material.field_151586_h)) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    protected void func_184231_a(double y, boolean onGround, IBlockState state, BlockPos pos) {
        this.lastYd = this.field_70181_x;
        if (!this.func_184218_aH()) {
            if (onGround) {
                if (this.field_70143_R > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_180430_e(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                            for (int i = 0; i < 3; ++i) {
                                this.func_70099_a(new ItemStack(Blocks.field_150343_Z, 1, 0), 0.0f);
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b()).func_185904_a() != Material.field_151587_i && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public boolean func_184457_a(int state) {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_ID_PADDLE[state]) != false && this.func_184179_bs() != null;
    }

    public void func_70266_a(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float func_70271_g() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void func_70265_b(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int func_70268_h() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void func_70269_c(int forwardDirection) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int func_70267_i() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    public Entity func_184179_bs() {
        List passengers = this.func_184188_bt();
        return passengers.isEmpty() ? null : (Entity)passengers.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184442_a(boolean left, boolean right, boolean forward, boolean back) {
        this.leftInputDown = left;
        this.rightInputDown = right;
        this.forwardInputDown = forward;
        this.backInputDown = back;
    }

    public static enum Status {
        IN_LAVA,
        UNDER_LAVA,
        UNDER_FLOWING_LAVA,
        ON_LAND,
        IN_AIR;

    }
}

