/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.jei.radiator;

import java.util.Iterator;
import java.util.List;
import mctmods.immersivetechnology.api.crafting.RadiatorRecipe;
import mctmods.immersivetechnology.common.util.compat.jei.GenericMultiblockIngredient;
import mctmods.immersivetechnology.common.util.compat.jei.ITRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.JEIHelper;
import mctmods.immersivetechnology.common.util.compat.jei.radiator.RadiatorRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RadiatorRecipeCategory
extends ITRecipeCategory<RadiatorRecipe, RadiatorRecipeWrapper> {
    public static ResourceLocation background = new ResourceLocation("immersivetech:textures/gui/gui_radiator_jei.png");
    private final IDrawable tankOverlay;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated drops;

    public RadiatorRecipeCategory(IGuiHelper helper) {
        super("radiator", "tile.immersivetech.metal_multiblock1.radiator.name", (IDrawable)helper.createDrawable(background, 0, 0, 159, 69), RadiatorRecipe.class, GenericMultiblockIngredient.RADIATOR);
        this.tankOverlay = helper.createDrawable(background, 161, 2, 16, 47, -2, 2, -2, 2);
        IDrawableStatic staticImage = helper.createDrawable(background, 17, 69, 32, 9);
        this.arrow = helper.createAnimatedDrawable(staticImage, 200, IDrawableAnimated.StartDirection.LEFT, false);
        staticImage = helper.createDrawable(background, 0, 69, 17, 23);
        this.drops = helper.createAnimatedDrawable(staticImage, 200, IDrawableAnimated.StartDirection.TOP, false);
    }

    public void setRecipe(IRecipeLayout recipeLayout, RadiatorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(FluidStack.class);
        int tankCapacity = 0;
        for (Object stacks : inputs) {
            Iterator iterator = stacks.iterator();
            while (iterator.hasNext()) {
                FluidStack stack = (FluidStack)iterator.next();
                if (stack.amount <= tankCapacity) continue;
                tankCapacity = stack.amount;
            }
        }
        List outputs = ingredients.getOutputs(FluidStack.class);
        for (List stacks : outputs) {
            for (FluidStack stack : stacks) {
                if (stack.amount <= tankCapacity) continue;
                tankCapacity = stack.amount;
            }
        }
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (inputs.size() > 0) {
            guiFluidStacks.init(0, true, 11, 11, 16, 47, tankCapacity, false, this.tankOverlay);
            guiFluidStacks.set(0, (List)inputs.get(0));
        }
        guiFluidStacks.init(1, false, 109, 11, 16, 47, tankCapacity, false, this.tankOverlay);
        guiFluidStacks.set(1, (List)outputs.get(0));
        guiFluidStacks.addTooltipCallback(JEIHelper.fluidTooltipCallback);
    }

    public IRecipeWrapper getRecipeWrapper(RadiatorRecipe recipe) {
        return new RadiatorRecipeWrapper(recipe);
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 52, 51);
        this.drops.draw(minecraft, 55, 32);
    }
}

