/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.jei.coolingtower;

import java.util.List;
import mctmods.immersivetechnology.api.crafting.CoolingTowerRecipe;
import mctmods.immersivetechnology.common.util.compat.jei.GenericMultiblockIngredient;
import mctmods.immersivetechnology.common.util.compat.jei.ITRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.JEIHelper;
import mctmods.immersivetechnology.common.util.compat.jei.coolingtower.CoolingTowerRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CoolingTowerRecipeCategory
extends ITRecipeCategory<CoolingTowerRecipe, CoolingTowerRecipeWrapper> {
    public static ResourceLocation background = new ResourceLocation("immersivetech:textures/gui/gui_cooling_tower.png");
    private final IDrawable tankOverlay;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated drops;

    public CoolingTowerRecipeCategory(IGuiHelper helper) {
        super("coolingTower", "tile.immersivetech.metal_multiblock.cooling_tower.name", (IDrawable)helper.createDrawable(background, 0, 0, 159, 69), CoolingTowerRecipe.class, GenericMultiblockIngredient.COOLING_TOWER);
        this.tankOverlay = helper.createDrawable(background, 161, 2, 16, 47, -2, 2, -2, 2);
        IDrawableStatic staticImage = helper.createDrawable(background, 17, 69, 32, 9);
        this.arrow = helper.createAnimatedDrawable(staticImage, 200, IDrawableAnimated.StartDirection.LEFT, false);
        staticImage = helper.createDrawable(background, 0, 69, 17, 23);
        this.drops = helper.createAnimatedDrawable(staticImage, 200, IDrawableAnimated.StartDirection.TOP, false);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CoolingTowerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(FluidStack.class);
        List outputs = ingredients.getOutputs(FluidStack.class);
        int tankSize = 0;
        for (List lists : inputs) {
            for (FluidStack fluid : lists) {
                if (fluid.amount <= tankSize) continue;
                tankSize = fluid.amount;
            }
        }
        for (List lists : outputs) {
            for (FluidStack fluid : lists) {
                if (fluid.amount <= tankSize) continue;
                tankSize = fluid.amount;
            }
        }
        int tankIndex = 0;
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (!inputs.isEmpty()) {
            guiFluidStacks.init(tankIndex, true, 11, 11, 16, 47, tankSize, true, this.tankOverlay);
            guiFluidStacks.set(tankIndex, (List)inputs.get(0));
            if (inputs.size() == 2) {
                guiFluidStacks.init(++tankIndex, true, 34, 11, 16, 47, tankSize, true, this.tankOverlay);
                guiFluidStacks.set(tankIndex, (List)inputs.get(1));
            }
        }
        if (!outputs.isEmpty()) {
            guiFluidStacks.init(++tankIndex, false, 86, 11, 16, 47, tankSize, true, this.tankOverlay);
            guiFluidStacks.set(tankIndex, (List)outputs.get(0));
            if (outputs.size() == 2) {
                guiFluidStacks.init(++tankIndex, false, 109, 11, 16, 47, tankSize, true, this.tankOverlay);
                guiFluidStacks.set(tankIndex, (List)outputs.get(1));
            }
            if (outputs.size() == 3) {
                guiFluidStacks.init(++tankIndex, false, 109, 11, 16, 47, tankSize, true, this.tankOverlay);
                guiFluidStacks.set(tankIndex, (List)outputs.get(1));
                guiFluidStacks.init(++tankIndex, false, 132, 11, 16, 47, tankSize, true, this.tankOverlay);
                guiFluidStacks.set(tankIndex, (List)outputs.get(2));
            }
        }
        guiFluidStacks.addTooltipCallback(JEIHelper.fluidTooltipCallback);
    }

    public IRecipeWrapper getRecipeWrapper(CoolingTowerRecipe recipe) {
        return new CoolingTowerRecipeWrapper(recipe);
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 52, 51);
        this.drops.draw(minecraft, 55, 32);
    }
}

