/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.common.util.Utils;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.client.MechanicalEnergyAnimation;
import mctmods.immersivetechnology.api.crafting.SteamTurbineRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySteamTurbineSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySteamTurbineMaster
extends TileEntitySteamTurbineSlave
implements ITFluidTank.TankListener {
    private static int inputTankSize = Config.ITConfig.Machines.SteamTurbine.steamTurbine_input_tankSize;
    private static int outputTankSize = Config.ITConfig.Machines.SteamTurbine.steamTurbine_output_tankSize;
    private static int maxSpeed = Config.ITConfig.MechanicalEnergy.mechanicalEnergy_speed_max;
    private static int speedGainPerTick = Config.ITConfig.Machines.SteamTurbine.steamTurbine_speed_gainPerTick;
    private static int speedLossPerTick = Config.ITConfig.Machines.SteamTurbine.steamTurbine_speed_lossPerTick;
    private static float maxRotationSpeed = Config.ITConfig.Machines.SteamTurbine.steamTurbine_speed_maxRotation;
    BlockPos fluidOutputPos;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(inputTankSize, this), new ITFluidTank(outputTankSize, this)};
    public int burnRemaining = 0;
    public int speed;
    public SteamTurbineRecipe lastRecipe;
    MechanicalEnergyAnimation animation = new MechanicalEnergyAnimation();
    ITBlockInterfaces.IMechanicalEnergy alternator;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.speed = nbt.func_74762_e("speed");
        this.animation.readFromNBT(nbt);
        this.burnRemaining = nbt.func_74762_e("burnRemaining");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("speed", this.speed);
        this.animation.writeToNBT(nbt);
        nbt.func_74768_a("burnRemaining", this.burnRemaining);
    }

    private void speedUp() {
        this.speed = Math.min(maxSpeed, this.speed + speedGainPerTick);
    }

    private void speedDown() {
        this.speed = Math.max(0, this.speed - speedLossPerTick);
    }

    private void pumpOutputOut() {
        IFluidHandler output;
        if (this.tanks[1].getFluidAmount() == 0) {
            return;
        }
        if (this.fluidOutputPos == null) {
            this.fluidOutputPos = ITUtils.LocalOffsetToWorldBlockPos(this.func_174877_v(), 0, -1, 9, this.facing, this.mirrored);
        }
        if ((output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.fluidOutputPos, (EnumFacing)this.facing.func_176734_d())) == null) {
            return;
        }
        FluidStack out = this.tanks[1].getFluid();
        int accepted = output.fill(out, false);
        if (accepted == 0) {
            return;
        }
        int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
        this.tanks[1].drain(drained, true);
    }

    public void handleSounds() {
        float level = ITUtils.remapRange(0.0f, maxSpeed, 0.5f, 1.0f, this.speed);
        BlockPos center = this.func_174877_v().func_177967_a(this.facing, 5);
        if (this.speed == 0) {
            ITSoundHandler.StopSound(center);
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float attenuation = Math.max((float)player.func_70092_e((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p()) / 8.0f, 1.0f);
            ITSounds.turbine.PlayRepeating(center, 11.0f * (level - 0.5f) / attenuation, level);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        ITSoundHandler.StopSound(this.func_174877_v().func_177967_a(this.facing, 5));
        super.onChunkUnload();
    }

    public void disassemble() {
        super.disassemble();
        BlockPos center = this.func_174877_v().func_177967_a(this.facing, 5);
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(center), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    public boolean isValidAlternator() {
        ITBlockInterfaces.IMechanicalEnergy possibleAlternator;
        TileEntity tile;
        if ((this.alternator == null || !this.alternator.isValid()) && (tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.facing, 10))) instanceof ITBlockInterfaces.IMechanicalEnergy && (possibleAlternator = (ITBlockInterfaces.IMechanicalEnergy)tile).isValid() && possibleAlternator.isMechanicalEnergyReceiver(this.facing.func_176734_d())) {
            this.alternator = possibleAlternator;
        }
        return this.alternator != null && this.alternator.isValid();
    }

    @Override
    public void func_73660_a() {
        float rotationSpeed;
        if (!this.formed) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
            return;
        }
        float f = rotationSpeed = this.speed == 0 ? 0.0f : (float)this.speed / (float)maxSpeed * maxRotationSpeed;
        if (ITUtils.setRotationAngle(this.animation, rotationSpeed)) {
            this.efficientMarkDirty();
            this.markContainingBlockForUpdate(null);
        }
        if (this.burnRemaining > 0) {
            --this.burnRemaining;
            this.speedUp();
        } else if (!this.isRSDisabled() && this.tanks[0].getFluid() != null && this.tanks[0].getFluid().getFluid() != null && this.isValidAlternator()) {
            SteamTurbineRecipe recipe;
            SteamTurbineRecipe steamTurbineRecipe = recipe = this.lastRecipe != null && this.tanks[0].getFluid().isFluidEqual(this.lastRecipe.fluidInput) ? this.lastRecipe : SteamTurbineRecipe.findFuel(this.tanks[0].getFluid());
            if (recipe != null && recipe.fluidInput.amount <= this.tanks[0].getFluidAmount()) {
                this.lastRecipe = recipe;
                this.burnRemaining = recipe.getTotalProcessTime() - 1;
                this.tanks[0].drain(recipe.fluidInput.amount, true);
                if (recipe.fluidOutput != null) {
                    this.tanks[1].fill(recipe.fluidOutput, true);
                }
                this.markContainingBlockForUpdate(null);
                this.speedUp();
            } else {
                this.speedDown();
            }
        } else {
            this.speedDown();
        }
        this.pumpOutputOut();
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntitySteamTurbineMaster master() {
        this.master = this;
        return this;
    }

    public boolean isMechanicalEnergyTransmitter(EnumFacing facing, int position) {
        return facing == this.facing && position == 58;
    }
}

