/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.crafting.SolarTowerRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.ITContent;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySolarReflectorMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySolarTowerSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.compat.ITCompatModule;
import mctmods.immersivetechnology.common.util.compat.advancedrocketry.AdvancedRocketryHelper;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.network.MessageTileSync;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySolarTowerMaster
extends TileEntitySolarTowerSlave
implements ITFluidTank.TankListener {
    private static int inputTankSize = Config.ITConfig.Machines.SolarTower.solarTower_input_tankSize;
    private static int outputTankSize = Config.ITConfig.Machines.SolarTower.solarTower_output_tankSize;
    private static int solarMaxRange = Config.ITConfig.Machines.SolarReflector.solarReflector_maxRange;
    private static int solarMinRange = Config.ITConfig.Machines.SolarReflector.solarReflector_minRange;
    private static int progressLossPerTick = Config.ITConfig.Machines.SolarTower.solarTower_progress_lossInTicks;
    private static double heatLossMultiplier = Config.ITConfig.Machines.SolarTower.solarTower_heat_loss_multiplier;
    private static float speedMult = Config.ITConfig.Machines.SolarTower.solarTower_speed_multiplier;
    private static double workingHeatLevel = Config.ITConfig.Machines.SolarTower.solarTower_heat_workingLevel;
    private static double maximumReflectorStrength = Config.ITConfig.Machines.SolarTower.solarTower_maximum_reflector_strength;
    BlockPos fluidOutputPos;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(inputTankSize, this), new ITFluidTank(outputTankSize, this)};
    public static int slotCount = 4;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
    public int recipeTimeRemaining = 0;
    public double heatLevel = 0.0;
    public double reflectorStrength = 0.0;
    public int solarIncidenceAngleSection = 0;
    private int clientUpdateCooldown = 20;
    private SolarTowerRecipe lastRecipe;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.heatLevel = nbt.func_74769_h("heatLevel");
        this.recipeTimeRemaining = nbt.func_74762_e("recipeTimeRemaining");
        this.reflectorStrength = nbt.func_74769_h("reflectorStrength");
        this.solarIncidenceAngleSection = nbt.func_74762_e("solarIncidenceAngleSection");
        if (!descPacket) {
            this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)slotCount);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74780_a("heatLevel", this.heatLevel);
        nbt.func_74768_a("recipeTimeRemaining", this.recipeTimeRemaining);
        nbt.func_74780_a("reflectorStrength", this.reflectorStrength);
        nbt.func_74768_a("solarIncidenceAngleSection", this.getSolarIncidenceAngleSection());
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    protected boolean checkReflectorPositions() {
        double totalMirrorStrength = 0.0;
        for (int x = -(solarMaxRange + 1); x <= solarMaxRange + 1; ++x) {
            for (int z = -(solarMaxRange + 1); z <= solarMaxRange + 1; ++z) {
                TileEntity tile;
                double distance = Math.sqrt(this.func_174877_v().func_177951_i((Vec3i)this.func_174877_v().func_177982_a(x, 0, z)));
                if (!(distance >= (double)solarMinRange) || !(distance <= (double)solarMaxRange) || !Utils.isBlockAt((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177982_a(x, 0, z), ITContent.blockMetalMultiblock, (int)2) || !((tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(x, 0, z))) instanceof TileEntitySolarReflectorMaster) || !((TileEntitySolarReflectorMaster)tile).setTowerCollectorPosition(this.func_174877_v().func_177982_a(0, 17, 0))) continue;
                totalMirrorStrength += ((TileEntitySolarReflectorMaster)tile).getSolarCollectorStrength();
            }
        }
        totalMirrorStrength *= (double)(this.field_145850_b.func_72896_J() ? 0.4f : 1.0f);
        if (ITCompatModule.isAdvancedRocketryLoaded) {
            totalMirrorStrength *= AdvancedRocketryHelper.getInsolation(this.field_145850_b, this.func_174877_v());
        }
        double humidityBonus = 0.075 * totalMirrorStrength * -(((double)this.field_145850_b.func_180494_b(this.func_174877_v()).func_76727_i() - 0.5) / 0.5);
        if (ITCompatModule.isAdvancedRocketryLoaded) {
            humidityBonus *= AdvancedRocketryHelper.getWaterPartialPressureMultiplier(this.field_145850_b, this.func_174877_v());
        }
        this.reflectorStrength = totalMirrorStrength += humidityBonus;
        return this.getSolarIncidenceAngleSection() != 0;
    }

    protected void detachMirrors() {
        for (int x = -(solarMaxRange + 1); x <= solarMaxRange + 1; ++x) {
            for (int z = -(solarMaxRange + 1); z <= solarMaxRange + 1; ++z) {
                TileEntity tile;
                double distance = Math.sqrt(this.func_174877_v().func_177951_i((Vec3i)this.func_174877_v().func_177982_a(x, 0, z)));
                if (!(distance >= (double)solarMinRange) || !(distance <= (double)solarMaxRange) || !Utils.isBlockAt((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177982_a(x, 0, z), ITContent.blockMetalMultiblock, (int)2) || !((tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(x, 0, z))) instanceof TileEntitySolarReflectorMaster) || !((TileEntitySolarReflectorMaster)tile).setTowerCollectorPosition(this.func_174877_v().func_177982_a(0, 17, 0))) continue;
                ((TileEntitySolarReflectorMaster)tile).detachTower(this.func_174877_v());
            }
        }
    }

    private boolean heatUp() {
        double previousHeatLevel = this.heatLevel;
        this.heatLevel = Math.min((double)this.getTemperatureIncrease() + this.heatLevel, workingHeatLevel);
        return previousHeatLevel != this.heatLevel;
    }

    protected float getTemperatureIncrease() {
        return speedMult * (float)(1 + (this.getSolarIncidenceAngleSection() - 1)) * 10.0f * (float)(this.reflectorStrength / maximumReflectorStrength) * (this.field_145850_b.func_72896_J() ? 0.1f : (this.field_145850_b.func_72911_I() ? 0.05f : 1.0f));
    }

    private boolean cooldown() {
        double previousHeatLevel = this.heatLevel;
        double heatLost = this.field_145850_b.func_72959_q().func_76939_a(this.field_145850_b.func_180494_b(this.func_174877_v()).func_180626_a(this.func_174877_v()), this.func_174877_v().func_177956_o());
        double conductionMultiplier = 1.0;
        if (ITCompatModule.isAdvancedRocketryLoaded) {
            conductionMultiplier *= AdvancedRocketryHelper.getHeatTransferCoefficient(this.field_145850_b, this.func_174877_v().func_177982_a(0, 19, 0));
        }
        this.heatLevel = Math.max(this.heatLevel - (this.field_145850_b.func_72896_J() ? 2.0 : 1.0 * (1.0 / heatLost)) * heatLossMultiplier * conductionMultiplier, 0.0);
        return previousHeatLevel != this.heatLevel;
    }

    private boolean loseProgress() {
        int previousProgress = this.recipeTimeRemaining;
        if (this.lastRecipe == null) {
            this.recipeTimeRemaining = 0;
            return true;
        }
        this.recipeTimeRemaining = Math.min(this.recipeTimeRemaining + progressLossPerTick, this.lastRecipe.getTotalProcessTime());
        return previousProgress != this.recipeTimeRemaining;
    }

    private boolean gainProgress() {
        if (this.lastRecipe == null) {
            this.recipeTimeRemaining = 0;
            return true;
        }
        --this.recipeTimeRemaining;
        if (this.recipeTimeRemaining == 0) {
            this.tanks[0].drain((int)((double)this.lastRecipe.fluidInput.amount * this.reflectorStrength / maximumReflectorStrength), true);
            this.tanks[1].fillInternal(new FluidStack(this.lastRecipe.fluidOutput.getFluid(), (int)((double)this.lastRecipe.fluidOutput.amount * this.reflectorStrength / maximumReflectorStrength)), true);
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    private void pumpOutputOut() {
        IFluidHandler output;
        if (this.tanks[1].getFluidAmount() == 0) {
            return;
        }
        if (this.fluidOutputPos == null) {
            this.fluidOutputPos = ITUtils.LocalOffsetToWorldBlockPos(this.func_174877_v(), 0, -1, -2, this.facing);
        }
        if ((output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.fluidOutputPos, (EnumFacing)this.facing.func_176734_d())) == null) {
            return;
        }
        FluidStack out = this.tanks[1].getFluid();
        int accepted = output.fill(out, false);
        if (accepted == 0) {
            return;
        }
        int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
        this.tanks[1].drain(drained, true);
    }

    public void handleSounds() {
        BlockPos center = this.func_174877_v();
        float level = (float)(this.heatLevel / workingHeatLevel);
        if (level == 0.0f) {
            ITSoundHandler.StopSound(center);
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float attenuation = Math.max((float)player.func_70092_e((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p()) / 8.0f, 1.0f);
            ITSounds.solarTower.PlayRepeating(center, 2.0f * level / attenuation, level);
        }
    }

    public int getSolarIncidenceAngleSection() {
        if (this.field_145850_b.func_175657_ab() == 3) {
            return 1;
        }
        if (this.field_145850_b.func_175657_ab() == 2) {
            return 2;
        }
        if (this.field_145850_b.func_175657_ab() == 1) {
            return 3;
        }
        if (this.field_145850_b.func_175657_ab() == 0) {
            return 4;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        if (!this.isDummy()) {
            ITSoundHandler.StopSound(this.func_174877_v());
        }
        super.onChunkUnload();
    }

    public void disassemble() {
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(center), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
        this.detachMirrors();
        super.disassemble();
    }

    public void notifyNearbyClients() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("heat", this.heatLevel);
        tag.func_74768_a("solarIncidenceAngleSection", this.getSolarIncidenceAngleSection());
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 40.0));
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        this.heatLevel = message.func_74769_h("heat");
        this.solarIncidenceAngleSection = message.func_74762_e("solarIncidenceAngleSection");
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    private boolean heatLogic() {
        boolean update = false;
        if (this.getSolarIncidenceAngleSection() != 0) {
            if (this.heatUp()) {
                update = true;
            }
        } else if (this.cooldown()) {
            update = true;
        }
        return update;
    }

    private boolean recipeLogic() {
        boolean update = false;
        if (this.heatLevel >= workingHeatLevel && !this.isRSDisabled()) {
            if (this.recipeTimeRemaining > 0) {
                if (this.gainProgress()) {
                    update = true;
                }
            } else if (this.tanks[0].getFluid() != null) {
                SolarTowerRecipe recipe;
                SolarTowerRecipe solarTowerRecipe = recipe = this.lastRecipe != null && this.tanks[0].getFluid().isFluidEqual(this.lastRecipe.fluidInput) ? this.lastRecipe : SolarTowerRecipe.findRecipe(this.tanks[0].getFluid());
                if (recipe != null && recipe.fluidInput.amount <= this.tanks[0].getFluidAmount() && recipe.fluidOutput.amount == this.tanks[1].fillInternal(recipe.fluidOutput, false)) {
                    this.lastRecipe = recipe;
                    this.recipeTimeRemaining = (int)((float)recipe.getTotalProcessTime() / (speedMult * (float)this.getSolarIncidenceAngleSection()));
                    this.gainProgress();
                    update = true;
                }
            }
        } else if (this.recipeTimeRemaining > 0 && this.loseProgress()) {
            update = true;
        }
        return update;
    }

    private boolean outputTankLogic() {
        boolean update = false;
        if (this.tanks[1].getFluidAmount() > 0) {
            ItemStack filledContainer = Utils.fillFluidContainer((IFluidHandler)this.tanks[1], (ItemStack)((ItemStack)this.inventory.get(2)), (ItemStack)((ItemStack)this.inventory.get(3)), null);
            if (!filledContainer.func_190926_b()) {
                if (!((ItemStack)this.inventory.get(3)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)filledContainer, (boolean)true)) {
                    ((ItemStack)this.inventory.get(3)).func_190917_f(filledContainer.func_190916_E());
                } else if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
                    this.inventory.set(3, (Object)filledContainer.func_77946_l());
                }
                ((ItemStack)this.inventory.get(2)).func_190918_g(1);
                if (((ItemStack)this.inventory.get(2)).func_190916_E() <= 0) {
                    this.inventory.set(2, (Object)ItemStack.field_190927_a);
                }
                this.markContainingBlockForUpdate(null);
                update = true;
            }
            this.pumpOutputOut();
        }
        return update;
    }

    private boolean inputTankLogic() {
        int amount_prev = this.tanks[0].getFluidAmount();
        ItemStack emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[0], (ItemStack)((ItemStack)this.inventory.get(0)), (ItemStack)((ItemStack)this.inventory.get(1)), null);
        if (amount_prev != this.tanks[0].getFluidAmount()) {
            if (!((ItemStack)this.inventory.get(1)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)emptyContainer, (boolean)true)) {
                ((ItemStack)this.inventory.get(1)).func_190917_f(emptyContainer.func_190916_E());
            } else if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                this.inventory.set(1, (Object)emptyContainer.func_77946_l());
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(0)).func_190916_E() <= 0) {
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            }
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        if (!this.formed) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
            return;
        }
        boolean update = false;
        if (this.field_145850_b.func_82737_E() % 600L == 0L) {
            this.checkReflectorPositions();
        }
        if (this.heatLogic()) {
            update = true;
        }
        if (this.getSolarIncidenceAngleSection() != 0 && this.recipeLogic()) {
            update = true;
        }
        if (this.outputTankLogic()) {
            update = true;
        }
        if (this.inputTankLogic()) {
            update = true;
        }
        if (this.clientUpdateCooldown > 1) {
            --this.clientUpdateCooldown;
        }
        if (update) {
            this.efficientMarkDirty();
            if (this.clientUpdateCooldown == 1) {
                this.notifyNearbyClients();
                this.clientUpdateCooldown = 20;
            }
        }
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntitySolarTowerMaster master() {
        this.master = this;
        return this;
    }
}

