/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.crafting.MeltingCrucibleRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.ITContent;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySolarMelterSlave;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySolarReflectorMaster;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.compat.ITCompatModule;
import mctmods.immersivetechnology.common.util.compat.advancedrocketry.AdvancedRocketryHelper;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class TileEntitySolarMelterMaster
extends TileEntitySolarMelterSlave
implements ITFluidTank.TankListener {
    private static int outputTankSize = Config.ITConfig.Machines.SolarMelter.solarMelter_output_tankSize;
    private static int solarMaxRange = Config.ITConfig.Machines.SolarReflector.solarReflector_maxRange;
    private static int solarMinRange = Config.ITConfig.Machines.SolarReflector.solarReflector_minRange;
    private static int energyLossPerTick = Config.ITConfig.Machines.SolarMelter.solarMelter_progress_lossEnergy;
    private static double maximumReflectorStrength = Config.ITConfig.Machines.SolarMelter.solarMelter_maximum_reflector_strength;
    BlockPos fluidOutputPos;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(outputTankSize, this)};
    public static int slotCount = 1;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
    IItemHandler insertionHandler = new IEInventoryHandler(slotCount, (IIEInventory)this, 0, new boolean[]{true}, new boolean[1]);
    public int recipeEnergyRemaining = 0;
    public double reflectorStrength = 0.0;
    public int solarIncidenceAngleSection = 0;
    private int soundVolume = 20;
    private MeltingCrucibleRecipe lastRecipe;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.recipeEnergyRemaining = nbt.func_74762_e("recipeEnergyRemaining");
        this.reflectorStrength = nbt.func_74769_h("reflectorStrength");
        this.solarIncidenceAngleSection = nbt.func_74762_e("solarIncidenceAngleSection");
        this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)slotCount);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("recipeEnergyRemaining", this.recipeEnergyRemaining);
        nbt.func_74780_a("reflectorStrength", this.reflectorStrength);
        nbt.func_74768_a("solarIncidenceAngleSection", this.getSolarIncidenceAngleSection());
        nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
    }

    protected boolean checkReflectorPositions() {
        double totalMirrorStrength = 0.0;
        for (int x = -(solarMaxRange + 1); x <= solarMaxRange + 1; ++x) {
            for (int z = -(solarMaxRange + 1); z <= solarMaxRange + 1; ++z) {
                TileEntity tile;
                double distance = Math.sqrt(this.func_174877_v().func_177951_i((Vec3i)this.func_174877_v().func_177982_a(x, -1, z)));
                if (!(distance >= (double)solarMinRange) || !(distance <= (double)solarMaxRange) || !Utils.isBlockAt((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177982_a(x, -1, z), ITContent.blockMetalMultiblock, (int)2) || !((tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(x, -1, z))) instanceof TileEntitySolarReflectorMaster) || !((TileEntitySolarReflectorMaster)tile).setTowerCollectorPosition(this.func_174877_v().func_177982_a(0, 16, 0))) continue;
                totalMirrorStrength += ((TileEntitySolarReflectorMaster)tile).getSolarCollectorStrength();
            }
        }
        totalMirrorStrength *= (double)(this.field_145850_b.func_72896_J() ? 0.4f : 1.0f);
        if (ITCompatModule.isAdvancedRocketryLoaded) {
            totalMirrorStrength *= AdvancedRocketryHelper.getInsolation(this.field_145850_b, this.func_174877_v());
        }
        double humidityBonus = 0.075 * totalMirrorStrength * -(((double)this.field_145850_b.func_180494_b(this.func_174877_v()).func_76727_i() - 0.5) / 0.5);
        if (ITCompatModule.isAdvancedRocketryLoaded) {
            humidityBonus *= AdvancedRocketryHelper.getWaterPartialPressureMultiplier(this.field_145850_b, this.func_174877_v());
        }
        this.reflectorStrength = totalMirrorStrength += humidityBonus;
        return this.getSolarIncidenceAngleSection() != 0;
    }

    private boolean loseProgress() {
        int previousProgress = this.recipeEnergyRemaining;
        if (this.lastRecipe == null) {
            this.recipeEnergyRemaining = 0;
            return true;
        }
        this.recipeEnergyRemaining = (int)Math.min((double)this.recipeEnergyRemaining + (double)energyLossPerTick * (ITCompatModule.isAdvancedRocketryLoaded ? AdvancedRocketryHelper.getHeatTransferCoefficient(this.field_145850_b, this.func_174877_v()) : 1.0), (double)this.lastRecipe.getTotalProcessEnergy());
        return previousProgress != this.recipeEnergyRemaining;
    }

    private boolean gainProgress() {
        if (this.lastRecipe == null) {
            this.recipeEnergyRemaining = 0;
            return true;
        }
        this.recipeEnergyRemaining = (int)((double)this.recipeEnergyRemaining - (double)(this.getSolarIncidenceAngleSection() * 7680) * (this.reflectorStrength / maximumReflectorStrength));
        if (this.recipeEnergyRemaining <= 0) {
            ((ItemStack)this.inventory.get(0)).func_190918_g(this.lastRecipe.itemInput.inputSize);
            this.tanks[0].fillInternal(new FluidStack(this.lastRecipe.fluidOutput.getFluid(), this.lastRecipe.fluidOutput.amount), true);
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    private void pumpOutputOut() {
        IFluidHandler output;
        if (this.tanks[0].getFluidAmount() == 0) {
            return;
        }
        if (this.fluidOutputPos == null) {
            this.fluidOutputPos = ITUtils.LocalOffsetToWorldBlockPos(this.func_174877_v(), 0, -2, -2, this.facing);
        }
        if ((output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.fluidOutputPos, (EnumFacing)this.facing.func_176734_d())) == null) {
            return;
        }
        FluidStack out = this.tanks[0].getFluid();
        int accepted = output.fill(out, false);
        if (accepted == 0) {
            return;
        }
        int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
        this.tanks[0].drain(drained, true);
    }

    public void handleSounds() {
        BlockPos center = this.func_174877_v();
        if (this.lastRecipe != null) {
            if (this.soundVolume < 1) {
                this.soundVolume = (int)((float)this.soundVolume + 0.02f);
            }
        } else if (this.soundVolume > 0) {
            this.soundVolume = (int)((float)this.soundVolume - 0.02f);
        }
        if (this.soundVolume == 0) {
            ITSoundHandler.StopSound(center);
        } else {
            float attenuation = Math.max((float)Minecraft.func_71410_x().field_71439_g.func_70092_e((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p()) / 8.0f, 1.0f);
            ITSounds.heatExchanger.PlayRepeating(center, (float)this.soundVolume / attenuation, 1.0f);
        }
    }

    public int getSolarIncidenceAngleSection() {
        if (this.field_145850_b.func_175657_ab() == 3) {
            return 1;
        }
        if (this.field_145850_b.func_175657_ab() == 2) {
            return 2;
        }
        if (this.field_145850_b.func_175657_ab() == 1) {
            return 3;
        }
        if (this.field_145850_b.func_175657_ab() == 0) {
            return 4;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        if (!this.isDummy()) {
            ITSoundHandler.StopSound(this.func_174877_v());
        }
        super.onChunkUnload();
    }

    public void disassemble() {
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(center), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
        super.disassemble();
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    private boolean recipeLogic() {
        boolean update = false;
        if (!this.isRSDisabled()) {
            if (this.recipeEnergyRemaining > 0) {
                if (this.gainProgress()) {
                    update = true;
                }
            } else if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
                MeltingCrucibleRecipe recipe;
                MeltingCrucibleRecipe meltingCrucibleRecipe = recipe = this.lastRecipe != null && this.lastRecipe.itemInput.matches(this.inventory.get(0)) ? this.lastRecipe : MeltingCrucibleRecipe.findRecipe((ItemStack)this.inventory.get(0));
                if (recipe != null && recipe.fluidOutput.amount == this.tanks[0].fillInternal(recipe.fluidOutput, false)) {
                    this.lastRecipe = recipe;
                    this.recipeEnergyRemaining = recipe.getTotalProcessEnergy();
                    this.gainProgress();
                    update = true;
                }
            }
        } else if (this.recipeEnergyRemaining > 0 && this.loseProgress()) {
            update = true;
        }
        return update;
    }

    private boolean outputTankLogic() {
        boolean update = false;
        if (this.tanks[0].getFluidAmount() > 0) {
            update = true;
            this.pumpOutputOut();
        }
        return update;
    }

    @Override
    public void func_73660_a() {
        if (!this.formed) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
            return;
        }
        boolean update = false;
        if (this.field_145850_b.func_82737_E() % 600L == 0L) {
            this.checkReflectorPositions();
        }
        if (this.getSolarIncidenceAngleSection() != 0 && this.recipeLogic()) {
            update = true;
        }
        if (this.outputTankLogic()) {
            update = true;
        }
        if (update) {
            this.efficientMarkDirty();
        }
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntitySolarMelterMaster master() {
        this.master = this;
        return this;
    }
}

