/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.shadow.shootingstar.model;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class ModelMethods {
    public static void registerItemModel(Item item) {
        ModelMethods.setMRL(item, 0, item.getRegistryName(), "inventory");
    }

    public static void registerItemModel(Item item, int meta) {
        ModelMethods.setMRL(item, meta, item.getRegistryName(), "inventory");
    }

    public static void registerItemModel(Item item, String fileName, String path) {
        ResourceLocation loc = new ResourceLocation(item.getRegistryName().func_110624_b(), path + "/" + item.getRegistryName().func_110623_a());
        ModelMethods.setMRL(item, 0, loc, "inventory");
    }

    public static void registerItemModel(Item item, int meta, String path, String invVariant) {
        String slash = "";
        if (!path.isEmpty()) {
            slash = "/";
        }
        ResourceLocation loc = new ResourceLocation(item.getRegistryName().func_110624_b(), path + slash + item.getRegistryName().func_110623_a());
        ModelMethods.setMRL(item, meta, loc, invVariant);
    }

    public static void registerItemModel(Item item, int meta, String fileName, String path, String invVariant) {
        String slash = "";
        if (!path.isEmpty()) {
            slash = "/";
        }
        ResourceLocation loc = new ResourceLocation(item.getRegistryName().func_110624_b(), path + slash + fileName);
        ModelMethods.setMRL(item, meta, loc, invVariant);
    }

    public static void registerBlockState(Item item, int meta, String path, String property, String variant) {
        ModelMethods.registerBlockState(item, meta, path, property + "=" + variant);
    }

    public static void registerBlockState(Item item, int meta, String path, String variant) {
        ResourceLocation loc = new ResourceLocation(item.getRegistryName().func_110624_b(), path + "/" + item.getRegistryName().func_110623_a());
        ModelMethods.setMRL(item, meta, loc, variant);
    }

    public static void setMRL(Item item, int meta, ResourceLocation resourceLocation, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(resourceLocation, variant));
    }

    public static void setCustomStateMapper(Block block, IStateMapper mapper) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    public static void setBlockStateMapper(Block block, IProperty ... ignoredProperties) {
        ModelMethods.setBlockStateMapper(block, block.getRegistryName().func_110623_a(), ignoredProperties);
    }

    public static void setBlockStateMapper(Block block, String blockstatePath, IProperty ... ignoredProperties) {
        ModelMethods.setBlockStateMapper(block, block.getRegistryName().func_110623_a(), blockstatePath, ignoredProperties);
    }

    public static void setBlockStateMapper(final Block block, final String fileName, final String path, final IProperty ... ignoredProperties) {
        final String slash = !path.isEmpty() ? "/" : "";
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
                for (IProperty iproperty : ignoredProperties) {
                    map.remove(iproperty);
                }
                return new ModelResourceLocation(new ResourceLocation(block.getRegistryName().func_110624_b(), path + slash + fileName), this.func_178131_a(map));
            }
        });
    }

    public static void setBlockStateMapper(Block block, String variant) {
        ModelMethods.setBlockStateMapper(block, block.getRegistryName().func_110623_a(), variant);
    }

    public static void setBlockStateMapper(Block block, String blockstatePath, String variant) {
        ModelMethods.setBlockStateMapper(block, block.getRegistryName().func_110623_a(), blockstatePath, variant);
    }

    public static void setBlockStateMapper(final Block block, final String fileName, final String path, final String variant) {
        final String slash = !path.isEmpty() ? "/" : "";
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(new ResourceLocation(block.getRegistryName().func_110624_b(), path + slash + fileName), variant);
            }
        });
    }
}

