/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.biome.data;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.json.JsonFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.world.biome.data.BiomeDataManager;
import logictechcorp.libraryex.world.generation.GenerationStage;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeData {
    public static final BiomeData EMPTY = new BiomeData(Biomes.field_76772_c, 10, true, false);
    protected final Biome biome;
    protected int generationWeight;
    protected boolean useDefaultDecorations;
    protected boolean isSubBiome;
    protected final Map<BlockType, IBlockState> biomeBlocks;
    protected final Map<GenerationStage, List<BiomeTrait>> biomeTraits;
    protected final Map<EnumCreatureType, List<Biome.SpawnListEntry>> entitySpawns;
    protected final List<BiomeData> subBiomes;

    public BiomeData(Biome biome, int generationWeight, boolean useDefaultDecorations, boolean isSubBiome) {
        this.biome = biome != null ? biome : Biomes.field_76772_c;
        this.generationWeight = generationWeight;
        this.useDefaultDecorations = useDefaultDecorations;
        this.isSubBiome = isSubBiome;
        this.biomeBlocks = new EnumMap<BlockType, IBlockState>(BlockType.class);
        this.biomeTraits = new EnumMap<GenerationStage, List<BiomeTrait>>(GenerationStage.class);
        this.entitySpawns = new EnumMap<EnumCreatureType, List<Biome.SpawnListEntry>>(EnumCreatureType.class);
        this.subBiomes = new ArrayList<BiomeData>();
    }

    public BiomeData(ResourceLocation biomeRegistryName, int generationWeight, boolean useDefaultDecorations, boolean isSubBiome) {
        this((Biome)ForgeRegistries.BIOMES.getValue(biomeRegistryName), generationWeight, useDefaultDecorations, isSubBiome);
    }

    public void addBiomeBlock(BlockType blockType, IBlockState state) {
        this.biomeBlocks.put(blockType, state);
    }

    public void addEntitySpawn(EnumCreatureType creatureType, Biome.SpawnListEntry spawnListEntry) {
        if (spawnListEntry.field_76292_a > 0) {
            this.entitySpawns.computeIfAbsent(creatureType, k -> new ArrayList()).add(spawnListEntry);
        }
        for (EnumCreatureType type : EnumCreatureType.values()) {
            this.biome.func_76747_a(type).removeIf(entry -> entry.field_76300_b == spawnListEntry.field_76300_b);
        }
    }

    public void addBiomeTrait(GenerationStage generationStage, BiomeTrait biomeTrait) {
        this.biomeTraits.computeIfAbsent(generationStage, k -> new ArrayList()).add(biomeTrait);
    }

    public void addSubBiome(BiomeData biomeData) {
        this.subBiomes.add(biomeData);
    }

    public void readFromConfig(BiomeDataManager biomeDataManager, Config config) {
        this.generationWeight = (Integer)config.getOrElse("generationWeight", (Object)this.generationWeight);
        if (this.generationWeight < 0) {
            this.generationWeight = 0;
        }
        this.useDefaultDecorations = (Boolean)config.getOrElse("useDefaultDecorations", (Object)this.useDefaultDecorations);
        this.isSubBiome = (Boolean)config.getOrElse("isSubBiome", (Object)this.isSubBiome);
        if (!(config.get("blocks") instanceof Config)) {
            config.set("blocks", (Object)JsonFormat.newConfig(LinkedHashMap::new));
        }
        Config blocks = (Config)config.get("blocks");
        this.biomeBlocks.clear();
        for (Object entry : blocks.entrySet()) {
            IBlockState state = ConfigHelper.getBlockState(config, "blocks." + entry.getKey());
            if (state == null) continue;
            this.biomeBlocks.put(BlockType.getFromIdentifier(entry.getKey()), state);
        }
        if (!(config.get("entities") instanceof List)) {
            config.set("entities", new ArrayList());
        }
        List entities = (List)config.get("entities");
        this.entitySpawns.clear();
        block1: for (Config entityConfig : entities) {
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation((String)entityConfig.get("entity")));
            if (entityEntry == null) continue;
            Class cls = entityEntry.getEntityClass();
            for (EnumCreatureType creatureType : EnumCreatureType.values()) {
                if (!EntityLiving.class.isAssignableFrom(cls) || !creatureType.func_75598_a().isAssignableFrom(cls)) continue;
                int spawnWeight = (Integer)entityConfig.getOrElse("spawnWeight", (Object)10);
                int minimumGroupCount = (Integer)entityConfig.getOrElse("minimumGroupCount", (Object)1);
                int maximumGroupCount = (Integer)entityConfig.getOrElse("maximumGroupCount", (Object)4);
                if (spawnWeight < 0) {
                    spawnWeight = 0;
                }
                this.addEntitySpawn(creatureType, new Biome.SpawnListEntry(cls, spawnWeight, minimumGroupCount, maximumGroupCount));
                continue block1;
            }
        }
        if (!(config.get("traits") instanceof List)) {
            config.set("traits", new ArrayList());
        }
        ArrayList<Config> biomeTraits = new ArrayList<Config>();
        List biomeTraitConfigs = (List)config.get("traits");
        this.biomeTraits.clear();
        for (Config biomeTraitConfig : biomeTraitConfigs) {
            BiomeTrait.Builder<?> biomeTraitBuilder = BiomeTraitRegistry.INSTANCE.getBiomeTraitBuilder(new ResourceLocation((String)biomeTraitConfig.get("trait")));
            if (biomeTraitBuilder != null) {
                Object biomeTrait = biomeTraitBuilder.create();
                ((BiomeTrait)biomeTrait).readFromConfig(biomeTraitConfig);
                this.addBiomeTrait(GenerationStage.getFromIdentifier((String)biomeTraitConfig.get("generationStage")), (BiomeTrait)biomeTrait);
            }
            biomeTraits.add(biomeTraitConfig);
        }
        config.set("traits", biomeTraits);
        if (!this.isSubBiome) {
            if (!(config.get("subBiomes") instanceof List)) {
                config.set("subBiomes", new ArrayList());
            }
            List subBiomeNames = (List)config.get("subBiomes");
            this.subBiomes.clear();
            for (String subBiomeName : subBiomeNames) {
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(subBiomeName));
                if (biome == null || !biomeDataManager.hasBiomeData(biome)) continue;
                this.subBiomes.add(biomeDataManager.getBiomeData(biome));
            }
        }
    }

    public void writeToConfig(Config config) {
        config.add("biome", (Object)this.biome.getRegistryName().toString());
        config.add("generationWeight", (Object)this.generationWeight);
        config.add("useDefaultDecorations", (Object)this.useDefaultDecorations);
        config.add("isSubBiome", (Object)this.isSubBiome);
        Config blockConfigs = JsonFormat.newConfig(LinkedHashMap::new);
        for (Map.Entry<BlockType, IBlockState> entry : this.biomeBlocks.entrySet()) {
            ConfigHelper.setBlockState(blockConfigs, entry.getKey().toString(), entry.getValue());
        }
        config.set("blocks", (Object)blockConfigs);
        ArrayList<Config> entityConfigs = new ArrayList<Config>();
        for (EnumCreatureType type : EnumCreatureType.values()) {
            if (!this.entitySpawns.containsKey(type)) {
                this.entitySpawns.put(type, new ArrayList(this.biome.func_76747_a(type)));
            }
            for (Biome.SpawnListEntry entry : this.entitySpawns.get(type)) {
                ResourceLocation entityRegistryName = EntityList.func_191306_a((Class)entry.field_76300_b);
                if (entityRegistryName == null) continue;
                Config entityConfig = JsonFormat.newConfig(LinkedHashMap::new);
                entityConfig.add("entity", (Object)entityRegistryName.toString());
                entityConfig.add("spawnWeight", (Object)entry.field_76292_a);
                entityConfig.add("minimumGroupCount", (Object)entry.field_76301_c);
                entityConfig.add("maximumGroupCount", (Object)entry.field_76299_d);
                entityConfigs.add(entityConfig);
            }
        }
        config.set("entities", entityConfigs);
        ArrayList<Config> arrayList = new ArrayList<Config>();
        for (Map.Entry<GenerationStage, List<BiomeTrait>> entry : this.biomeTraits.entrySet()) {
            for (BiomeTrait biomeTrait : entry.getValue()) {
                Config biomeTraitConfig = JsonFormat.newConfig(LinkedHashMap::new);
                biomeTrait.writeToConfig(biomeTraitConfig);
                biomeTraitConfig.add("generationStage", (Object)entry.getKey().toString());
                arrayList.add(biomeTraitConfig);
            }
        }
        config.set("traits", arrayList);
        if (!this.isSubBiome) {
            ArrayList<String> subBiomeNames = new ArrayList<String>();
            for (BiomeData biomeData : this.subBiomes) {
                if (biomeData.getBiome().getRegistryName() == null) continue;
                subBiomeNames.add(biomeData.getBiome().getRegistryName().toString());
            }
            config.set("subBiomes", subBiomeNames);
        }
    }

    public void generateTerrain(World world, Random random, ChunkPrimer primer, int posX, int posZ, double noise) {
        this.biome.func_180622_a(world, random, primer, posX, posZ, noise);
    }

    public Biome getBiome() {
        return this.biome;
    }

    public int getGenerationWeight() {
        return this.generationWeight;
    }

    public boolean useDefaultBiomeDecorations() {
        return this.useDefaultDecorations;
    }

    public boolean isSubBiome() {
        return this.isSubBiome;
    }

    public boolean isEnabled() {
        return this.generationWeight > 0;
    }

    public IBlockState getBiomeBlock(BlockType blockType) {
        IBlockState state = this.biomeBlocks.get((Object)blockType);
        if (state == null) {
            switch (blockType) {
                case SURFACE_BLOCK: {
                    state = this.biome.field_76752_A;
                    break;
                }
                case SUBSURFACE_BLOCK: {
                    state = this.biome.field_76753_B;
                    break;
                }
                case LIQUID_BLOCK: {
                    state = Blocks.field_150353_l.func_176223_P();
                }
            }
            this.addBiomeBlock(blockType, state);
        }
        return state;
    }

    public Map<BlockType, IBlockState> getBiomeBlocks() {
        return this.biomeBlocks;
    }

    public List<BiomeTrait> getBiomeTraits(GenerationStage generationStage) {
        return this.biomeTraits.computeIfAbsent(generationStage, k -> new ArrayList());
    }

    public List<Biome.SpawnListEntry> getEntitySpawns(EnumCreatureType creatureType) {
        return this.entitySpawns.computeIfAbsent(creatureType, k -> new ArrayList());
    }

    public List<BiomeData> getSubBiomes() {
        return this.subBiomes;
    }

    public static enum BlockType {
        SURFACE_BLOCK("surface"),
        SUBSURFACE_BLOCK("subsurface"),
        LIQUID_BLOCK("liquid");

        private final String identifier;

        private BlockType(String identifier) {
            this.identifier = identifier;
        }

        public static BlockType getFromIdentifier(String identifier) {
            for (BlockType type : BlockType.values()) {
                if (!type.toString().equals(identifier)) continue;
                return type;
            }
            return SURFACE_BLOCK;
        }

        public String toString() {
            return this.identifier;
        }
    }
}

