/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.statement;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.silicon.BCSiliconSprites;
import buildcraft.silicon.BCSiliconStatements;
import java.util.Locale;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TriggerTimer
extends BCStatement
implements ITriggerInternal {
    private final Duration duration;

    public TriggerTimer(Duration duration) {
        super("buildcraft:timer_" + duration.name().toLowerCase(Locale.ROOT));
        this.duration = duration;
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize("gate.trigger.timer", this.duration.duration);
    }

    @Override
    public boolean isTriggerActive(IStatementContainer source, IStatementParameter[] parameters) {
        World world = source.getTile().func_145831_w();
        return world.func_82737_E() % (long)(20 * this.duration.duration) == 0L;
    }

    @Override
    public IStatement[] getPossible() {
        return BCSiliconStatements.TRIGGER_TIMER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SpriteHolderRegistry.SpriteHolder getSprite() {
        switch (this.duration) {
            case SHORT: {
                return BCSiliconSprites.TRIGGER_TIMER_SHORT;
            }
            case MEDIUM: {
                return BCSiliconSprites.TRIGGER_TIMER_MEDIUM;
            }
        }
        return BCSiliconSprites.TRIGGER_TIMER_LONG;
    }

    public static enum Duration {
        SHORT(5),
        MEDIUM(10),
        LONG(15);

        public final int duration;

        private Duration(int duration) {
            this.duration = duration;
        }
    }
}

