/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.items;

import com.teamacronymcoders.base.items.IDropTable;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class WeightedDropTable
implements IDropTable {
    private ItemStack[][] dropTable;
    private Boolean[] fortuneTable;
    private Random rng = new Random();

    public WeightedDropTable(List<List<ItemStack>> dropTable, List<Boolean> fortuneTable) {
        this.dropTable = new ItemStack[dropTable.size()][];
        for (int slot = 0; slot < dropTable.size(); ++slot) {
            this.dropTable[slot] = dropTable.get(slot).toArray(new ItemStack[0]);
        }
        this.fortuneTable = fortuneTable.toArray(new Boolean[0]);
    }

    @Override
    public List<ItemStack> getDrops(int fortune) {
        LinkedList<ItemStack> itemsToDrop = new LinkedList<ItemStack>();
        for (int slot = 0; slot < this.dropTable.length; ++slot) {
            int count = this.fortuneTable[slot] != false ? Math.max(this.rng.nextInt(fortune + 2), 1) : 1;
            for (int i = 0; i < count; ++i) {
                ItemStack drop = this.dropTable[slot][this.rng.nextInt(this.dropTable[slot].length)];
                itemsToDrop.add(drop.func_77946_l());
            }
        }
        return itemsToDrop;
    }
}

