/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyWater;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import java.util.Random;
import maxhyper.dynamictreestbl.ModContent;
import maxhyper.dynamictreestbl.genfeatures.FeatureGenHangerVine;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.IForgeRegistry;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.block.terrain.BlockHanger;
import thebetweenlands.common.registries.BlockRegistry;

public class TreeHearthgrove
extends TreeFamily {
    public static Block leavesBlock = BlockRegistry.LEAVES_HEARTHGROVE_TREE;
    public static Block logBlock = BlockRegistry.LOG_HEARTHGROVE;
    public static Block saplingBlock = BlockRegistry.SAPLING_HEARTHGROVE;
    public static BlockBranch hearthgroveBranch = new BlockBranchBasic(new ResourceLocation("dynamictreestbl", "hearthgrovebranch").toString()){

        public int getMaxRadius() {
            return 5;
        }

        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT_MIPPED;
        }

        public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
            BlockPos.PooledMutableBlockPos checkPos = BlockPos.PooledMutableBlockPos.func_185346_s();
            boolean hasWater = false;
            IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
            if (downState.func_177230_c() instanceof BlockRootyWater) {
                float z;
                float y;
                float x;
                int i;
                if (rand.nextInt(4) == 0) {
                    for (i = 0; i < 5; ++i) {
                        x = (float)pos.func_177958_n() + rand.nextFloat();
                        y = (float)pos.func_177956_o() - 0.1f;
                        z = (float)pos.func_177952_p() + rand.nextFloat();
                        BLParticles.PURIFIER_STEAM.spawn(worldIn, (double)x, (double)y, (double)z);
                    }
                }
                if (rand.nextInt(2) == 0) {
                    for (i = 0; i < 5; ++i) {
                        x = (float)(pos.func_177958_n() - 1) + rand.nextFloat() * 2.0f;
                        y = (float)(pos.func_177956_o() - 2) + rand.nextFloat() * 3.0f;
                        z = (float)(pos.func_177952_p() - 1) + rand.nextFloat() * 2.0f;
                        worldIn.func_175688_a(EnumParticleTypes.WATER_BUBBLE, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                hasWater = true;
            }
            if (!hasWater) {
                block6: for (EnumFacing offset : EnumFacing.field_176754_o) {
                    if (!(rand.nextFloat() < 0.04f)) continue;
                    checkPos.func_181079_c(pos.func_177958_n() + offset.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + offset.func_82599_e());
                    IBlockState offsetState = worldIn.func_180495_p((BlockPos)checkPos);
                    if (offsetState.isSideSolid((IBlockAccess)worldIn, (BlockPos)checkPos, offset.func_176734_d())) continue;
                    float x = (float)pos.func_177958_n() + (offset.func_82601_c() > 0 ? 1.05f : (offset.func_82601_c() == 0 ? rand.nextFloat() : -0.05f));
                    float y = (float)pos.func_177956_o() + rand.nextFloat();
                    float z = (float)pos.func_177952_p() + (offset.func_82599_e() > 0 ? 1.05f : (offset.func_82599_e() == 0 ? rand.nextFloat() : -0.05f));
                    switch (rand.nextInt(3)) {
                        default: {
                            BLParticles.EMBER_1.spawn(worldIn, (double)x, (double)y, (double)z);
                            continue block6;
                        }
                        case 1: {
                            BLParticles.EMBER_2.spawn(worldIn, (double)x, (double)y, (double)z);
                            continue block6;
                        }
                        case 2: {
                            BLParticles.EMBER_3.spawn(worldIn, (double)x, (double)y, (double)z);
                        }
                    }
                }
            }
            checkPos.func_185344_t();
        }
    };

    public TreeHearthgrove() {
        super(new ResourceLocation("dynamictreestbl", "hearthgrove"));
        this.setPrimitiveLog(logBlock.func_176223_P());
        ModContent.hearthgroveLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(logBlock, 1, 1);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesHearthgrove(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public BlockBranch createBranch() {
        return hearthgroveBranch;
    }

    public static class FeatureGenMangrovelings
    implements IPostGenFeature {
        public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
            int[] angles = new int[2];
            angles[0] = angles[1] = world.field_73012_v.nextInt(6);
            while (angles[0] == angles[1]) {
                angles[1] = world.field_73012_v.nextInt(6);
            }
            block1: for (int a : angles) {
                double angle = Math.toRadians((float)a * 60.0f);
                float distance = 3.0f + world.field_73012_v.nextFloat() * 2.0f;
                BlockPos offPos = rootPos.func_177971_a(new Vec3i(Math.sin(angle) * (double)distance, 0.0, Math.cos(angle) * (double)distance));
                if (!safeBounds.inBounds(offPos, true) || !species.isAcceptableSoil(world, offPos, world.func_180495_p(offPos)) || !world.func_175623_d(offPos.func_177981_b(1)) || !world.func_175623_d(offPos.func_177981_b(2))) continue;
                for (EnumFacing hor : EnumFacing.field_176754_o) {
                    BlockPos offPos2 = offPos.func_177972_a(hor);
                    if (!world.func_175623_d(offPos2.func_177981_b(1)) || !world.func_175623_d(offPos2.func_177981_b(2))) continue block1;
                }
                world.func_175656_a(offPos, species.getRootyBlock(world, offPos).func_176223_P().func_177226_a((IProperty)BlockRooty.LIFE, (Comparable)Integer.valueOf(0)));
                species.getFamily().getDynamicBranch().setRadius(world, offPos.func_177981_b(1), 1, EnumFacing.DOWN, 0);
                if (world.field_73012_v.nextInt(2) == 0) {
                    world.func_175656_a(offPos.func_177981_b(2), species.getLeavesProperties().getDynamicLeavesState(1));
                    continue;
                }
                species.getFamily().getDynamicBranch().setRadius(world, offPos.func_177981_b(2), 1, EnumFacing.DOWN, 0);
                if (!world.func_175623_d(offPos.func_177981_b(3))) continue;
                world.func_175656_a(offPos.func_177981_b(3), species.getLeavesProperties().getDynamicLeavesState(1));
            }
            return false;
        }
    }

    public class SpeciesHearthgrove
    extends Species {
        protected int deepSoilTypeFlags;

        SpeciesHearthgrove(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.hearthgroveLeavesProperties);
            this.setBasicGrowingParameters(0.2f, 12.0f, 6, 5, 0.7f);
            this.setSeedStack(new ItemStack((Item)ModContent.hearthgroveSeed));
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenMangrovelings());
            this.addGenFeature((IGenFeature)new FeatureGenHangerVine(BlockRegistry.HANGER.func_176223_P().func_177226_a((IProperty)BlockHanger.CAN_GROW, (Comparable)Boolean.valueOf(true))));
        }

        public int maxBranchRadius() {
            return 5;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (newDir != EnumFacing.UP) {
                signal.energy += 0.75f;
            }
            if (newDir == EnumFacing.UP && signal.dir != EnumFacing.UP) {
                signal.energy += ((float)Math.max(Math.abs(signal.delta.func_177958_n()), Math.abs(signal.delta.func_177952_p())) - 2.0f) * 1.5f;
            }
            return newDir;
        }

        public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
            if (world.func_180495_p(rootPos).func_177230_c() == ModContent.blockRootyWaterSwamp || world.func_180495_p(rootPos).func_177230_c() == BlockRegistry.SWAMP_WATER) {
                return ModContent.blockRootyWaterSwamp;
            }
            if (world.func_180495_p(rootPos).func_177230_c() == ModContent.blockRootyWaterStagnant || world.func_180495_p(rootPos).func_177230_c() == BlockRegistry.STAGNANT_WATER) {
                return ModContent.blockRootyWaterStagnant;
            }
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"waterlike"}))) {
                return ModContent.blockRootyWater;
            }
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"sandlike"}))) {
                return ModBlocks.blockRootySand;
            }
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"mudlike"}))) {
                return ModContent.blockRootyMud;
            }
            return ModBlocks.blockRootyDirt;
        }

        public Species.LogsAndSticks getLogsAndSticks(float volume) {
            return super.getLogsAndSticks(volume * 2.5f);
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            return super.customDirectionManipulation(world, pos, radius, signal, probMap);
        }

        protected void setStandardSoils() {
            this.addAcceptableSoils(new String[]{"waterlike", "dirtlike", "mudlike"});
            this.deepSoilTypeFlags = DirtHelper.getSoilFlags((String[])new String[]{"dirtlike", "sandlike", "gravellike", "mudlike"});
        }

        public boolean isAcceptableSoil(World world, BlockPos pos, IBlockState soilBlockState) {
            boolean requiresBottom = DirtHelper.isSoilAcceptable((Block)world.func_180495_p(pos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"waterlike"}));
            return super.isAcceptableSoil(world, pos, soilBlockState) && (!requiresBottom || DirtHelper.isSoilAcceptable((Block)world.func_180495_p(pos.func_177977_b()).func_177230_c(), (int)this.deepSoilTypeFlags));
        }
    }
}

