/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.models;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import maxhyper.dynamictreestbl.models.BakedModelBlockBranchBLEvent;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelBlockBranchBLEvent
implements IModel {
    public ResourceLocation barkTexture;
    public ResourceLocation ringsTexture;
    public ResourceLocation barkTextureFrosty;
    public ResourceLocation ringsTextureFrosty;
    public ResourceLocation barkTextureSpook;
    public ResourceLocation ringsTextureSpook;
    boolean hasFrosty = true;
    boolean hasSpooky = true;

    public ModelBlockBranchBLEvent(ModelBlock modelBlock) {
        this.barkTexture = new ResourceLocation(modelBlock.func_178308_c("bark"));
        this.ringsTexture = new ResourceLocation(modelBlock.func_178308_c("rings"));
        this.barkTextureFrosty = new ResourceLocation(modelBlock.func_178308_c("bark_frosty"));
        this.ringsTextureFrosty = new ResourceLocation(modelBlock.func_178308_c("rings_frosty"));
        this.barkTextureSpook = new ResourceLocation(modelBlock.func_178308_c("bark_spook"));
        this.ringsTextureSpook = new ResourceLocation(modelBlock.func_178308_c("rings_spook"));
        if (this.barkTexture == this.barkTextureFrosty && this.ringsTexture == this.ringsTextureFrosty) {
            this.hasFrosty = false;
        }
        if (this.barkTexture == this.barkTextureSpook && this.ringsTexture == this.ringsTextureSpook) {
            this.hasSpooky = false;
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf((Object[])new ResourceLocation[0]);
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.copyOf(new HashSet<ResourceLocation>(Arrays.asList(this.barkTexture, this.ringsTexture, this.barkTextureFrosty, this.ringsTextureFrosty, this.barkTextureSpook, this.ringsTextureSpook)));
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            return new BakedModelBlockBranchBLEvent(this.barkTexture, this.ringsTexture, this.hasFrosty ? this.barkTextureFrosty : null, this.hasFrosty ? this.ringsTextureFrosty : null, this.hasSpooky ? this.barkTextureSpook : null, this.hasSpooky ? this.ringsTextureSpook : null, bakedTextureGetter);
        }
        catch (Exception exception) {
            System.err.println("BranchModel.bake() failed due to exception:" + exception);
            return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
        }
    }
}

