/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.models;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;
import thebetweenlands.common.registries.ModelRegistry;

@SideOnly(value=Side.CLIENT)
public class BakedModelBlockBranchBLEvent
implements IBakedModel {
    protected ModelBlock modelBlock;
    TextureAtlasSprite barkParticles;
    private IBakedModel[][] sleeves = new IBakedModel[6][7];
    private IBakedModel[][] cores = new IBakedModel[3][8];
    private IBakedModel[] rings = new IBakedModel[8];
    private IBakedModel[][] sleevesF = new IBakedModel[6][7];
    private IBakedModel[][] coresF = new IBakedModel[3][8];
    private IBakedModel[] ringsF = new IBakedModel[8];
    private IBakedModel[][] sleevesS = new IBakedModel[6][7];
    private IBakedModel[][] coresS = new IBakedModel[3][8];
    private IBakedModel[] ringsS = new IBakedModel[8];
    boolean hasFrosty = true;
    boolean hasSpooky = true;

    private IBakedModel[][] getSleeves() {
        if (this.hasFrosty && ModelRegistry.WINTER_EVENT.isActive()) {
            return this.sleevesF;
        }
        if (this.hasSpooky && ModelRegistry.SPOOK_EVENT.isActive()) {
            return this.sleevesS;
        }
        return this.sleeves;
    }

    private IBakedModel[][] getCores() {
        if (this.hasFrosty && ModelRegistry.WINTER_EVENT.isActive()) {
            return this.coresF;
        }
        if (this.hasFrosty && ModelRegistry.SPOOK_EVENT.isActive()) {
            return this.coresS;
        }
        return this.cores;
    }

    private IBakedModel[] getRings() {
        if (this.hasFrosty && ModelRegistry.WINTER_EVENT.isActive()) {
            return this.ringsF;
        }
        if (this.hasFrosty && ModelRegistry.SPOOK_EVENT.isActive()) {
            return this.ringsS;
        }
        return this.rings;
    }

    public BakedModelBlockBranchBLEvent(ResourceLocation barkRes, ResourceLocation ringsRes, ResourceLocation barkResF, ResourceLocation ringsResF, ResourceLocation barkResS, ResourceLocation ringsResS, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        int radius;
        this.modelBlock = new ModelBlock(null, null, null, false, false, ItemCameraTransforms.field_178357_a, null);
        if (barkResF == null || ringsResF == null) {
            this.hasFrosty = false;
        }
        if (barkResS == null || ringsResS == null) {
            this.hasSpooky = false;
        }
        TextureAtlasSprite barkIcon = bakedTextureGetter.apply(barkRes);
        TextureAtlasSprite ringIcon = bakedTextureGetter.apply(ringsRes);
        this.barkParticles = barkIcon;
        for (int i = 0; i < 8; ++i) {
            int radius2 = i + 1;
            if (radius2 < 8) {
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    this.sleeves[dir.func_176745_a()][i] = this.bakeSleeve(radius2, dir, barkIcon);
                }
            }
            this.cores[0][i] = this.bakeCore(radius2, EnumFacing.Axis.Y, barkIcon);
            this.cores[1][i] = this.bakeCore(radius2, EnumFacing.Axis.Z, barkIcon);
            this.cores[2][i] = this.bakeCore(radius2, EnumFacing.Axis.X, barkIcon);
            this.rings[i] = this.bakeCore(radius2, EnumFacing.Axis.Y, ringIcon);
        }
        if (this.hasFrosty) {
            TextureAtlasSprite barkIconF = bakedTextureGetter.apply(barkResF);
            TextureAtlasSprite ringIconF = bakedTextureGetter.apply(ringsResF);
            for (int i = 0; i < 8; ++i) {
                radius = i + 1;
                if (radius < 8) {
                    EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
                    int n = enumFacingArray.length;
                    for (int j = 0; j < n; ++j) {
                        EnumFacing dir = enumFacingArray[j];
                        this.sleevesF[dir.func_176745_a()][i] = this.bakeSleeve(radius, dir, barkIconF);
                    }
                }
                this.coresF[0][i] = this.bakeCore(radius, EnumFacing.Axis.Y, barkIconF);
                this.coresF[1][i] = this.bakeCore(radius, EnumFacing.Axis.Z, barkIconF);
                this.coresF[2][i] = this.bakeCore(radius, EnumFacing.Axis.X, barkIconF);
                this.ringsF[i] = this.bakeCore(radius, EnumFacing.Axis.Y, ringIconF);
            }
        }
        if (this.hasSpooky) {
            TextureAtlasSprite barkIconS = bakedTextureGetter.apply(barkResS);
            TextureAtlasSprite ringIconS = bakedTextureGetter.apply(ringsResS);
            for (int i = 0; i < 8; ++i) {
                radius = i + 1;
                if (radius < 8) {
                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                        this.sleevesS[dir.func_176745_a()][i] = this.bakeSleeve(radius, dir, barkIconS);
                    }
                }
                this.coresS[0][i] = this.bakeCore(radius, EnumFacing.Axis.Y, barkIconS);
                this.coresS[1][i] = this.bakeCore(radius, EnumFacing.Axis.Z, barkIconS);
                this.coresS[2][i] = this.bakeCore(radius, EnumFacing.Axis.X, barkIconS);
                this.ringsS[i] = this.bakeCore(radius, EnumFacing.Axis.Y, ringIconS);
            }
        }
    }

    public IBakedModel bakeSleeve(int radius, EnumFacing dir, TextureAtlasSprite bark) {
        boolean negative;
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.func_82601_c() != 0 ? halfSize : dradius;
        int halfSizeY = dir.func_96559_d() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.func_82599_e() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.func_82601_c() * move;
        int centerY = 16 + dir.func_96559_d() * move;
        int centerZ = 16 + dir.func_82599_e() * move;
        Vector3f posFrom = new Vector3f((float)((centerX - halfSizeX) / 2), (float)((centerY - halfSizeY) / 2), (float)((centerZ - halfSizeZ) / 2));
        Vector3f posTo = new Vector3f((float)((centerX + halfSizeX) / 2), (float)((centerY + halfSizeY) / 2), (float)((centerZ + halfSizeZ) / 2));
        boolean bl = negative = dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        if (dir.func_176740_k() == EnumFacing.Axis.Z) {
            negative = !negative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (dir.func_176734_d() == face) continue;
            BlockFaceUV uvface = null;
            if (dir == face) {
                if (radius == 1) {
                    uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
                }
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, negative ? (float)(16 - halfSize) : 0.0f, 8 + radius, negative ? 16.0f : (float)halfSize}, this.getFaceAngle(dir.func_176740_k(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(bark);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            EnumFacing face = (EnumFacing)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)bark, (EnumFacing)face, (ITransformation)ModelRotation.X0_Y0, (boolean)false));
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeCore(int radius, EnumFacing.Axis axis, TextureAtlasSprite icon) {
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, this.getFaceAngle(axis, face));
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(icon);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            EnumFacing face = (EnumFacing)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)icon, (EnumFacing)face, (ITransformation)ModelRotation.X0_Y0, (boolean)false));
        }
        return builder.func_177645_b();
    }

    public int getFaceAngle(EnumFacing.Axis axis, EnumFacing face) {
        if (axis == EnumFacing.Axis.Y) {
            return 0;
        }
        if (axis == EnumFacing.Axis.Z) {
            switch (face) {
                case UP: {
                    return 0;
                }
                case WEST: {
                    return 270;
                }
                case DOWN: {
                    return 180;
                }
            }
            return 90;
        }
        return face == EnumFacing.NORTH ? 270 : 90;
    }

    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
        ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(24);
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)blockState;
        if (blockState instanceof IExtendedBlockState) {
            EnumFacing coreRingDir;
            int coreRadius = this.getRadius(blockState);
            int[] connections = this.pollConnections(coreRadius, extendedBlockState);
            int numConnections = 0;
            for (int i : connections) {
                numConnections += i != 0 ? 1 : 0;
            }
            EnumFacing sourceDir = this.getSourceDir(coreRadius, connections);
            if (sourceDir == null) {
                sourceDir = EnumFacing.DOWN;
            }
            int coreDir = this.resolveCoreDir(sourceDir);
            EnumFacing enumFacing = coreRingDir = numConnections == 1 ? sourceDir.func_176734_d() : null;
            if (side == null || coreRadius != connections[side.func_176745_a()]) {
                if (coreRingDir == null || coreRingDir != side) {
                    quadsList.addAll(this.getCores()[coreDir][coreRadius - 1].func_188616_a(blockState, side, rand));
                } else {
                    quadsList.addAll(this.getRings()[coreRadius - 1].func_188616_a(blockState, side, rand));
                }
            }
            if (coreRadius != 8) {
                for (EnumFacing connDir : EnumFacing.field_82609_l) {
                    int idx = connDir.func_176745_a();
                    int connRadius = connections[idx];
                    if (connRadius <= 0 || connRadius != 1 && side == connDir) continue;
                    quadsList.addAll(this.getSleeves()[idx][connRadius - 1].func_188616_a((IBlockState)extendedBlockState, side, rand));
                }
            }
        }
        return quadsList;
    }

    protected int[] pollConnections(int coreRadius, IExtendedBlockState extendedBlockState) {
        int[] connections = new int[6];
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int connection = this.getConnectionRadius(extendedBlockState, (IUnlistedProperty<Integer>)BlockBranch.CONNECTIONS[dir.func_176745_a()]);
            connections[dir.func_176745_a()] = MathHelper.func_76125_a((int)connection, (int)0, (int)coreRadius);
        }
        return connections;
    }

    protected EnumFacing getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        EnumFacing sourceDir = null;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int connRadius = connections[dir.func_176745_a()];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(EnumFacing dir) {
        return dir.func_176745_a() >> 1;
    }

    protected int getRadius(IBlockState blockState) {
        return ((BlockBranchBasic)blockState.func_177230_c()).getRadius(blockState);
    }

    protected int getConnectionRadius(IExtendedBlockState iExtendedBlockState, IUnlistedProperty<Integer> whichConnection) {
        Integer connection = (Integer)iExtendedBlockState.getValue(whichConnection);
        return connection != null ? connection : 0;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.barkParticles;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.sleeves[0][0].func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }
}

