/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestbl.genfeatures;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenHangerVine
implements IPostGenFeature {
    protected int qty = 8;
    protected int maxLength = 8;
    protected float verSpread = 30.0f;
    protected float rayDistance = 5.0f;
    protected IBlockState vineState;

    public FeatureGenHangerVine(IBlockState vine) {
        this.vineState = vine;
    }

    public FeatureGenHangerVine setQuantity(int qty) {
        this.qty = qty;
        return this;
    }

    public FeatureGenHangerVine setMaxLength(int length) {
        this.maxLength = length;
        return this;
    }

    public FeatureGenHangerVine setVerSpread(float verSpread) {
        this.verSpread = verSpread;
        return this;
    }

    public FeatureGenHangerVine setRayDistance(float rayDistance) {
        this.rayDistance = rayDistance;
        return this;
    }

    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        if (safeBounds != SafeChunkBounds.ANY && !endPoints.isEmpty()) {
            for (int i = 0; i < this.qty; ++i) {
                BlockPos endPoint = endPoints.get(world.field_73012_v.nextInt(endPoints.size()));
                this.addVine(world, species, rootPos, endPoint, safeBounds);
            }
            return true;
        }
        return false;
    }

    protected void addVine(World world, Species species, BlockPos rootPos, BlockPos branchPos, SafeChunkBounds safeBounds) {
        BlockPos vinePos = CoordUtils.getRayTraceFruitPos((World)world, (Species)species, (BlockPos)rootPos, (BlockPos)branchPos, (SafeChunkBounds)safeBounds);
        if (vinePos != BlockPos.field_177992_a && safeBounds.inBounds(vinePos, true)) {
            int len = MathHelper.func_76125_a((int)(world.field_73012_v.nextInt(this.maxLength) + 3), (int)3, (int)this.maxLength);
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(vinePos);
            for (int i = 0; i < len && world.func_175623_d((BlockPos)mPos); ++i) {
                world.func_175656_a((BlockPos)mPos, this.vineState);
                mPos.func_185336_p(mPos.func_177956_o() - 1);
            }
        }
    }
}

