/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.apiimpl.network.grid.GridOpenHandler;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGridOpen
implements IMessage,
IMessageHandler<MessageGridOpen, IMessage> {
    private int windowId;
    @Nullable
    private BlockPos pos;
    @Nullable
    private ItemStack stack;
    private int slotId;
    private int gridId;

    public MessageGridOpen() {
    }

    public MessageGridOpen(int windowId, @Nullable BlockPos pos, int gridId, @Nullable ItemStack stack, int slotId) {
        if (pos == null && stack == null) {
            throw new IllegalArgumentException("Can't be both null");
        }
        this.windowId = windowId;
        this.pos = pos;
        this.stack = stack;
        this.gridId = gridId;
        this.slotId = slotId;
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readInt();
        this.gridId = buf.readInt();
        this.slotId = buf.readInt();
        if (buf.readBoolean()) {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        }
        if (buf.readBoolean()) {
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowId);
        buf.writeInt(this.gridId);
        buf.writeInt(this.slotId);
        buf.writeBoolean(this.pos != null);
        if (this.pos != null) {
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
        }
        buf.writeBoolean(this.stack != null);
        if (this.stack != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        }
    }

    public int getWindowId() {
        return this.windowId;
    }

    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public ItemStack getStack() {
        return this.stack;
    }

    public int getGridId() {
        return this.gridId;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public IMessage onMessage(MessageGridOpen message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a((Runnable)new GridOpenHandler(message));
        return null;
    }
}

