/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.worldgen;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.common.biome.BOPBiome;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.google.common.base.Optional;
import java.util.ArrayList;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class OldBiomeDataBasePopulator
implements IBiomeDataBasePopulator {
    private static final BiomePropertySelectors.IChanceSelector ok = (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK;
    private static final BiomePropertySelectors.IChanceSelector cancel = (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.CANCEL;
    private static Species swamp;
    private static Species apple;
    private static Species jungle;
    private static Species spruce;
    private static Species birch;
    private static Species oak;
    private static Species acacia;
    private static Species acaciaBrush;
    private static Species oakFloweringVine;
    private static Species oakConifer;
    private static Species megaOakConifer;
    private static Species darkOakConifer;
    private static Species darkOakDyingConifer;
    private static Species oakTwiglet;
    private static Species oakSparse;
    private static Species poplar;
    private static Species darkPoplar;
    private static Species jungleTwiglet;
    private static Species acaciaTwiglet;
    private static Species yellowAutumn;
    private static Species orangeAutumn;
    private static Species magic;
    private static Species floweringOak;
    private static Species umbran;
    private static Species umbranConifer;
    private static Species umbranConiferMega;
    private static Species oakDying;
    private static Species decayed;
    private static Species fir;
    private static Species firSmall;
    private static Species pinkCherry;
    private static Species whiteCherry;
    private static Species maple;
    private static Species dead;
    private static Species jacaranda;
    private static Species redwood;
    private static Species willow;
    private static Species pine;
    private static Species palm;
    private static Species ebony;
    private static Species ebonyTwiglet;
    private static Species mahogany;
    private static Species eucalyptus;
    private static Species bamboo;
    private static Species hellbark;
    private static Species acaciaBush;
    private static Species oakBush;
    private static Species cactus;
    private static Species mushroomRed;
    private static Species mushroomBrown;

    private static void createStaticAliases() {
        apple = OldBiomeDataBasePopulator.findVanSpecies("apple");
        jungle = OldBiomeDataBasePopulator.findVanSpecies("jungle");
        spruce = OldBiomeDataBasePopulator.findVanSpecies("spruce");
        birch = OldBiomeDataBasePopulator.findVanSpecies("birch");
        oak = OldBiomeDataBasePopulator.findVanSpecies("oak");
        acacia = OldBiomeDataBasePopulator.findVanSpecies("acacia");
        swamp = OldBiomeDataBasePopulator.findVanSpecies("oakswamp");
        oakFloweringVine = OldBiomeDataBasePopulator.findBopSpecies("oakfloweringvine");
        oakConifer = OldBiomeDataBasePopulator.findBopSpecies("oakconifer");
        megaOakConifer = OldBiomeDataBasePopulator.findBopSpecies("megaoakconifer");
        darkOakConifer = OldBiomeDataBasePopulator.findBopSpecies("darkoakconifer");
        darkOakDyingConifer = OldBiomeDataBasePopulator.findBopSpecies("darkoakdyingconifer");
        oakTwiglet = OldBiomeDataBasePopulator.findBopSpecies("oaktwiglet");
        oakSparse = OldBiomeDataBasePopulator.findBopSpecies("oaksparse");
        poplar = OldBiomeDataBasePopulator.findBopSpecies("poplar");
        darkPoplar = OldBiomeDataBasePopulator.findBopSpecies("darkpoplar");
        jungleTwiglet = OldBiomeDataBasePopulator.findBopSpecies("jungletwiglet");
        acaciaTwiglet = OldBiomeDataBasePopulator.findBopSpecies("acaciatwiglet");
        acaciaBrush = OldBiomeDataBasePopulator.findBopSpecies("acaciabrush");
        yellowAutumn = OldBiomeDataBasePopulator.findBopSpecies("yellowautumn");
        orangeAutumn = OldBiomeDataBasePopulator.findBopSpecies("orangeautumn");
        magic = OldBiomeDataBasePopulator.findBopSpecies("magic");
        umbran = OldBiomeDataBasePopulator.findBopSpecies("umbran");
        umbranConifer = OldBiomeDataBasePopulator.findBopSpecies("umbranconifer");
        umbranConiferMega = OldBiomeDataBasePopulator.findBopSpecies("umbranconifermega");
        oakDying = OldBiomeDataBasePopulator.findBopSpecies("oakdying");
        fir = OldBiomeDataBasePopulator.findBopSpecies("fir");
        firSmall = OldBiomeDataBasePopulator.findBopSpecies("firsmall");
        pinkCherry = OldBiomeDataBasePopulator.findBopSpecies("pinkcherry");
        whiteCherry = OldBiomeDataBasePopulator.findBopSpecies("whitecherry");
        maple = OldBiomeDataBasePopulator.findBopSpecies("maple");
        dead = OldBiomeDataBasePopulator.findBopSpecies("dead");
        jacaranda = OldBiomeDataBasePopulator.findBopSpecies("jacaranda");
        redwood = OldBiomeDataBasePopulator.findBopSpecies("redwood");
        willow = OldBiomeDataBasePopulator.findBopSpecies("willow");
        pine = OldBiomeDataBasePopulator.findBopSpecies("pine");
        ebony = OldBiomeDataBasePopulator.findBopSpecies("ebony");
        ebonyTwiglet = OldBiomeDataBasePopulator.findBopSpecies("ebonytwiglet");
        mahogany = OldBiomeDataBasePopulator.findBopSpecies("mahogany");
        eucalyptus = OldBiomeDataBasePopulator.findBopSpecies("eucalyptus");
        bamboo = OldBiomeDataBasePopulator.findBopSpecies("bamboo");
        hellbark = OldBiomeDataBasePopulator.findBopSpecies("hellbark");
        floweringOak = OldBiomeDataBasePopulator.findBopSpecies("floweringoak");
        decayed = OldBiomeDataBasePopulator.findBopSpecies("decayed");
        palm = OldBiomeDataBasePopulator.findBopSpecies("palm");
        cactus = OldBiomeDataBasePopulator.findVanSpecies("cactus");
        acaciaBush = OldBiomeDataBasePopulator.findBopSpecies("acaciabush");
        oakBush = OldBiomeDataBasePopulator.findBopSpecies("oakbush");
        mushroomRed = OldBiomeDataBasePopulator.findVanSpecies("mushroomred");
        mushroomBrown = OldBiomeDataBasePopulator.findVanSpecies("mushroombrn");
    }

    public void populate(BiomeDataBase dbase) {
        if (oak == null) {
            OldBiomeDataBasePopulator.createStaticAliases();
        }
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.alps_foothills, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(firSmall));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.bamboo_forest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(bamboo, 4));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.bayou, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(willow, 4));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.bog, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(poplar, 3).add(darkPoplar, 1));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.boreal_forest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(yellowAutumn, 4).add(spruce, 4).add(oak, 5));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.brushland, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(ebony, 2).add(ebonyTwiglet, 2).add(jungleTwiglet, 1).add(acaciaBrush, 1));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.chaparral, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oakTwiglet, 3));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.cherry_blossom_grove, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(pinkCherry, 6).add(whiteCherry, 4));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.coniferous_forest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(fir, 4).add(firSmall, 5));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.dead_forest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(spruce, 3).add(decayed, 1).add(oakDying, 8));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.dead_swamp, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(decayed, 1).add(dead, 2));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.eucalyptus_forest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(eucalyptus, 1).add(oakBush, 6));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.fen, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(decayed, 1).add(darkOakConifer, 5).add(darkOakDyingConifer, 10));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.grove, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(poplar, 1).add(darkPoplar, 1));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.land_of_lakes, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(spruce, 3).add(birch, 1).add(oak, 5));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.lavender_fields, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(floweringOak, 1).add(jacaranda, 3));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.lush_desert, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(decayed, 1).add(oakTwiglet, 5).add(acacia, 3));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.lush_swamp, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(swamp));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.maple_woods, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(spruce, 1).add(maple, 5));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.meadow, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(spruce, 4).add(oakBush, 3));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.mountain, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1).add(pine, 2));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.mountain_foothills, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1).add(pine, 2));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.mystic_grove, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(magic, 17).add(oakFloweringVine, 10).add(floweringOak, 8).add(jacaranda, 9).add(mushroomRed, 3).add(mushroomBrown, 1));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.oasis, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(palm, 4).add(jungleTwiglet, 2));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.ominous_woods, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(umbran, 4).add(umbranConifer, 5).add(umbranConiferMega, 4).add(decayed, 3).add(dead, 1));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.orchard, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(floweringOak, 6).add(apple, 1));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.outback, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(acaciaTwiglet, 3).add(acaciaBush, 3).add(cactus, 4));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.overgrown_cliffs, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(mahogany, 1).add(jungleTwiglet, 2).add(oakBush, 8));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.prairie, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(oakSparse));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.rainforest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(jungle, 1).add(birch, 4).add(oak, 4).add(floweringOak, 7));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.redwood_forest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(redwood));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.seasonal_forest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(yellowAutumn, 4).add(orangeAutumn, 5).add(oak, 1).add(oakDying, 2).add(maple, 4));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.shield, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(spruce, 4).add(pine, 2));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.snowy_coniferous_forest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(fir, 2).add(firSmall, 4));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.snowy_forest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 3).add(oakDying, 1));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.temperate_rainforest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oakConifer, 6).add(megaOakConifer, 10).add(willow, 3));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.tropical_island, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(palm, 4).add(jungleTwiglet, 2));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.tropical_rainforest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(jungle, 2).add(mahogany, 6));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.undergarden, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(hellbark));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.wasteland, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(decayed, 3).add(dead, 1));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.wetland, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(spruce, 5).add(willow, 3));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.woodland, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(oak));
        this.addSpeciesSelector(dbase, (Optional<Biome>)BOPBiomes.xeric_shrubland, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(acaciaTwiglet, 1).add(cactus, 1));
        this.addSpeciesSelector(dbase, Biomes.field_76787_r, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(palm));
        this.addSpeciesSelector(dbase, Biomes.field_76767_f, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 8).add(birch, 2).add(floweringOak, 1));
        this.addSpeciesSelector(dbase, Biomes.field_76785_t, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 8).add(birch, 2).add(floweringOak, 1));
        this.addSpeciesSelector(dbase, Biomes.field_76770_e, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(spruce));
        this.addSpeciesSelector(dbase, Biomes.field_150580_W, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(spruce));
        this.addSpeciesSelector(dbase, Biomes.field_76780_h, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(swamp, 5).add(willow, 1));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.alps_foothills, this.scale(0.05));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.bamboo_forest, this.scale(0.25, 0.75));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.bayou, this.scale(0.8));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.bog, this.scale(0.75, 0.25, 0.7));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.boreal_forest, this.scale());
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.brushland, this.scale(0.75, 0.25, 0.4));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.chaparral, this.scale(0.7));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.cherry_blossom_grove, this.scale(0.3));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.coniferous_forest, this.scale(0.5, 0.5, 0.95));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.dead_forest, this.scale(0.3));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.dead_swamp, this.scale(0.06));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.eucalyptus_forest, this.scale(0.5, 0.5));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.fen, this.scale(0.9));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.grove, this.scale(0.25));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.lavender_fields, this.scale(0.1));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.lush_desert, this.scale(0.4));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.lush_swamp, this.scale(0.8));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.maple_woods, this.scale());
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.meadow, this.scale(0.25));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.mountain, this.scale(0.3));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.mountain_foothills, this.scale(0.3));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.mystic_grove, this.scale());
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.oasis, this.scale(0.25, 0.75, 0.7));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.ominous_woods, this.scale());
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.orchard, this.scale(0.5));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.outback, this.scale(0.45));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.overgrown_cliffs, this.scale(0.75, 0.25));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.prairie, this.scale(0.03));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.rainforest, this.scale());
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.redwood_forest, this.scale(0.25, 0.2));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.seasonal_forest, this.scale(0.9));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.shield, this.scale(0.9));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.snowy_coniferous_forest, this.scale(0.8));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.snowy_forest, this.scale(0.3));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.temperate_rainforest, this.scale());
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.tropical_island, this.scale(0.5, 0.5));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.tropical_rainforest, this.scale(0.5, 0.5));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.undergarden, this.scale(0.0, 1.0));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.wasteland, this.scale(0.03));
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.wetland, this.scale());
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.woodland, this.scale());
        this.addDensitySelector(dbase, (Optional<Biome>)BOPBiomes.xeric_shrubland, this.scale(0.4));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.alps_foothills, this.rand(0.5f));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.bamboo_forest, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.brushland, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.bog, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.chaparral, this.rand(0.7f));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.dead_swamp, this.rand(0.6f));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.eucalyptus_forest, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.lavender_fields, this.rand(0.3f));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.lush_desert, this.rand(0.4f));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.meadow, this.rand(0.6f));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.oasis, (rnd, spc, rad) -> !spc.equals(palm) || rnd.nextFloat() < 0.3f ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.outback, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.overgrown_cliffs, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.prairie, this.rand(0.075f));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.quagmire, this.rand(0.02f));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.rainforest, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.redwood_forest, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.tropical_island, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.tropical_rainforest, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.undergarden, ok);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.wasteland, this.rand(0.3f));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.xeric_shrubland, this.rand(0.7f));
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.cold_desert, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.crag, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.flower_field, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.flower_island, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.glacier, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.grassland, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.gravel_beach, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.highland, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.mangrove, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.marsh, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.moor, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.origin_beach, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.origin_island, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.pasture, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.sacred_springs, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.shrubland, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.steppe, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.tundra, cancel);
        this.addChanceSelector(dbase, (Optional<Biome>)BOPBiomes.volcanic_island, cancel);
        ArrayList blackList = new ArrayList();
        blackList.addAll(BOPBiomes.flower_island.asSet());
        blackList.addAll(BOPBiomes.sacred_springs.asSet());
        blackList.addAll(BOPBiomes.origin_island.asSet());
        blackList.addAll(BOPBiomes.shrubland.asSet());
        blackList.addAll(BOPBiomes.tundra.asSet());
        blackList.addAll(BOPBiomes.mangrove.asSet());
        Biome.field_185377_q.forEach(biome -> {
            if (biome.getRegistryName().func_110624_b().equals("biomesoplenty") && !blackList.contains(biome)) {
                if (biome != null && biome instanceof BOPBiome) {
                    ((BOPBiome)biome).removeGenerator("trees");
                    ((BOPBiome)biome).removeGenerator("big_red_mushroom");
                    ((BOPBiome)biome).removeGenerator("big_brown_mushroom");
                    if (!ModConfigs.vanillaCactusWorldGen) {
                        ((BOPBiome)biome).removeGenerator("cacti");
                    }
                }
                dbase.setCancelVanillaTreeGen(biome, true);
            }
        });
        if (BOPBiomes.tundra.isPresent()) {
            dbase.setCancelVanillaTreeGen((Biome)BOPBiomes.tundra.get(), true);
        }
        if (BOPBiomes.shrubland.isPresent()) {
            dbase.setCancelVanillaTreeGen((Biome)BOPBiomes.shrubland.get(), true);
        }
        if (BOPBiomes.mangrove.isPresent()) {
            dbase.setCancelVanillaTreeGen((Biome)BOPBiomes.mangrove.get(), true);
        }
        this.removeTreeGen(BOPBiomes.forest_extension);
        this.removeTreeGen(BOPBiomes.forest_hills_extension);
        this.removeTreeGen(BOPBiomes.extreme_hills_extension);
        this.removeTreeGen(BOPBiomes.extreme_hills_plus_extension);
        this.removeTreeGen(BOPBiomes.swampland_extension);
        dbase.setIsSubterranean((Biome)BOPBiomes.undergarden.orNull(), true);
    }

    private void removeTreeGen(IExtendedBiome extendedBiome) {
        extendedBiome.getGenerationManager().removeGenerator("trees");
    }

    private static Species findBopSpecies(String name) {
        return TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", name));
    }

    private static Species findVanSpecies(String name) {
        return TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", name));
    }

    private void addSpeciesSelector(BiomeDataBase dbase, Optional<Biome> biome, BiomePropertySelectors.ISpeciesSelector selector) {
        if (biome.isPresent()) {
            this.addSpeciesSelector(dbase, (Biome)biome.get(), selector);
        }
    }

    private void addSpeciesSelector(BiomeDataBase dbase, Biome biome, BiomePropertySelectors.ISpeciesSelector selector) {
        dbase.setSpeciesSelector(biome, selector, BiomeDataBase.Operation.REPLACE);
    }

    private void addChanceSelector(BiomeDataBase dbase, Optional<Biome> biome, BiomePropertySelectors.IChanceSelector selector) {
        if (biome.isPresent()) {
            dbase.setChanceSelector((Biome)biome.get(), selector, BiomeDataBase.Operation.REPLACE);
        }
    }

    private BiomePropertySelectors.IChanceSelector rand(float threshhold) {
        return (rnd, spc, rad) -> rnd.nextFloat() < threshhold ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL;
    }

    private void addDensitySelector(BiomeDataBase dbase, Optional<Biome> biome, BiomePropertySelectors.IDensitySelector selector) {
        if (biome.isPresent()) {
            dbase.setDensitySelector((Biome)biome.get(), selector, BiomeDataBase.Operation.REPLACE);
        }
    }

    private BiomePropertySelectors.IDensitySelector scale() {
        return (rnd, nd) -> nd;
    }

    private BiomePropertySelectors.IDensitySelector scale(double factor1) {
        return (rnd, nd) -> nd * factor1;
    }

    private BiomePropertySelectors.IDensitySelector scale(double factor1, double addend) {
        return (rnd, nd) -> nd * factor1 + addend;
    }

    private BiomePropertySelectors.IDensitySelector scale(double factor1, double addend, double factor2) {
        return (rnd, nd) -> (nd * factor1 + addend) * factor2;
    }
}

