/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPLeaves;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import dynamictreesbop.ModConfigs;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorFruit;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesPersimmon
extends Species {
    public static float fruitingOffset = 1.5f;

    public SpeciesPersimmon(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "persimmon"), treeFamily, ModContent.leaves.get("oakdying"));
        this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.65f);
        this.envFactor(BiomeDictionary.Type.LUSH, 0.75f);
        this.envFactor(BiomeDictionary.Type.SPOOKY, 1.05f);
        this.envFactor(BiomeDictionary.Type.DEAD, 1.05f);
        this.generateSeed();
        this.setFlowerSeasonHold(fruitingOffset - 0.5f, fruitingOffset + 0.5f);
        this.addDropCreator((IDropCreator)new DropCreatorFruit(BOPItems.persimmon));
        this.setRequiresTileEntity(true);
        this.leavesProperties.setTree(treeFamily);
        treeFamily.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.DEAD);
        this.addGenFeature((IGenFeature)new FeatureGenFruit(ModContent.persimmonFruit){

            public int getQuantity(boolean worldGen) {
                return 10;
            }
        }.setRayDistance(4.0f));
    }

    public boolean generate(World world, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        if (ModConfigs.enablePersimmonTrees) {
            return super.generate(world, rootPos, biome, random, radius, safeBounds);
        }
        Species def = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", "oakdying"));
        return def.generate(world, rootPos, biome, random, radius, safeBounds);
    }

    public float seasonalFruitProductionFactor(World world, BlockPos pos) {
        float offset = fruitingOffset;
        return SeasonHelper.globalSeasonalFruitProductionFactor((World)world, (BlockPos)pos, (float)offset);
    }

    public boolean testFlowerSeasonHold(World world, BlockPos pos, float seasonValue) {
        return SeasonHelper.isSeasonBetween((float)seasonValue, (float)this.flowerSeasonHoldMin, (float)this.flowerSeasonHoldMax);
    }

    public boolean isBiomePerfect(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD);
    }

    public int maxBranchRadius() {
        return 8;
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
            }
            return true;
        }
        return false;
    }
}

