/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMudHole;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import dynamictreesbop.ModConfigs;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorFruit;
import dynamictreesbop.items.ItemMangroveSeed;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeMangrove
extends TreeFamily {
    public TreeMangrove() {
        super(new ResourceLocation("dynamictreesbop", "mangrove"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.MANGROVE);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.MANGROVE));
        ModContent.leaves.get("mangrove").setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.MANGROVE);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesMangrove(this));
    }

    public BlockBranch createBranch() {
        String branchName = this.getName() + "branch";
        return new BlockBranchBasic(branchName){

            public int getMaxRadius() {
                return 4;
            }

            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.CUTOUT_MIPPED;
            }
        };
    }

    public static class FeatureGenMangrovelings
    implements IPostGenFeature {
        public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
            int[] angles = new int[2];
            angles[0] = angles[1] = world.field_73012_v.nextInt(6);
            while (angles[0] == angles[1]) {
                angles[1] = world.field_73012_v.nextInt(6);
            }
            block1: for (int a : angles) {
                double angle = Math.toRadians((float)a * 60.0f);
                float distance = Math.min(3.0f + world.field_73012_v.nextFloat() * 2.0f, (float)radius);
                BlockPos offPos = rootPos.func_177971_a(new Vec3i(Math.sin(angle) * (double)distance, 0.0, Math.cos(angle) * (double)distance));
                if (!safeBounds.inBounds(offPos, true) || !species.isAcceptableSoil(world, offPos, world.func_180495_p(offPos)) || !world.func_175623_d(offPos.func_177981_b(1)) || !world.func_175623_d(offPos.func_177981_b(2))) continue;
                for (EnumFacing hor : EnumFacing.field_176754_o) {
                    BlockPos offPos2 = offPos.func_177972_a(hor);
                    if (!world.func_175623_d(offPos2.func_177981_b(1)) || !world.func_175623_d(offPos2.func_177981_b(2))) continue block1;
                }
                world.func_175656_a(offPos, species.getRootyBlock(world, offPos).func_176223_P().func_177226_a((IProperty)BlockRooty.LIFE, (Comparable)Integer.valueOf(0)));
                species.getFamily().getDynamicBranch().setRadius(world, offPos.func_177981_b(1), 1, EnumFacing.DOWN, 0);
                if (world.field_73012_v.nextInt(2) == 0) {
                    world.func_175656_a(offPos.func_177981_b(2), species.getLeavesProperties().getDynamicLeavesState(1));
                    continue;
                }
                species.getFamily().getDynamicBranch().setRadius(world, offPos.func_177981_b(2), 1, EnumFacing.DOWN, 0);
                if (!world.func_175623_d(offPos.func_177981_b(3))) continue;
                world.func_175656_a(offPos.func_177981_b(3), species.getLeavesProperties().getDynamicLeavesState(1));
            }
            return false;
        }
    }

    public class SpeciesMangrove
    extends Species {
        protected int deepSoilTypeFlags;

        public SpeciesMangrove(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("mangrove"));
            this.setBasicGrowingParameters(0.13f, 10.0f, 1, 2, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.15f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.2f);
            this.envFactor(BiomeDictionary.Type.HOT, 1.1f);
            this.envFactor(BiomeDictionary.Type.WET, 1.1f);
            ItemMangroveSeed seed = new ItemMangroveSeed(this.getRegistryName().func_110623_a() + "seed");
            this.setSeedStack(new ItemStack((Item)seed));
            if (!ModConfigs.enablePearTrees) {
                this.addDropCreator((IDropCreator)new DropCreatorFruit(BOPItems.pear));
            }
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenMudHole(BOPBlocks.mud.func_176223_P()));
            this.addGenFeature((IGenFeature)new FeatureGenMangrovelings());
        }

        public Species.LogsAndSticks getLogsAndSticks(float volume) {
            return super.getLogsAndSticks(1.0f + volume);
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesMangrove.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.mangrove.orNull()});
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            return super.customDirectionManipulation(world, pos, radius, signal, probMap);
        }

        protected void setStandardSoils() {
            this.addAcceptableSoils(new String[]{"waterlike"});
            this.deepSoilTypeFlags = DirtHelper.getSoilFlags((String[])new String[]{"dirtlike", "sandlike", "mudlike"});
        }

        public boolean isAcceptableSoil(World world, BlockPos pos, IBlockState soilBlockState) {
            return super.isAcceptableSoil(world, pos, soilBlockState) && DirtHelper.isSoilAcceptable((Block)world.func_180495_p(pos.func_177977_b()).func_177230_c(), (int)this.deepSoilTypeFlags);
        }

        public boolean isAcceptableSoilForWorldgen(World world, BlockPos pos, IBlockState soilBlockState) {
            if (world.func_181545_F() - 1 != pos.func_177956_o()) {
                return false;
            }
            return soilBlockState.func_177230_c() == BOPBlocks.mud || super.isAcceptableSoilForWorldgen(world, pos, soilBlockState);
        }

        public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
            return ModContent.rootyWater;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (newDir != EnumFacing.UP) {
                signal.energy += 0.75f;
            }
            if (newDir == EnumFacing.UP && signal.dir != EnumFacing.UP) {
                signal.energy += ((float)Math.max(Math.abs(signal.delta.func_177958_n()), Math.abs(signal.delta.func_177952_p())) - 2.0f) * 1.5f;
            }
            return newDir;
        }
    }
}

