/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.common.block.BlockBOPLeaves;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import dynamictreesbop.ModContent;
import dynamictreesbop.cells.DTBOPLeafClusters;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TreeBamboo
extends TreeFamily {
    public TreeBamboo() {
        super(new ResourceLocation("dynamictreesbop", "bamboo"));
        this.setPrimitiveLog(((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("biomesoplenty", "bamboo"))).func_176223_P());
        this.setStick(ItemStack.field_190927_a);
        ModContent.leaves.get("bamboo").setTree((TreeFamily)this);
        this.hasConiferVariants = true;
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.BAMBOO);
    }

    public BlockBranch createBranch() {
        return new BlockBranchBasic(this.getName() + "branch"){

            public int setRadius(World world, BlockPos pos, int radius, EnumFacing dir, int flags) {
                return super.setRadius(world, pos, MathHelper.func_76125_a((int)radius, (int)1, (int)3), dir, flags);
            }

            @SideOnly(value=Side.CLIENT)
            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.CUTOUT_MIPPED;
            }
        };
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesBamboo(this));
    }

    public class NodeInflatorBamboo
    implements INodeInspector {
        private float radius;
        private BlockPos last;
        Species species;
        SimpleVoxmap leafMap;

        public NodeInflatorBamboo(Species species, SimpleVoxmap leafMap) {
            this.species = species;
            this.leafMap = leafMap;
            this.last = BlockPos.field_177992_a;
        }

        public boolean run(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
            BlockBranch branch = TreeHelper.getBranch((IBlockState)blockState);
            if (branch != null) {
                this.radius = 1.0f;
            }
            return false;
        }

        public boolean returnRun(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
            BlockBranch branch = TreeHelper.getBranch((IBlockState)blockState);
            if (branch != null) {
                float areaAccum = this.radius * this.radius;
                boolean isTop = world.func_180495_p(pos.func_177977_b()).func_177230_c() == branch;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    if (dir.equals((Object)fromDir)) continue;
                    BlockPos dPos = pos.func_177972_a(dir);
                    if (dPos.equals((Object)this.last)) {
                        isTop = false;
                        continue;
                    }
                    IBlockState deltaBlockState = world.func_180495_p(dPos);
                    ITreePart treepart = TreeHelper.getTreePart((IBlockState)deltaBlockState);
                    if (!branch.isSameTree(treepart)) continue;
                    int branchRadius = treepart.getRadius(deltaBlockState);
                    areaAccum += (float)(branchRadius * branchRadius);
                }
                if (isTop) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    SimpleVoxmap leafCluster = DTBOPLeafClusters.eucalyptusTop;
                    this.leafMap.blitMax(pos, leafCluster);
                } else {
                    this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                    float secondaryThickness = this.species.getFamily().getSecondaryThickness();
                    if (this.radius < secondaryThickness) {
                        this.radius = secondaryThickness;
                    }
                    branch.setRadius(world, pos, (int)Math.floor(this.radius), null);
                    this.leafMap.setVoxel(pos, (byte)32);
                    if (Math.floor(this.radius) <= 2.0 && pos.func_177956_o() > 5) {
                        SimpleVoxmap leafCluster = DTBOPLeafClusters.eucalyptus;
                        this.leafMap.blitMax(pos, leafCluster);
                    }
                }
                this.last = pos;
            }
            return false;
        }
    }

    public class SpeciesBamboo
    extends Species {
        SpeciesBamboo(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("bamboo"));
            this.setBasicGrowingParameters(0.125f, 11.0f, 4, 4, 1.5f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.25f);
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        public Species.LogsAndSticks getLogsAndSticks(float volume) {
            return new Species.LogsAndSticks((Species)this, (int)(volume * 5.0f), 0);
        }

        public INodeInspector getNodeInflator(SimpleVoxmap leafMap) {
            return new NodeInflatorBamboo(this, leafMap);
        }

        public int getWorldGenAgeIterations() {
            return 6;
        }

        public int getWorldGenLeafMapHeight() {
            return 36;
        }

        public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
            return ModBlocks.blockRootyDirt;
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesBamboo.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.bamboo_forest.orNull()});
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 0;
            probMap[1] = 10;
            probMap[5] = signal.energy <= 1.0f ? 9 : 0;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
            probMap[originDir.ordinal()] = 0;
            return probMap;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.isInTrunk() && newDir != EnumFacing.UP) {
                signal.energy = 0.2f;
            }
            return newDir;
        }

        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)3) % 11);
        }
    }
}

