/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.blocks;

import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDynamicLeavesFlowering
extends BlockDynamicLeaves {
    public static final PropertyBool FAST_LEAVES = PropertyBool.func_177716_a((String)"fast_leaves");

    public BlockDynamicLeavesFlowering(String name) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HYDRO, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)FAST_LEAVES, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("dynamictreesbop", name);
        this.func_149663_c(name);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HYDRO, TREE, FAST_LEAVES});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)FAST_LEAVES, (Comparable)Boolean.valueOf(Blocks.field_150362_t.func_149662_c(state)));
    }

    protected BlockDynamicLeaves.NewLeavesPropertiesHandler getNewLeavesPropertiesHandler(World world, BlockPos pos, IBlockState state, int newHydro, boolean worldGen) {
        if (this.canFlower(state)) {
            boolean flowering;
            boolean bl = flowering = worldGen || world.func_175699_k(pos) >= 14;
            if (this.isFlowering(state) != flowering) {
                BlockDynamicLeavesFlowering.setFlowering(world, pos, flowering, state.func_177226_a((IProperty)HYDRO, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)newHydro, (int)1, (int)4))));
            }
        }
        return (w, p, l) -> {
            boolean canFlower = world.field_73012_v.nextInt(4) == 0;
            boolean flowering = canFlower && world.func_175699_k(pos) >= 14;
            return this.stateFromFlower(l, canFlower, flowering);
        };
    }

    private IBlockState stateFromFlower(IBlockState state, boolean canFlower, boolean flowering) {
        int tree = (canFlower ? 1 : 0) + (flowering ? 2 : 0);
        return state.func_177226_a((IProperty)TREE, (Comparable)Integer.valueOf(tree));
    }

    public boolean growLeavesIfLocationIsSuitable(World world, ILeavesProperties leavesProp, BlockPos pos, int hydro) {
        int n = hydro = hydro == 0 ? leavesProp.getCellKit().getDefaultHydration() : hydro;
        if (this.isLocationSuitableForNewLeaves(world, leavesProp, pos)) {
            boolean canFlower = world.field_73012_v.nextInt(4) == 0;
            boolean flowering = canFlower && world.func_175699_k(pos) >= 14;
            IBlockState state = this.stateFromFlower(this.func_176223_P(), canFlower, flowering).func_177226_a((IProperty)HYDRO, (Comparable)Integer.valueOf(hydro));
            world.func_180501_a(pos, state, 2 | (leavesProp.appearanceChangesWithHydro() ? 1 : 0));
            return true;
        }
        return false;
    }

    public boolean isFlowering(IBlockState blockState) {
        int tree = (Integer)blockState.func_177229_b((IProperty)TREE);
        return tree == 2 || tree == 3;
    }

    public boolean canFlower(IBlockState blockState) {
        int tree = (Integer)blockState.func_177229_b((IProperty)TREE);
        return tree == 1 || tree == 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setFlowering(World world, BlockPos pos, boolean flowering, IBlockState currentBlockState) {
        int tree = (Integer)currentBlockState.func_177229_b((IProperty)TREE);
        if (flowering) {
            if (tree == 0) {
                tree = 2;
            } else {
                if (tree != 1) return;
                tree = 3;
            }
        } else if (tree == 2) {
            tree = 0;
        } else {
            if (tree != 3) return;
            tree = 1;
        }
        world.func_180501_a(pos, currentBlockState.func_177226_a((IProperty)TREE, (Comparable)Integer.valueOf(tree)), 2);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

