/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities.animation;

import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandlerFallover;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandlerPhysics;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandlerVoid;
import com.ferreusveritas.dynamictrees.entities.animation.IAnimationHandler;
import net.minecraft.util.EnumFacing;

public class AnimationHandlers {
    public static final IAnimationHandler voidAnimationHandler = new AnimationHandlerVoid();
    public static final IAnimationHandler defaultAnimationHandler = new AnimationHandlerPhysics(){

        @Override
        public String getName() {
            return "default";
        }

        @Override
        public void initMotion(EntityFallingTree entity) {
            super.initMotion(entity);
            EnumFacing cutDir = entity.getDestroyData().cutDir;
            entity.field_70159_w += (double)cutDir.func_176734_d().func_82601_c() * 0.1;
            entity.field_70181_x += (double)cutDir.func_176734_d().func_96559_d() * 0.1;
            entity.field_70179_y += (double)cutDir.func_176734_d().func_82599_e() * 0.1;
        }
    };
    public static final IAnimationHandler blastAnimationHandler = new AnimationHandlerPhysics(){

        @Override
        public String getName() {
            return "blast";
        }

        @Override
        public void initMotion(EntityFallingTree entity) {
            super.initMotion(entity);
        }

        @Override
        public boolean shouldDie(EntityFallingTree entity) {
            return entity.landed || entity.field_70173_aa > 200;
        }
    };
    public static final IAnimationHandler falloverAnimationHandler = new AnimationHandlerFallover();
}

