/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.command.CommandClearOrphaned;
import com.ferreusveritas.dynamictrees.command.CommandCreateStaff;
import com.ferreusveritas.dynamictrees.command.CommandCreateTransformPotion;
import com.ferreusveritas.dynamictrees.command.CommandGetTree;
import com.ferreusveritas.dynamictrees.command.CommandGrowPulse;
import com.ferreusveritas.dynamictrees.command.CommandKillTree;
import com.ferreusveritas.dynamictrees.command.CommandPurgeTrees;
import com.ferreusveritas.dynamictrees.command.CommandRepop;
import com.ferreusveritas.dynamictrees.command.CommandRotateJoCode;
import com.ferreusveritas.dynamictrees.command.CommandSetCoordXor;
import com.ferreusveritas.dynamictrees.command.CommandSetTree;
import com.ferreusveritas.dynamictrees.command.CommandSoilLife;
import com.ferreusveritas.dynamictrees.command.CommandSpeciesList;
import com.ferreusveritas.dynamictrees.command.CommandTransform;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DTCommand
extends CommandBase {
    public static final String COMMAND = "dt";
    private final Map<String, SubCommand> commands = new HashMap<String, SubCommand>();

    private void addSubCommand(SubCommand command) {
        this.commands.put(command.getName(), command);
    }

    public DTCommand() {
        this.addSubCommand(new CommandRepop());
        this.addSubCommand(new CommandSetTree());
        this.addSubCommand(new CommandGetTree());
        this.addSubCommand(new CommandGrowPulse());
        this.addSubCommand(new CommandKillTree());
        this.addSubCommand(new CommandSoilLife());
        this.addSubCommand(new CommandSpeciesList());
        this.addSubCommand(new CommandCreateStaff());
        this.addSubCommand(new CommandRotateJoCode());
        this.addSubCommand(new CommandSetCoordXor());
        this.addSubCommand(new CommandClearOrphaned());
        this.addSubCommand(new CommandPurgeTrees());
        this.addSubCommand(new CommandTransform());
        this.addSubCommand(new CommandCreateTransformPotion());
    }

    public String func_71517_b() {
        return COMMAND;
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.dynamictrees.usage";
    }

    private String getSubCommands() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String name : this.commands.keySet()) {
            if (!first) {
                builder.append('|');
            }
            builder.append(name);
            first = false;
        }
        return builder.toString();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException("commands.dynamictrees.usage", new Object[]{this.getSubCommands()});
        }
        String subCommand = args[0];
        World world = sender.func_130014_f_();
        if (args.length >= 1) {
            if (this.commands.containsKey(subCommand)) {
                this.commands.get(subCommand).execute(world, sender, args);
            } else {
                throw new WrongUsageException("commands.dynamictrees.usage", new Object[]{this.getSubCommands()});
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return DTCommand.func_175762_a((String[])args, this.commands.keySet());
        }
        String subCommand = args[0];
        if (args.length >= 2 && this.commands.containsKey(subCommand)) {
            return this.commands.get(subCommand).getTabCompletions(server, sender, args, targetPos);
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }
}

