/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.LeavesPropertiesJson;
import com.ferreusveritas.dynamictrees.blocks.LeavesStateMapper;
import com.ferreusveritas.dynamictrees.util.JsonHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LeavesPaging {
    private static HashMap<String, HashMap<Integer, BlockDynamicLeaves>> modLeavesArray = new HashMap();
    private static HashMap<String, Integer> modLastSeq = new HashMap();

    private static String autoModId(@Nullable String modid) {
        if (modid == null || "".equals(modid)) {
            ModContainer mc = Loader.instance().activeModContainer();
            modid = mc == null ? "dynamictrees" : mc.getModId();
        }
        return modid;
    }

    public static BlockDynamicLeaves getNextLeavesBlock(@Nullable String modid, @Nonnull ILeavesProperties leavesProperties) {
        return LeavesPaging.getLeavesBlockForSequence(modid, LeavesPaging.getNextSequenceNumber(modid), leavesProperties);
    }

    public static int getNextSequenceNumber(@Nullable String modid) {
        modid = LeavesPaging.autoModId(modid);
        int seq = modLastSeq.computeIfAbsent(modid, i -> 0);
        modLastSeq.put(modid, seq + 1);
        return seq;
    }

    public static int getLastSequenceNumber(@Nullable String modid) {
        return modLastSeq.computeIfAbsent(LeavesPaging.autoModId(modid), i -> 0) - 1;
    }

    public static BlockDynamicLeaves getLeavesBlockForSequence(@Nullable String modid, int seq, @Nonnull ILeavesProperties leavesProperties) {
        BlockDynamicLeaves leaves = LeavesPaging.getLeavesBlockForSequence(modid, seq);
        int tree = seq & 3;
        leavesProperties.setDynamicLeavesState(leaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(tree)));
        leaves.setProperties(tree, leavesProperties);
        return leaves;
    }

    private static BlockDynamicLeaves getLeavesBlockForSequence(@Nullable String modid, int seq) {
        int key = seq / 4;
        String regname = "leaves" + key;
        return LeavesPaging.getLeavesMapForModId(modid).computeIfAbsent(key, k -> (BlockDynamicLeaves)new BlockDynamicLeaves().setDefaultNaming(LeavesPaging.autoModId(modid), regname));
    }

    public static Map<Integer, BlockDynamicLeaves> getLeavesMapForModId(@Nullable String modid) {
        return modLeavesArray.computeIfAbsent(LeavesPaging.autoModId(modid), k -> new HashMap());
    }

    public static Map<String, ILeavesProperties> buildAll(Object ... leavesProperties) {
        return LeavesPaging.buildAllForMod(LeavesPaging.autoModId(""), leavesProperties);
    }

    public static Map<String, ILeavesProperties> buildAllForMod(String modid, Object ... leavesProperties) {
        HashMap<String, ILeavesProperties> leafMap = new HashMap<String, ILeavesProperties>();
        for (int i = 0; i < (leavesProperties.length & 0xFFFFFFFE); i += 2) {
            String label = leavesProperties[i].toString();
            Object obj = leavesProperties[i + 1];
            ILeavesProperties newLp = LeavesProperties.NULLPROPERTIES;
            if (obj instanceof ILeavesProperties) {
                newLp = (ILeavesProperties)obj;
            } else if (obj instanceof String && !"".equals(obj)) {
                newLp = new LeavesPropertiesJson((String)obj);
            }
            LeavesPaging.getNextLeavesBlock(modid, newLp);
            leafMap.put(label, newLp);
        }
        return leafMap;
    }

    public static Map<String, ILeavesProperties> build(String jsonData) {
        return LeavesPaging.build(LeavesPaging.autoModId(""), jsonData);
    }

    public static Map<String, ILeavesProperties> build(String modid, String jsonData) {
        return LeavesPaging.build(modid, LeavesPropertiesJson.getJsonObject(jsonData));
    }

    public static Map<String, ILeavesProperties> build(JsonObject root) {
        return LeavesPaging.build(LeavesPaging.autoModId(""), root);
    }

    public static Map<String, ILeavesProperties> build(String modid, JsonObject root) {
        HashMap<String, ILeavesProperties> leafMap = new HashMap<String, ILeavesProperties>();
        if (root != null) {
            for (Map.Entry entry : root.entrySet()) {
                String label = (String)entry.getKey();
                LeavesProperties newLp = LeavesProperties.NULLPROPERTIES;
                if (!label.startsWith("-")) {
                    JsonObject jsonObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                    newLp = new LeavesPropertiesJson(jsonObj);
                }
                LeavesPaging.getNextLeavesBlock(modid, newLp);
                leafMap.put(label, newLp);
            }
        }
        return leafMap;
    }

    public static Map<String, ILeavesProperties> build(ResourceLocation jsonLocation) {
        return LeavesPaging.build(LeavesPaging.autoModId(""), jsonLocation);
    }

    public static Map<String, ILeavesProperties> build(String modid, ResourceLocation jsonLocation) {
        JsonElement element = JsonHelper.load(jsonLocation);
        if (element != null && element.isJsonObject()) {
            return LeavesPaging.build(element.getAsJsonObject());
        }
        Logger.getLogger("dynamictrees").log(Level.SEVERE, "Error building leaves paging for mod: " + modid + " at " + jsonLocation);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setStateMappers() {
        LeavesStateMapper mapper = new LeavesStateMapper();
        for (String modId : modLeavesArray.keySet()) {
            LeavesPaging.getLeavesMapForModId(modId).forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)mapper));
        }
    }

    public static void cleanUp() {
        modLeavesArray = new HashMap();
        modLastSeq = new HashMap();
    }
}

