/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuildMiner
extends WorkOrderBuildDecoration {
    private BlockPos minerBuilding;

    public WorkOrderBuildMiner() {
    }

    public WorkOrderBuildMiner(String structureName, String workOrderName, int rotation, BlockPos location, boolean mirror, BlockPos minerBuilding) {
        super(structureName, workOrderName, rotation, location, mirror);
        this.minerBuilding = minerBuilding;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound, IWorkManager manager) {
        super.readFromNBT(compound, manager);
        this.minerBuilding = BlockPosUtil.readFromNBT(compound, "pos");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        BlockPosUtil.writeToNBT(compound, "pos", this.minerBuilding);
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
    }

    @Override
    public void onRemoved(IColony colony) {
    }

    @Override
    public void onCompleted(IColony colony) {
    }

    @Override
    public boolean isValid(IColony colony) {
        return colony.getBuildingManager().getBuilding(this.minerBuilding) != null;
    }

    public BlockPos getMinerBuilding() {
        return this.minerBuilding;
    }
}

