/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.ldtteam.structurize.management.StructureName;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.AdvancementUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkManager
implements IWorkManager {
    private static final String TAG_WORK_ORDERS = "workOrders";
    private final Colony colony;
    @NotNull
    private final Map<Integer, IWorkOrder> workOrders = new LinkedHashMap<Integer, IWorkOrder>();
    private int topWorkOrderId = 0;
    private boolean dirty = false;

    public WorkManager(Colony c) {
        this.colony = c;
    }

    @Override
    public void removeWorkOrder(@NotNull IWorkOrder order) {
        this.removeWorkOrder(order.getID());
    }

    @Override
    public void removeWorkOrder(int orderId) {
        IWorkOrder workOrder = this.workOrders.get(orderId);
        if (workOrder != null) {
            this.workOrders.remove(orderId);
            this.colony.removeWorkOrderInView(orderId);
            workOrder.onRemoved(this.colony);
            this.colony.markDirty();
        }
    }

    @Override
    @Nullable
    public <W extends IWorkOrder> W getWorkOrder(int id, @NotNull Class<W> type) {
        IWorkOrder workOrder = this.getWorkOrder(id);
        if (type.isInstance(workOrder)) {
            return (W)((IWorkOrder)type.cast(workOrder));
        }
        return null;
    }

    @Override
    public IWorkOrder getWorkOrder(int id) {
        return this.workOrders.get(id);
    }

    @Override
    @Nullable
    public <W extends IWorkOrder> W getUnassignedWorkOrder(@NotNull Class<W> type) {
        for (IWorkOrder o : this.workOrders.values()) {
            if (o.isClaimed() || !type.isInstance(o)) continue;
            return (W)((IWorkOrder)type.cast(o));
        }
        return null;
    }

    @Override
    public <W extends IWorkOrder> List<W> getWorkOrdersOfType(@NotNull Class<W> type) {
        return this.workOrders.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Map<Integer, IWorkOrder> getWorkOrders() {
        return this.workOrders;
    }

    @Override
    public void clearWorkForCitizen(@NotNull ICitizenData citizen) {
        this.dirty = true;
        this.workOrders.values().stream().filter(o -> o != null && o.isClaimedBy(citizen)).forEach(IWorkOrder::clearClaimedBy);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (IWorkOrder o : this.workOrders.values()) {
            NBTTagCompound orderCompound = new NBTTagCompound();
            o.writeToNBT(orderCompound);
            list.func_74742_a((NBTBase)orderCompound);
        }
        compound.func_74782_a(TAG_WORK_ORDERS, (NBTBase)list);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.workOrders.clear();
        NBTTagList list = compound.func_150295_c(TAG_WORK_ORDERS, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound orderCompound = list.func_150305_b(i);
            AbstractWorkOrder o = AbstractWorkOrder.createFromNBT(orderCompound, this);
            if (o == null) continue;
            this.addWorkOrder(o, true);
            if (o.isClaimed() && this.colony.getBuildingManager().getBuilding(o.getClaimedBy()) == null) {
                o.clearClaimedBy();
            }
            this.topWorkOrderId = Math.max(this.topWorkOrderId, o.getID());
        }
    }

    @Override
    public void addWorkOrder(@NotNull IWorkOrder order, boolean readingFromNbt) {
        this.dirty = true;
        if (order instanceof WorkOrderBuildDecoration) {
            for (IWorkOrder or : this.workOrders.values()) {
                if (!(or instanceof WorkOrderBuildDecoration) || !((WorkOrderBuildDecoration)or).getBuildingLocation().equals((Object)((WorkOrderBuildDecoration)order).buildingLocation) || !((WorkOrderBuildDecoration)or).getStructureName().equals(((WorkOrderBuildDecoration)order).getStructureName())) continue;
                Log.getLogger().warn("Avoiding adding duplicate workOrder");
                this.removeWorkOrder(or);
                break;
            }
        }
        if (order.getID() == 0) {
            ++this.topWorkOrderId;
            order.setID(this.topWorkOrderId);
        }
        if (order instanceof WorkOrderBuildDecoration && !readingFromNbt) {
            StructureName structureName = new StructureName(((WorkOrderBuildDecoration)order).getStructureName());
            if (order instanceof WorkOrderBuildBuilding) {
                int level = ((WorkOrderBuildBuilding)order).getUpgradeLevel();
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.colony, player -> AdvancementTriggers.CREATE_BUILD_REQUEST.trigger((EntityPlayerMP)player, structureName, level));
            } else {
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.colony, player -> AdvancementTriggers.CREATE_BUILD_REQUEST.trigger((EntityPlayerMP)player, structureName, 0));
            }
        }
        this.workOrders.put(order.getID(), order);
        order.onAdded(this.colony, readingFromNbt);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        Iterator<IWorkOrder> iter = this.workOrders.values().iterator();
        while (iter.hasNext()) {
            IWorkOrder o = iter.next();
            if (!o.isValid(this.colony)) {
                iter.remove();
                this.dirty = true;
                continue;
            }
            if (!o.hasChanged()) continue;
            this.dirty = true;
            o.resetChange();
        }
    }

    @Override
    public <W extends IWorkOrder> List<W> getOrderedList(@NotNull Class<W> type, BlockPos builder) {
        return this.workOrders.values().stream().filter(o -> (!o.isClaimed() || o.getClaimedBy().equals((Object)builder)) && type.isInstance(o)).map(o -> o).sorted(Comparator.comparingInt(IWorkOrder::getPriority).reversed()).collect(Collectors.toList());
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }
}

