/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.sounds.AbstractWorkerSounds;
import com.minecolonies.api.sounds.ModSoundEvents;
import java.util.Random;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SoundUtils {
    private static final String GUARD_TOWER = "GuardTower";
    private static final int ONE_HUNDRED = 100;
    public static final double PITCH = 0.9;
    private static final Random rand = new Random();
    public static final double VOLUME = 0.5;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double PITCH_MULTIPLIER = 0.4;
    private static final int CHANCE_TO_PLAY_SOUND = 2400;

    private SoundUtils() {
    }

    public static void playRandomSound(@NotNull World worldIn, @NotNull AbstractEntityCitizen citizen, double saturation) {
        if (1 >= rand.nextInt(2400)) {
            String prefix = "";
            if (citizen.getCitizenColonyHandler().getWorkBuilding() != null) {
                prefix = citizen.getCitizenColonyHandler().getWorkBuilding().getJobName();
            }
            if (citizen.func_70631_g_()) {
                prefix = "child";
            }
            if (GUARD_TOWER.equals(prefix) && citizen.getCitizenColonyHandler().getWorkBuilding() instanceof IGuardBuilding) {
                prefix = ((IGuardBuilding)citizen.getCitizenColonyHandler().getWorkBuilding()).getGuardType().getWorkerSoundName();
            }
            for (AbstractWorkerSounds sounds : ModSoundEvents.handlers) {
                if (!sounds.getWorkerString().equals(prefix)) continue;
                sounds.playSound(worldIn, citizen.func_180425_c(), citizen.isFemale(), saturation);
            }
        }
    }

    public static void playSoundAtCitizen(@NotNull World worldIn, @NotNull BlockPos position, @NotNull SoundEvent event) {
        worldIn.func_184133_a(null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
    }

    public static void playSoundAtCitizenWithChance(@NotNull World worldIn, @NotNull BlockPos position, @Nullable SoundEvent event, int chance) {
        if (event == null || Configurations.gameplay.disableCitizenVoices) {
            return;
        }
        if (chance > rand.nextInt(100)) {
            worldIn.func_184133_a(null, position, event, SoundCategory.NEUTRAL, 0.5f, 0.9f);
        }
    }

    public static void playInteractionSoundAtCitizenWithChance(@NotNull World world, @NotNull BlockPos position, int chance, @NotNull AbstractEntityCitizen citizen) {
        if (chance > rand.nextInt(100)) {
            String prefix = "";
            if (citizen instanceof AbstractEntityCitizen) {
                if (citizen.getCitizenColonyHandler().getWorkBuilding() != null) {
                    prefix = citizen.getCitizenColonyHandler().getWorkBuilding().getJobName();
                }
                if (GUARD_TOWER.equals(prefix) && citizen.getCitizenColonyHandler().getWorkBuilding() instanceof IGuardBuilding) {
                    prefix = ((IGuardBuilding)citizen.getCitizenColonyHandler().getWorkBuilding()).getGuardType().getWorkerSoundName();
                }
            }
            for (AbstractWorkerSounds sounds : ModSoundEvents.handlers) {
                if (!sounds.getWorkerString().equals(prefix)) continue;
                sounds.playInteractionSound(world, citizen.func_180425_c(), citizen.isFemale());
            }
        }
    }

    public static double getRandomPitch(Random random) {
        return 1.0 / (random.nextDouble() * 0.4 + 0.8);
    }
}

