/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.steelworks.blocks;

import java.util.Locale;
import javax.annotation.Nullable;
import knightminer.tcomplement.library.TCompRegistry;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.mantle.block.EnumBlock;

public class BlockStorage
extends EnumBlock<StorageType> {
    public static final PropertyEnum<StorageType> TYPE = PropertyEnum.func_177709_a((String)"type", StorageType.class);

    public BlockStorage() {
        super(Material.field_151573_f, TYPE, StorageType.class);
        this.func_149711_c(5.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a((CreativeTabs)TCompRegistry.tabGeneral);
        for (StorageType type : StorageType.values()) {
            this.setHarvestLevel("pickaxe", type.getHarvestLevel(), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)));
        }
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && state.func_177229_b(TYPE) == StorageType.CHARCOAL;
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && state.func_177229_b(TYPE) == StorageType.STEEL;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (state.func_177229_b(TYPE) == StorageType.CHARCOAL) {
            return SoundType.field_185851_d;
        }
        return SoundType.field_185852_e;
    }

    public static enum StorageType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        CHARCOAL(0),
        STEEL(2);

        private final int meta = this.ordinal();
        private final int harvestLevel;

        private StorageType(int harvestLevel) {
            this.harvestLevel = harvestLevel;
        }

        public int getHarvestLevel() {
            return this.harvestLevel;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

