/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.shared;

import com.google.common.eventbus.Subscribe;
import knightminer.tcomplement.common.CommonProxy;
import knightminer.tcomplement.common.Config;
import knightminer.tcomplement.common.PulseBase;
import knightminer.tcomplement.library.TCompRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.item.ItemEdible;
import slimeknights.mantle.item.ItemMetaDynamic;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.fluid.FluidColored;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.item.CastCustom;

@Pulse(id="ModuleCommons", description="Core feature for all the modules", forced=true)
public class CommonsModule
extends PulseBase {
    public static final String pulseID = "ModuleCommons";
    @SidedProxy(clientSide="knightminer.tcomplement.shared.CommonsClientProxy", serverSide="knightminer.tcomplement.common.CommonProxy")
    public static CommonProxy proxy;
    public static ItemMetaDynamic materials;
    public static ItemEdible edibles;
    public static CastCustom cast;
    public static CastCustom castClay;
    public static ItemStack stoneBucket;
    public static ItemStack castBucket;
    public static ItemStack castBucketClay;
    public static ItemStack scorchedBrick;
    public static ItemStack steelIngot;
    public static ItemStack steelNugget;
    public static ItemStack iModifier;
    public static ItemStack milkChocolateIngot;
    public static ItemStack milkChocolateNugget;
    public static ItemStack darkChocolateIngot;
    public static ItemStack darkChocolateNugget;
    public static ItemStack cocoaButter;
    public static Fluid chocolateLiquor;
    public static Fluid milkChocolate;
    public static Fluid darkChocolate;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        if (Config.general.chocolate && CommonsModule.isSmelteryLoaded()) {
            chocolateLiquor = CommonsModule.registerFluid(new Fluid("chocolate_liquor", FluidColored.ICON_StoneStill, FluidColored.ICON_StoneFlowing, -12508659).setTemperature(500));
            milkChocolate = CommonsModule.registerFluid(new Fluid("milk_chocolate", FluidColored.ICON_StoneStill, FluidColored.ICON_StoneFlowing, -9288664).setTemperature(400));
            if (CommonsModule.isSteelworksLoaded()) {
                darkChocolate = CommonsModule.registerFluid(new Fluid("dark_chocolate", FluidColored.ICON_StoneStill, FluidColored.ICON_StoneFlowing, -14808576).setTemperature(450));
            }
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        if (Config.general.chocolate && CommonsModule.isSmelteryLoaded()) {
            CommonsModule.registerFluidBlock((IForgeRegistry<Block>)r, chocolateLiquor);
            CommonsModule.registerFluidBlock((IForgeRegistry<Block>)r, milkChocolate);
            if (CommonsModule.isSteelworksLoaded()) {
                CommonsModule.registerFluidBlock((IForgeRegistry<Block>)r, darkChocolate);
            }
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        materials = CommonsModule.registerItem((IForgeRegistry<Item>)r, new ItemMetaDynamic(), "materials");
        materials.func_77637_a((CreativeTabs)TCompRegistry.tabGeneral);
        if (CommonsModule.isSmelteryLoaded()) {
            cast = CommonsModule.registerItem((IForgeRegistry<Item>)r, new CastCustom(), "cast");
            cast.func_77637_a((CreativeTabs)TCompRegistry.tabGeneral);
            castClay = CommonsModule.registerItem((IForgeRegistry<Item>)r, new CastCustom(), "cast_clay");
            castClay.func_77637_a((CreativeTabs)TCompRegistry.tabGeneral);
            if (Config.general.bucketCast) {
                stoneBucket = materials.addMeta(0, "stone_bucket");
                castBucket = cast.addMeta(0, "bucket", 144);
                castBucketClay = castClay.addMeta(0, "bucket", 144);
            }
            if (Config.general.chocolate) {
                edibles = CommonsModule.registerItem((IForgeRegistry<Item>)r, new ItemEdible(), "edibles");
                edibles.func_77637_a((CreativeTabs)TCompRegistry.tabGeneral);
                milkChocolateIngot = edibles.addFood(10, 3, 0.3f, "milk_chocolate_ingot", new PotionEffect[0]);
                milkChocolateNugget = edibles.addFood(20, 1, 0.05f, "milk_chocolate_nugget", new PotionEffect[0]);
                cocoaButter = edibles.addFood(30, 2, 0.2f, "cocoa_butter", new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 200)});
                if (CommonsModule.isSteelworksLoaded()) {
                    darkChocolateIngot = edibles.addFood(11, 4, 0.4f, "dark_chocolate_ingot", new PotionEffect[0]);
                    darkChocolateNugget = edibles.addFood(21, 1, 0.1f, "dark_chocolate_nugget", new PotionEffect[0]);
                }
                FluidRegistry.addBucketForFluid((Fluid)chocolateLiquor);
                FluidRegistry.addBucketForFluid((Fluid)milkChocolate);
                if (CommonsModule.isSteelworksLoaded()) {
                    FluidRegistry.addBucketForFluid((Fluid)darkChocolate);
                }
            }
        }
        if (CommonsModule.isSteelworksLoaded()) {
            scorchedBrick = materials.addMeta(1, "scorched_brick");
            steelIngot = materials.addMeta(10, "steel_ingot");
            steelNugget = materials.addMeta(20, "steel_nugget");
        }
        if (CommonsModule.isChiselPluginLoaded()) {
            iModifier = materials.addMeta(6, "imodifier");
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        this.registerMeltingCasting();
        proxy.postInit();
    }

    private void registerMeltingCasting() {
        if (CommonsModule.isSmelteryLoaded()) {
            if (Config.general.bucketCast) {
                TinkerRegistry.registerTableCasting((ItemStack)new ItemStack(Items.field_151133_ar), (ItemStack)castBucket, (Fluid)TinkerFluids.iron, (int)432);
                for (FluidStack fs : TinkerSmeltery.castCreationFluids) {
                    TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(castBucket, (RecipeMatch)new RecipeMatch.Item(stoneBucket, 1), fs, true, true));
                }
                TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(new ItemStack(Items.field_151133_ar), RecipeMatch.of((ItemStack)castBucketClay), (Fluid)TinkerFluids.iron, 432, true, false));
                for (FluidStack fs : TinkerSmeltery.clayCreationFluids) {
                    TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(castBucketClay, (RecipeMatch)new RecipeMatch.Item(stoneBucket, 1), fs, true, true));
                }
            }
            if (Config.general.chocolate) {
                TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(milkChocolateIngot.func_77946_l(), RecipeMatch.of((ItemStack)TinkerSmeltery.castIngot), milkChocolate, 144, 60));
                TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(milkChocolateNugget.func_77946_l(), RecipeMatch.of((ItemStack)TinkerSmeltery.castNugget), milkChocolate, 16, 20));
                TinkerRegistry.registerMelting((ItemStack)milkChocolateIngot, (Fluid)milkChocolate, (int)144);
                TinkerRegistry.registerMelting((ItemStack)milkChocolateNugget, (Fluid)milkChocolate, (int)16);
                if (CommonsModule.isSteelworksLoaded()) {
                    TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(darkChocolateIngot.func_77946_l(), RecipeMatch.of((ItemStack)TinkerSmeltery.castIngot), darkChocolate, 144, 80));
                    TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(darkChocolateNugget.func_77946_l(), RecipeMatch.of((ItemStack)TinkerSmeltery.castNugget), darkChocolate, 16, 30));
                    TinkerRegistry.registerMelting((ItemStack)darkChocolateIngot, (Fluid)darkChocolate, (int)144);
                    TinkerRegistry.registerMelting((ItemStack)darkChocolateNugget, (Fluid)darkChocolate, (int)16);
                }
                TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(cocoaButter.func_77946_l(), RecipeMatch.of((ItemStack)TinkerSmeltery.castIngot), chocolateLiquor, 144, 80));
                ItemStack cocoaBeans = new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b());
                TinkerRegistry.registerMelting((ItemStack)cocoaBeans, (Fluid)chocolateLiquor, (int)(Material.VALUE_Ore() / 3));
                if (CommonsModule.isMelterLoaded()) {
                    TCompRegistry.registerMelterOverride(new MeltingRecipe(RecipeMatch.of((ItemStack)cocoaBeans, (int)((int)(144.0 * Config.melter.oreToIngotRatio / 3.0))), chocolateLiquor));
                }
                if (CommonsModule.isMelterLoaded()) {
                    TCompRegistry.registerHighOvenOverride(new MeltingRecipe(RecipeMatch.of((ItemStack)cocoaBeans, (int)((int)(144.0 * Config.highOven.oreToIngotRatio / 3.0))), chocolateLiquor));
                }
                TinkerRegistry.registerAlloy((FluidStack)new FluidStack(milkChocolate, 16), (FluidStack[])new FluidStack[]{new FluidStack(chocolateLiquor, 8), new FluidStack((Fluid)TinkerFluids.milk, 20)});
            }
        }
    }
}

